/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableList;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.palladiosimulator.simexp.commons.constants.model.ModelFileTypeConstants;
import org.palladiosimulator.simexp.commons.constants.model.QualityObjective;
import org.palladiosimulator.simexp.commons.constants.model.SimulationConstants;
import org.palladiosimulator.simexp.commons.constants.model.SimulationEngine;
import org.palladiosimulator.simexp.ui.workflow.config.EditRepositoryDialog;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.ConditionalUpdateListStrategy;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.ConditionalUpdateValueStrategy;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.ConfigurationProperties;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.UpdateStrategyController;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.CompoundStringValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.ControllableValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.EnumEnabler;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.ExtensionValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.FileURIValidator;

public class SimulatorConfiguration {
    private SelectObservableValue<SimulationEngine> simulationEngineTarget;
    private SelectObservableValue<QualityObjective> qualityObjectiveTarget;
    private Text textMonitorRepository;
    private ListViewer monitors;
    private WritableList<String> moduleFilesTarget;
    private WritableList<String> propertyFilesTarget;

    public void createControl(Composite parent, DataBindingContext ctx, final ModifyListener modifyListener) {
        Composite simulationParent = new Composite(parent, 2048);
        simulationParent.setLayoutData((Object)new GridData(4, 4, true, true));
        simulationParent.setLayout((Layout)new GridLayout(2, false));
        Composite simulationEngineContainer = new Composite(simulationParent, 0);
        simulationEngineContainer.setLayoutData((Object)new GridData(0, 128, false, true));
        simulationEngineContainer.setLayout((Layout)new GridLayout());
        Group simulationEngineGroup = new Group(simulationEngineContainer, 0);
        simulationEngineGroup.setText("Simulation Engine");
        simulationEngineGroup.setLayout((Layout)new RowLayout(512));
        this.simulationEngineTarget = new SelectObservableValue();
        final HashMap<SimulationEngine, Composite> engineDetailsMap = new HashMap<SimulationEngine, Composite>();
        final Composite simulationDetails = new Composite(simulationParent, 0);
        SimulationEngine[] simulationEngineArray = SimulationEngine.values();
        int n = simulationEngineArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulationEngine engine = simulationEngineArray[n2];
            Button button = new Button((Composite)simulationEngineGroup, 16);
            button.setText(engine.getName());
            ISWTObservableValue observeable = WidgetProperties.buttonSelection().observe((Widget)button);
            this.simulationEngineTarget.addOption((Object)engine, (IObservableValue)observeable);
            ++n2;
        }
        ISideEffect.create(() -> (SimulationEngine)this.simulationEngineTarget.getValue(), (Consumer)new Consumer<SimulationEngine>(){

            @Override
            public void accept(SimulationEngine selectedEngine) {
                for (Map.Entry entry : engineDetailsMap.entrySet()) {
                    Composite detailsComposite = (Composite)entry.getValue();
                    GridData layoutData = (GridData)detailsComposite.getLayoutData();
                    if (selectedEngine == entry.getKey()) {
                        layoutData.exclude = false;
                        detailsComposite.setVisible(true);
                        continue;
                    }
                    layoutData.exclude = true;
                    detailsComposite.setVisible(false);
                }
                simulationDetails.layout();
                modifyListener.modifyText(null);
            }
        });
        simulationDetails.setLayoutData((Object)new GridData(4, 4, true, true));
        simulationDetails.setLayout((Layout)new GridLayout());
        Composite pcmDetails = this.createEngineDetailsComposite(simulationDetails, SimulationEngine.PCM);
        this.createPcmTab(pcmDetails, ctx, modifyListener);
        engineDetailsMap.put(SimulationEngine.PCM, pcmDetails);
        Composite prismDetails = this.createEngineDetailsComposite(simulationDetails, SimulationEngine.PRISM);
        this.createPrismTab(prismDetails, modifyListener);
        engineDetailsMap.put(SimulationEngine.PRISM, prismDetails);
    }

    private Composite createEngineDetailsComposite(Composite parent, SimulationEngine engine) {
        Group content = new Group(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.exclude = true;
        content.setLayoutData((Object)layoutData);
        content.setVisible(false);
        content.setLayout((Layout)new GridLayout());
        content.setText(engine.getName());
        return content;
    }

    private void createPcmTab(Composite parent, DataBindingContext ctx, final ModifyListener modifyListener) {
        Group qualityObjectivesGroup = new Group(parent, 0);
        qualityObjectivesGroup.setText("Quality Objective");
        qualityObjectivesGroup.setLayout((Layout)new RowLayout(256));
        final HashMap<QualityObjective, List<String>> simulationKindMonitorItems = new HashMap<QualityObjective, List<String>>();
        simulationKindMonitorItems.put(QualityObjective.PERFORMANCE, Arrays.asList("System Response Time"));
        simulationKindMonitorItems.put(QualityObjective.RELIABILITY, Arrays.asList("System Response Time"));
        simulationKindMonitorItems.put(QualityObjective.PERFORMABILITY, Arrays.asList("System Response Time", "System ExecutionResultType"));
        this.qualityObjectiveTarget = new SelectObservableValue();
        QualityObjective[] qualityObjectiveArray = QualityObjective.values();
        int n = qualityObjectiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            QualityObjective kind = qualityObjectiveArray[n2];
            Button button = new Button((Composite)qualityObjectivesGroup, 16);
            button.setText(kind.getName());
            ISWTObservableValue observeable = WidgetProperties.buttonSelection().observe((Widget)button);
            this.qualityObjectiveTarget.addOption((Object)kind, (IObservableValue)observeable);
            ++n2;
        }
        this.qualityObjectiveTarget.setValue((Object)QualityObjective.PERFORMANCE);
        ISideEffect.create(() -> (QualityObjective)this.qualityObjectiveTarget.getValue(), (Consumer)new Consumer<QualityObjective>(){

            @Override
            public void accept(QualityObjective selectedKind) {
                if (selectedKind == null) {
                    return;
                }
                modifyListener.modifyText(null);
            }
        });
        Shell shell = parent.getShell();
        this.textMonitorRepository = new Text(parent, 2052);
        TabHelper.createFileInputSection((Composite)parent, (ModifyListener)modifyListener, (String)"Monitor Repository File", (String[])ModelFileTypeConstants.MONITOR_REPOSITORY_FILE_EXTENSION, (Text)this.textMonitorRepository, (String)"Select Monitor Repository File", (Shell)shell, (String)"");
        Group monitorsGroup = new Group(parent, 0);
        monitorsGroup.setText("Monitors");
        monitorsGroup.setLayout((Layout)new GridLayout(1, false));
        monitorsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.monitors = new ListViewer((Composite)monitorsGroup, 2050);
        this.monitors.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ObservableListContentProvider observableInput = new ObservableListContentProvider();
        this.monitors.setContentProvider((IContentProvider)observableInput);
        ISWTObservableList monitorsTarget = WidgetProperties.items().observe((Widget)this.monitors.getList());
        IObservableFactory<QualityObjective, IObservableList<String>> detailFactory = new IObservableFactory<QualityObjective, IObservableList<String>>(){

            public IObservableList<String> createObservable(QualityObjective master) {
                WritableList listModel = new WritableList((List)simulationKindMonitorItems.get(master), String.class);
                return listModel;
            }
        };
        IObservableList monitorsModel = MasterDetailObservables.detailList(this.qualityObjectiveTarget, (IObservableFactory)detailFactory, String.class);
        ctx.bindList((IObservableList)monitorsTarget, monitorsModel, new UpdateListStrategy(UpdateValueStrategy.POLICY_NEVER), null);
    }

    private void createPrismTab(Composite parent, ModifyListener modifyListener) {
        Group modulesParent = new Group(parent, 0);
        modulesParent.setLayout((Layout)new GridLayout(2, false));
        modulesParent.setLayoutData((Object)new GridData(4, 4, true, true));
        modulesParent.setText("Module Files");
        this.moduleFilesTarget = this.createPrismList((Composite)modulesParent, modifyListener, "Module File", ModelFileTypeConstants.PRISM_MODULE_FILE_EXTENSION);
        Group propertiesParent = new Group(parent, 0);
        propertiesParent.setLayout((Layout)new GridLayout(2, false));
        propertiesParent.setLayoutData((Object)new GridData(4, 4, true, true));
        propertiesParent.setText("Property Files");
        this.propertyFilesTarget = this.createPrismList((Composite)propertiesParent, modifyListener, "Property File", ModelFileTypeConstants.PRISM_PROPERTY_FILE_EXTENSION);
    }

    private WritableList<String> createPrismList(final Composite parent, final ModifyListener modifyListener, final String type, final String[] extension) {
        final ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ObservableListContentProvider modulesObservableInput = new ObservableListContentProvider();
        listViewer.setContentProvider((IContentProvider)modulesObservableInput);
        final WritableList filesInput = new WritableList();
        listViewer.setInput((Object)filesInput);
        Composite buttonParent = new Composite(parent, 0);
        buttonParent.setLayout((Layout)new GridLayout());
        buttonParent.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        Button addButton = new Button(buttonParent, 8);
        addButton.setText("Add...");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditRepositoryDialog dialog = new EditRepositoryDialog(parent.getShell(), "Add " + type, type, extension);
                if (dialog.open() == 0) {
                    String uri = dialog.getRepositoryModelUri();
                    filesInput.add((Object)uri);
                    modifyListener.modifyText(null);
                }
            }
        });
        Button editButton = new Button(buttonParent, 8);
        editButton.setText("Edit...");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = listViewer.getStructuredSelection();
                if (selection.isEmpty()) {
                    return;
                }
                String selectedUri = (String)selection.getFirstElement();
                EditRepositoryDialog dialog = new EditRepositoryDialog(parent.getShell(), "Edit " + type, type, extension, selectedUri);
                if (dialog.open() == 0) {
                    String uri = dialog.getRepositoryModelUri();
                    int index = filesInput.indexOf((Object)selectedUri);
                    filesInput.remove(index);
                    filesInput.add(index, (Object)uri);
                    modifyListener.modifyText(null);
                }
            }
        });
        Button removeButton = new Button(buttonParent, 8);
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = listViewer.getStructuredSelection();
                if (selection.isEmpty()) {
                    return;
                }
                String selectedUri = (String)selection.getFirstElement();
                filesInput.remove((Object)selectedUri);
                modifyListener.modifyText(null);
            }
        });
        return filesInput;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Simulation Engine", SimulationConstants.DEFAULT_SIMULATION_ENGINE.name());
    }

    public void initializeFrom(ILaunchConfiguration configuration, DataBindingContext ctx) {
        IObservableValue simulationEngineModel = ConfigurationProperties.enummeration("Simulation Engine", SimulationEngine.class).observe((Object)configuration);
        UpdateValueStrategy simulationEngineUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        ctx.bindValue(this.simulationEngineTarget, simulationEngineModel, simulationEngineUpdateStrategy, null);
        this.initializeFromPCM(configuration, ctx);
        this.initializeFromPRISM(configuration, ctx);
    }

    private void initializeFromPCM(ILaunchConfiguration configuration, DataBindingContext ctx) {
        UpdateStrategyController pcmUpdateController = new UpdateStrategyController(){

            @Override
            public boolean isEnabled() {
                return SimulatorConfiguration.this.simulationEngineTarget.getValue() == SimulationEngine.PCM;
            }
        };
        EnumEnabler<SimulationEngine> isPcmEnabled = new EnumEnabler<SimulationEngine>(SimulationEngine.PCM, this.simulationEngineTarget);
        IObservableValue qualityObjectiveModel = ConfigurationProperties.enummeration("Quality Objective", QualityObjective.class).observe((Object)configuration);
        ConditionalUpdateValueStrategy qualityObjectiveUpdateStrategy = new ConditionalUpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT, pcmUpdateController);
        ctx.bindValue(this.qualityObjectiveTarget, qualityObjectiveModel, qualityObjectiveUpdateStrategy, new ConditionalUpdateValueStrategy(pcmUpdateController));
        ISWTObservableValue monitorRepositoryTarget = WidgetProperties.text((int)24).observe((Widget)this.textMonitorRepository);
        IObservableValue monitorRepositoryModel = ConfigurationProperties.string("monitorRepositoryFile").observe((Object)configuration);
        ConditionalUpdateValueStrategy monitorRepositoryUpdateStrategy = new ConditionalUpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT, pcmUpdateController);
        ControllableValidator<String> monitorRepositoryValidator = new ControllableValidator<String>(new CompoundStringValidator(Arrays.asList(new FileURIValidator("Monitor Repository File"), new ExtensionValidator("Monitor Repository File", ModelFileTypeConstants.MONITOR_REPOSITORY_FILE_EXTENSION[0]))), isPcmEnabled);
        monitorRepositoryUpdateStrategy.setBeforeSetValidator(monitorRepositoryValidator);
        Binding monitorRepositoryBindValue = ctx.bindValue((IObservableValue)monitorRepositoryTarget, monitorRepositoryModel, monitorRepositoryUpdateStrategy, new ConditionalUpdateValueStrategy(pcmUpdateController));
        ControlDecorationSupport.create((ValidationStatusProvider)monitorRepositoryBindValue, (int)131200);
        ISWTObservableList monitorTarget = WidgetProperties.items().observe((Widget)this.monitors.getList());
        IObservableList monitorModel = ConfigurationProperties.list("monitors").observe((Object)configuration);
        ConditionalUpdateListStrategy monitorsTargetToModel = new ConditionalUpdateListStrategy(UpdateValueStrategy.POLICY_CONVERT, pcmUpdateController);
        ConditionalUpdateListStrategy monitorsModelToTarget = new ConditionalUpdateListStrategy(UpdateValueStrategy.POLICY_NEVER, pcmUpdateController);
        ctx.bindList((IObservableList)monitorTarget, monitorModel, monitorsTargetToModel, monitorsModelToTarget);
    }

    private void initializeFromPRISM(ILaunchConfiguration configuration, DataBindingContext ctx) {
        UpdateStrategyController prismUpdateController = new UpdateStrategyController(){

            @Override
            public boolean isEnabled() {
                return SimulatorConfiguration.this.simulationEngineTarget.getValue() == SimulationEngine.PRISM;
            }
        };
        IObservableList moduleFilesModel = ConfigurationProperties.list("prismModuleFile").observe((Object)configuration);
        ConditionalUpdateListStrategy moduleFilesUpdateStrategyTargetToModel = new ConditionalUpdateListStrategy(UpdateValueStrategy.POLICY_CONVERT, prismUpdateController);
        ConditionalUpdateListStrategy moduleFilesUpdateStrategyModelToTarget = new ConditionalUpdateListStrategy(prismUpdateController);
        Binding moduleFilesBindValue = ctx.bindList(this.moduleFilesTarget, moduleFilesModel, moduleFilesUpdateStrategyTargetToModel, moduleFilesUpdateStrategyModelToTarget);
        ControlDecorationSupport.create((ValidationStatusProvider)moduleFilesBindValue, (int)131200);
        IObservableList propertyFilesModel = ConfigurationProperties.list("prismPropertyFile").observe((Object)configuration);
        ConditionalUpdateListStrategy propertyFilesUpdateStrategyTargetToModel = new ConditionalUpdateListStrategy(UpdateValueStrategy.POLICY_CONVERT, prismUpdateController);
        ConditionalUpdateListStrategy propertyFilesUpdateStrategyModelToTarget = new ConditionalUpdateListStrategy(prismUpdateController);
        Binding propertyFilesBindValue = ctx.bindList(this.propertyFilesTarget, propertyFilesModel, propertyFilesUpdateStrategyTargetToModel, propertyFilesUpdateStrategyModelToTarget);
        ControlDecorationSupport.create((ValidationStatusProvider)propertyFilesBindValue, (int)131200);
    }
}

