/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.simexp.ui.workflow.config.IModelValueProvider;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.ConfigurationProperties;
import org.palladiosimulator.simexp.workflow.trafo.ITrafoNameProvider;

public class TransformationConfiguration {
    private final IModelValueProvider modelValueProvider;
    private final ITrafoNameProvider trafoNameProvider;
    private CheckboxTableViewer viewer;

    public TransformationConfiguration(IModelValueProvider modelValueProvider, ITrafoNameProvider trafoNameProvider) {
        this.modelValueProvider = modelValueProvider;
        this.trafoNameProvider = trafoNameProvider;
    }

    public void createControl(Composite parent, DataBindingContext ctx, final ModifyListener modifyListener) {
        Group container = new Group(parent, 0);
        container.setText("Transformations");
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        container.setLayout((Layout)new GridLayout());
        Label simulationIDLabel = new Label((Composite)container, 0);
        simulationIDLabel.setText("Active transformations:");
        this.viewer = CheckboxTableViewer.newCheckList((Composite)container, (int)68354);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ObservableListContentProvider observableInput = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)observableInput);
        WritableList availableTransformationsList = new WritableList();
        IObservableList transformations = ComputedList.create(() -> {
            IObservableValue<String> experimentsModel = this.modelValueProvider.getExperimentsModel();
            String experimentsModelValue = (String)experimentsModel.getValue();
            URI experimentsFile = URI.createURI((String)experimentsModelValue);
            List availableTransformations = this.trafoNameProvider.getAvailableTransformations(experimentsFile);
            availableTransformationsList.clear();
            availableTransformationsList.addAll((Collection)availableTransformations);
            return availableTransformationsList;
        });
        this.viewer.setInput((Object)transformations);
        ISideEffect.create(() -> {
            IObservableSet observe = ViewerProperties.checkedElements(String.class).observe((Object)this.viewer);
            return new LinkedHashSet(observe);
        }, (Consumer)new Consumer<Set<String>>(){

            @Override
            public void accept(Set<String> checked) {
                modifyListener.modifyText(null);
            }
        });
    }

    public void initializeFrom(ILaunchConfigurationWorkingCopy configuration, DataBindingContext ctx) {
        IObservableSet target = ViewerProperties.checkedElements(String.class).observe((Object)this.viewer);
        IObservableSet model = ConfigurationProperties.set("TransformationsActive").observe((Object)configuration);
        UpdateSetStrategy updateStrategy = new UpdateSetStrategy(UpdateValueStrategy.POLICY_CONVERT);
        ctx.bindSet(target, model, updateStrategy, null);
    }
}

