/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config.databinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

class ConfigurationObservableListValue
extends AbstractObservableList<String> {
    private final ILaunchConfiguration configuration;
    private final String key;

    public ConfigurationObservableListValue(ILaunchConfiguration configuration, String key) {
        this.configuration = configuration;
        this.key = key;
    }

    public Object getElementType() {
        return String.class;
    }

    private List<String> getConfigList() {
        try {
            List list = this.configuration.getAttribute(this.key, Collections.emptyList());
            return list;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getReadOnlyList() {
        return Collections.unmodifiableList(this.getConfigList());
    }

    private List<String> getModifyableList() {
        return new ArrayList<String>(this.getConfigList());
    }

    public String get(int index) {
        List<String> list = this.getReadOnlyList();
        return list.get(index);
    }

    protected int doGetSize() {
        List<String> list = this.getReadOnlyList();
        return list.size();
    }

    public String set(int index, String element) {
        if (this.configuration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
            List<String> list = this.getModifyableList();
            String previous = list.set(index, element);
            launchConfigurationWorkingCopy.setAttribute(this.key, list);
            return previous;
        }
        throw new RuntimeException("not supported");
    }

    public void add(int index, String element) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        List<String> list = this.getModifyableList();
        list.add(index, element);
        launchConfigurationWorkingCopy.setAttribute(this.key, list);
    }

    public String remove(int index) {
        if (this.configuration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
            List<String> list = this.getModifyableList();
            String previous = list.remove(index);
            launchConfigurationWorkingCopy.setAttribute(this.key, list);
            return previous;
        }
        throw new RuntimeException("not supported");
    }
}

