/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config.databinding;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

class ConfigurationObservableSetValue
extends AbstractObservableSet<String> {
    private final ILaunchConfiguration configuration;
    private final String key;

    public ConfigurationObservableSetValue(ILaunchConfiguration configuration, String key) {
        this.configuration = configuration;
        this.key = key;
    }

    public Object getElementType() {
        return String.class;
    }

    private Set<String> getConfigSet() {
        try {
            Set set = this.configuration.getAttribute(this.key, Collections.emptySet());
            return set;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getReadOnlySet() {
        return Collections.unmodifiableSet(this.getConfigSet());
    }

    private Set<String> getModifyableSet() {
        return new LinkedHashSet<String>(this.getConfigSet());
    }

    protected Set<String> getWrappedSet() {
        return this.getReadOnlySet();
    }

    public boolean add(String element) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        Set<String> set = this.getModifyableSet();
        boolean added = set.add(element);
        launchConfigurationWorkingCopy.setAttribute(this.key, set);
        return added;
    }

    public boolean addAll(Collection<? extends String> c) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        Set<String> set = this.getModifyableSet();
        boolean added = set.addAll(c);
        launchConfigurationWorkingCopy.setAttribute(this.key, set);
        return added;
    }

    public boolean remove(Object element) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        Set<String> set = this.getModifyableSet();
        boolean removed = set.remove(element);
        launchConfigurationWorkingCopy.setAttribute(this.key, set);
        return removed;
    }

    public boolean removeAll(Collection<?> c) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        Set<String> set = this.getModifyableSet();
        boolean removed = set.removeAll(c);
        launchConfigurationWorkingCopy.setAttribute(this.key, set);
        return removed;
    }

    public boolean retainAll(Collection<?> c) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        Set<String> set = this.getModifyableSet();
        boolean retained = set.retainAll(c);
        launchConfigurationWorkingCopy.setAttribute(this.key, set);
        return retained;
    }

    public void clear() {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        launchConfigurationWorkingCopy.setAttribute(this.key, Collections.emptySet());
    }
}

