/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.palladiosimulator.simexp.commons.constants.model.ModelFileTypeConstants;
import org.palladiosimulator.simexp.commons.constants.model.SimulationConstants;
import org.palladiosimulator.simexp.commons.constants.model.SimulatorType;
import org.palladiosimulator.simexp.ui.workflow.config.IModelValueProvider;
import org.palladiosimulator.simexp.ui.workflow.config.SimulatorConfiguration;
import org.palladiosimulator.simexp.ui.workflow.config.TransformationConfiguration;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.ConfigurationProperties;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.CompoundStringValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.ControllableValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.EnumEnabler;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.ExtensionValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.FileURIValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.MinIntegerValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.NotEmptyValidator;
import org.palladiosimulator.simexp.ui.workflow.config.debug.BaseLaunchConfigurationTab;
import org.palladiosimulator.simexp.workflow.trafo.ITrafoNameProvider;

public class SimExpConfigurationTab
extends BaseLaunchConfigurationTab {
    public static final String PLUGIN_ID = "org.palladiosimulator.analyzer.workflow";
    public static final String CONFIGURATION_TAB_IMAGE_PATH = "icons/configuration_tab.gif";
    private final TransformationConfiguration transformationConfiguration;
    private final SimulatorConfiguration simulatorConfiguration;
    private Text textSimulationID;
    private Text textNumberOfRuns;
    private Text textNumerOfSimulationsPerRun;
    private Text textCustomSeed;
    private SelectObservableValue<SimulatorType> simulatorTypeTarget;
    private Text textSModel;

    public SimExpConfigurationTab(DataBindingContext ctx, IModelValueProvider modelValueProvider, ITrafoNameProvider trafoNameProvider) {
        super(ctx);
        this.transformationConfiguration = new TransformationConfiguration(modelValueProvider, trafoNameProvider);
        this.simulatorConfiguration = new SimulatorConfiguration();
    }

    @Override
    public void doCreateControl(Composite parent, DataBindingContext ctx) {
        BaseLaunchConfigurationTab.SimExpModifyListener modifyListener = new BaseLaunchConfigurationTab.SimExpModifyListener();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Composite simContainer = new Composite(container, 0);
        simContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout simContainerLayout = new GridLayout(2, false);
        simContainerLayout.marginWidth = 0;
        simContainer.setLayout((Layout)simContainerLayout);
        this.createSimulation(simContainer, modifyListener);
        this.transformationConfiguration.createControl(simContainer, ctx, modifyListener);
        this.createSimulatorType(container, modifyListener);
        this.simulatorConfiguration.createControl(container, ctx, modifyListener);
    }

    private void createSimulation(Composite parent, ModifyListener modifyListener) {
        Group container = new Group(parent, 0);
        container.setText("Basics");
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        container.setLayout((Layout)new GridLayout());
        Label simulationIDLabel = new Label((Composite)container, 0);
        simulationIDLabel.setText("Simulation-ID:");
        this.textSimulationID = new Text((Composite)container, 2048);
        this.textSimulationID.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textSimulationID.addModifyListener(modifyListener);
        Label numberOfRunsLabel = new Label((Composite)container, 0);
        numberOfRunsLabel.setText("Number of runs:");
        this.textNumberOfRuns = new Text((Composite)container, 2048);
        this.textNumberOfRuns.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textNumberOfRuns.addModifyListener(modifyListener);
        Label numberOfSimulationsPerRunLabel = new Label((Composite)container, 0);
        numberOfSimulationsPerRunLabel.setText("Number of simulations per run:");
        this.textNumerOfSimulationsPerRun = new Text((Composite)container, 2048);
        this.textNumerOfSimulationsPerRun.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textNumerOfSimulationsPerRun.addModifyListener(modifyListener);
        Label customSeedLabel = new Label((Composite)container, 0);
        customSeedLabel.setText("Custom seed:");
        this.textCustomSeed = new Text((Composite)container, 2048);
        this.textCustomSeed.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textCustomSeed.addModifyListener(modifyListener);
    }

    private void createSimulatorType(Composite parent, final ModifyListener modifyListener) {
        Group simulatorTypeGroup = new Group(parent, 0);
        simulatorTypeGroup.setText("Simulator Type");
        simulatorTypeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        simulatorTypeGroup.setLayout((Layout)new GridLayout());
        Composite comp = new Composite((Composite)simulatorTypeGroup, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        comp.setLayout((Layout)new GridLayout(2, false));
        this.simulatorTypeTarget = new SelectObservableValue();
        Button buttonCustom = new Button(comp, 16);
        buttonCustom.setText(SimulatorType.CUSTOM.getName());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        buttonCustom.setLayoutData((Object)gd);
        ISWTObservableValue customObserveable = WidgetProperties.buttonSelection().observe((Widget)buttonCustom);
        this.simulatorTypeTarget.addOption((Object)SimulatorType.CUSTOM, (IObservableValue)customObserveable);
        Button buttonModelled = new Button(comp, 16);
        buttonModelled.setText("SModel File:");
        final Composite modelledContainer = new Composite(comp, 0);
        modelledContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        modelledContainer.setLayout((Layout)new GridLayout(4, false));
        this.textSModel = new Text(modelledContainer, 2052);
        this.textSModel.setLayoutData((Object)new GridData(4, 4, true, false));
        TabHelper.createFileInputParts((Composite)modelledContainer, (ModifyListener)modifyListener, (String[])ModelFileTypeConstants.SMODEL_FILE_EXTENSION, (Text)this.textSModel, (String)"Select SModel File", (String)"");
        ISWTObservableValue modelledObserveable = WidgetProperties.buttonSelection().observe((Widget)buttonModelled);
        this.simulatorTypeTarget.addOption((Object)SimulatorType.MODELLED, (IObservableValue)modelledObserveable);
        ISideEffect.create(() -> (SimulatorType)this.simulatorTypeTarget.getValue(), (Consumer)new Consumer<SimulatorType>(){

            @Override
            public void accept(SimulatorType selectedSimulatorType) {
                if (selectedSimulatorType == null) {
                    return;
                }
                SimExpConfigurationTab.this.recursiveSetEnabled((Control)modelledContainer, selectedSimulatorType == SimulatorType.MODELLED);
                modifyListener.modifyText(null);
            }
        });
    }

    private void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("NumberOfRuns", 1);
        configuration.setAttribute("NumberOfSimulationsPerRun", 100);
        configuration.setAttribute("Simulator Type", SimulationConstants.DEFAULT_SIMULATOR_TYPE.name());
        this.simulatorConfiguration.setDefaults(configuration);
    }

    @Override
    protected void doInitializeFrom(ILaunchConfigurationWorkingCopy configuration, DataBindingContext ctx) {
        this.initializeSimulationFrom((ILaunchConfiguration)configuration, ctx);
        this.transformationConfiguration.initializeFrom(configuration, ctx);
        this.initializeSimulatorTypeFrom((ILaunchConfiguration)configuration, ctx);
        this.simulatorConfiguration.initializeFrom((ILaunchConfiguration)configuration, ctx);
    }

    private void initializeSimulationFrom(ILaunchConfiguration configuration, DataBindingContext ctx) {
        ISWTObservableValue simulationIdTarget = WidgetProperties.text((int)24).observe((Widget)this.textSimulationID);
        IObservableValue simulationIdModel = ConfigurationProperties.string("SimulationID").observe((Object)configuration);
        UpdateValueStrategy simulationIdUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        simulationIdUpdateStrategy.setBeforeSetValidator((IValidator)new NotEmptyValidator("Simulation ID"));
        Binding simulationIdBindValue = ctx.bindValue((IObservableValue)simulationIdTarget, simulationIdModel, simulationIdUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)simulationIdBindValue, (int)131200);
        ISWTObservableValue numberOfRunsTarget = WidgetProperties.text((int)24).observe((Widget)this.textNumberOfRuns);
        IObservableValue numberOfRunsModel = ConfigurationProperties.integer("NumberOfRuns").observe((Object)configuration);
        UpdateValueStrategy numberOfRunsUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        numberOfRunsUpdateStrategy.setBeforeSetValidator((IValidator)new MinIntegerValidator("Number of runs", 1));
        Binding numberOfRunsBindValue = ctx.bindValue((IObservableValue)numberOfRunsTarget, numberOfRunsModel, numberOfRunsUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)numberOfRunsBindValue, (int)131200);
        ISWTObservableValue numberOfSimulationsPerRunTarget = WidgetProperties.text((int)24).observe((Widget)this.textNumerOfSimulationsPerRun);
        IObservableValue numberOfSimulationsPerRunModel = ConfigurationProperties.integer("NumberOfSimulationsPerRun").observe((Object)configuration);
        UpdateValueStrategy numberOfSimulationsPerRunUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        numberOfSimulationsPerRunUpdateStrategy.setBeforeSetValidator((IValidator)new MinIntegerValidator("Number of simulations per run", 1));
        Binding numberOfSimulationsPerRunBindValue = ctx.bindValue((IObservableValue)numberOfSimulationsPerRunTarget, numberOfSimulationsPerRunModel, numberOfSimulationsPerRunUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)numberOfSimulationsPerRunBindValue, (int)131200);
        ISWTObservableValue customSeedTarget = WidgetProperties.text((int)24).observe((Widget)this.textCustomSeed);
        IObservableValue customSeedModel = ConfigurationProperties.integer("CustomSeed", false).observe((Object)configuration);
        UpdateValueStrategy customSeedUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        customSeedUpdateStrategy.setConverter((IConverter)StringToNumberConverter.toInteger((boolean)false));
        Binding customSeedBindValue = ctx.bindValue((IObservableValue)customSeedTarget, customSeedModel, customSeedUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)customSeedBindValue, (int)131200);
    }

    private void initializeSimulatorTypeFrom(ILaunchConfiguration configuration, DataBindingContext ctx) {
        IObservableValue simulatorTypeModel = ConfigurationProperties.enummeration("Simulator Type", SimulatorType.class).observe((Object)configuration);
        UpdateValueStrategy simulatorTypeUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        ctx.bindValue(this.simulatorTypeTarget, simulatorTypeModel, simulatorTypeUpdateStrategy, null);
        ISWTObservableValue smodelTarget = WidgetProperties.text((int)24).observe((Widget)this.textSModel);
        IObservableValue smodelModel = ConfigurationProperties.string("smodelFile").observe((Object)configuration);
        EnumEnabler<SimulatorType> isSmodelEnabled = new EnumEnabler<SimulatorType>(SimulatorType.MODELLED, this.simulatorTypeTarget);
        UpdateValueStrategy smodelUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        ControllableValidator<String> smodelUriValidator = new ControllableValidator<String>(new CompoundStringValidator(Arrays.asList(new FileURIValidator("Usage file"), new ExtensionValidator("Usage file", ModelFileTypeConstants.SMODEL_FILE_EXTENSION[0]))), isSmodelEnabled);
        smodelUpdateStrategy.setBeforeSetValidator(smodelUriValidator);
        Binding smodelBindValue = ctx.bindValue((IObservableValue)smodelTarget, smodelModel, smodelUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)smodelBindValue, (int)131200);
    }

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)CONFIGURATION_TAB_IMAGE_PATH);
    }

    public String getName() {
        return "Simulation Configuration";
    }

    public String getId() {
        return "org.palladiosimulator.simexp.ui.workflow.config.SimExpSimulationConfigurationTab";
    }
}

