/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.Arrays;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.palladiosimulator.simexp.commons.constants.model.ModelFileTypeConstants;
import org.palladiosimulator.simexp.ui.workflow.config.IModelValueProvider;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.ConfigurationProperties;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.CompoundStringValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.ExtensionValidator;
import org.palladiosimulator.simexp.ui.workflow.config.databinding.validation.FileURIValidator;
import org.palladiosimulator.simexp.ui.workflow.config.debug.BaseLaunchConfigurationTab;

public class SimExpModelsTab
extends BaseLaunchConfigurationTab
implements IModelValueProvider {
    public static final String PLUGIN_ID = "org.palladiosimulator.analyzer.workflow";
    private static final String FILENAME_TAB_IMAGE_PATH = "icons/filenames_tab.gif";
    private Text textAllocation;
    private Text textUsage;
    private Text textExperiments;
    private Text textStaticModel;
    private Text textDynamicModel;
    private IObservableValue<String> experimentsTarget;

    public SimExpModelsTab(DataBindingContext ctx) {
        super(ctx);
    }

    @Override
    public IObservableValue<String> getExperimentsModel() {
        return this.experimentsTarget;
    }

    @Override
    public void doCreateControl(Composite parent, DataBindingContext ctx) {
        BaseLaunchConfigurationTab.SimExpModifyListener modifyListener = new BaseLaunchConfigurationTab.SimExpModifyListener(this);
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group architecturalModelsGroup = new Group(container, 0);
        architecturalModelsGroup.setText("Architectural Models");
        architecturalModelsGroup.setLayout((Layout)new GridLayout());
        architecturalModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textAllocation = new Text((Composite)architecturalModelsGroup, 2052);
        TabHelper.createFileInputSection((Composite)architecturalModelsGroup, (ModifyListener)modifyListener, (String)"Allocation File", (String[])ModelFileTypeConstants.ALLOCATION_FILE_EXTENSION, (Text)this.textAllocation, (String)"Select Allocation File", (Shell)this.getShell(), (String)"");
        this.textUsage = new Text((Composite)architecturalModelsGroup, 2052);
        TabHelper.createFileInputSection((Composite)architecturalModelsGroup, (ModifyListener)modifyListener, (String)"Usage File", (String[])ModelFileTypeConstants.USAGEMODEL_FILE_EXTENSION, (Text)this.textUsage, (String)"Select Usage File", (Shell)this.getShell(), (String)"");
        this.textExperiments = new Text((Composite)architecturalModelsGroup, 2052);
        TabHelper.createFileInputSection((Composite)architecturalModelsGroup, (ModifyListener)modifyListener, (String)"Experiments File", (String[])ModelFileTypeConstants.EXPERIMENTS_FILE_EXTENSION, (Text)this.textExperiments, (String)"Select Experiments File", (Shell)this.getShell(), (String)"");
        this.experimentsTarget = WidgetProperties.text((int)24).observe((Widget)this.textExperiments);
        Group environmentalModelsGroup = new Group(container, 0);
        environmentalModelsGroup.setText("Environmental Models");
        environmentalModelsGroup.setLayout((Layout)new GridLayout());
        environmentalModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textStaticModel = new Text((Composite)environmentalModelsGroup, 2052);
        TabHelper.createFileInputSection((Composite)environmentalModelsGroup, (ModifyListener)modifyListener, (String)"Static Model File", (String[])ModelFileTypeConstants.STATIC_MODEL_FILE_EXTENSION, (Text)this.textStaticModel, (String)"Select Static Model File", (Shell)this.getShell(), (String)"");
        this.textDynamicModel = new Text((Composite)environmentalModelsGroup, 2052);
        TabHelper.createFileInputSection((Composite)environmentalModelsGroup, (ModifyListener)modifyListener, (String)"Dynamic Model File", (String[])ModelFileTypeConstants.DYNAMIC_MODEL_FILE_EXTENSION, (Text)this.textDynamicModel, (String)"Select Dynamic Model File", (Shell)this.getShell(), (String)"");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    protected void doInitializeFrom(ILaunchConfigurationWorkingCopy configuration, DataBindingContext ctx) {
        ISWTObservableValue allocationTarget = WidgetProperties.text((int)24).observe((Widget)this.textAllocation);
        IObservableValue allocationModel = ConfigurationProperties.string("allocationFile").observe((Object)configuration);
        UpdateValueStrategy<String, String> allocationUpdateStrategy = this.createUpdateStrategy("Allocation file", ModelFileTypeConstants.ALLOCATION_FILE_EXTENSION[0]);
        Binding allocationBindValue = ctx.bindValue((IObservableValue)allocationTarget, allocationModel, allocationUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)allocationBindValue, (int)131200);
        ISWTObservableValue usageTarget = WidgetProperties.text((int)24).observe((Widget)this.textUsage);
        IObservableValue usageModel = ConfigurationProperties.string("usageFile").observe((Object)configuration);
        UpdateValueStrategy<String, String> usageUpdateStrategy = this.createUpdateStrategy("Usage file", ModelFileTypeConstants.USAGEMODEL_FILE_EXTENSION[0]);
        Binding usageBindValue = ctx.bindValue((IObservableValue)usageTarget, usageModel, usageUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)usageBindValue, (int)131200);
        IObservableValue experimentsModel = ConfigurationProperties.string("experimentsFile").observe((Object)configuration);
        UpdateValueStrategy<String, String> experimentsUpdateStrategy = this.createUpdateStrategy("Experiments file", ModelFileTypeConstants.EXPERIMENTS_FILE_EXTENSION[0]);
        Binding experimentsBindValue = ctx.bindValue(this.experimentsTarget, experimentsModel, experimentsUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)experimentsBindValue, (int)131200);
        ISWTObservableValue staticTarget = WidgetProperties.text((int)24).observe((Widget)this.textStaticModel);
        IObservableValue staticModel = ConfigurationProperties.string("staticModelFile").observe((Object)configuration);
        UpdateValueStrategy<String, String> staticUpdateStrategy = this.createUpdateStrategy("Static environment file", ModelFileTypeConstants.STATIC_MODEL_FILE_EXTENSION[0]);
        Binding staticBindValue = ctx.bindValue((IObservableValue)staticTarget, staticModel, staticUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)staticBindValue, (int)131200);
        ISWTObservableValue dynamicTarget = WidgetProperties.text((int)24).observe((Widget)this.textDynamicModel);
        IObservableValue dynamicModel = ConfigurationProperties.string("dynamicModelFile").observe((Object)configuration);
        UpdateValueStrategy<String, String> dynamicUpdateStrategy = this.createUpdateStrategy("Dynamic environment file", ModelFileTypeConstants.DYNAMIC_MODEL_FILE_EXTENSION[0]);
        Binding dynamicBindValue = ctx.bindValue((IObservableValue)dynamicTarget, dynamicModel, dynamicUpdateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)dynamicBindValue, (int)131200);
    }

    private UpdateValueStrategy<String, String> createUpdateStrategy(String field, String extension) {
        UpdateValueStrategy updateValueStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        updateValueStrategy.setBeforeSetValidator((IValidator)new CompoundStringValidator(Arrays.asList(new FileURIValidator(field), new ExtensionValidator(field, extension))));
        return updateValueStrategy;
    }

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)FILENAME_TAB_IMAGE_PATH);
    }

    public String getName() {
        return "Simulation Model(s)";
    }

    public String getId() {
        return "org.palladiosimulator.simexp.ui.workflow.config.SimExpModelsTab";
    }
}

