/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

class ConfigurationObservableEnumValue<E extends Enum<E>>
extends AbstractObservableValue<E> {
    private final ILaunchConfiguration configuration;
    private final String key;
    private final Class<E> enumType;

    public ConfigurationObservableEnumValue(ILaunchConfiguration configuration, String key, Class<E> enumType) {
        this.configuration = configuration;
        this.key = key;
        this.enumType = enumType;
    }

    public Object getValueType() {
        return Integer.class;
    }

    protected E doGetValue() {
        try {
            String enumLiteral = this.configuration.getAttribute(this.key, "");
            E enumValue = Enum.valueOf(this.enumType, enumLiteral);
            return enumValue;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doSetValue(E value) {
        if (!(this.configuration instanceof ILaunchConfigurationWorkingCopy)) {
            throw new RuntimeException("not supported");
        }
        ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.configuration;
        launchConfigurationWorkingCopy.setAttribute(this.key, ((Enum)value).name());
    }
}

