/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.ui.workflow.config.debug;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.palladiosimulator.simexp.ui.workflow.config.IResetLaunchConfigurationTab;
import org.palladiosimulator.simexp.ui.workflow.config.debug.LaunchConfigurationDispatcher;

public abstract class BaseLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements IResetLaunchConfigurationTab {
    private final DataBindingContext ctx;
    private LaunchConfigurationDispatcher dispatcher;
    private boolean isReset = false;

    public BaseLaunchConfigurationTab(DataBindingContext ctx) {
        this.ctx = ctx;
    }

    private void validateTargetToModel() {
        for (Binding binding : this.ctx.getBindings()) {
            binding.validateTargetToModel();
        }
    }

    public final void createControl(Composite parent) {
        this.doCreateControl(parent, this.ctx);
    }

    protected abstract void doCreateControl(Composite var1, DataBindingContext var2);

    public final void initializeFrom(ILaunchConfiguration configuration) {
        if (configuration instanceof ILaunchConfigurationWorkingCopy && this.dispatcher == null) {
            ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)configuration;
            this.dispatcher = new LaunchConfigurationDispatcher(launchConfigurationWorkingCopy);
            this.doInitializeFrom(this.dispatcher, this.ctx);
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            this.dispatcher.setDelegate(workingCopy);
        }
        catch (CoreException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void setReset(boolean reset) {
        this.isReset = reset;
    }

    protected abstract void doInitializeFrom(ILaunchConfigurationWorkingCopy var1, DataBindingContext var2);

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.dispatcher.setDelegate(configuration);
        this.ctx.updateModels();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        for (ValidationStatusProvider statusProvider : this.ctx.getValidationStatusProviders()) {
            IStatus validationStatus = (IStatus)statusProvider.getValidationStatus().getValue();
            if (validationStatus.isOK()) continue;
            this.setErrorMessage(validationStatus.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected class SimExpModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            if (BaseLaunchConfigurationTab.this.isReset) {
                return;
            }
            BaseLaunchConfigurationTab.this.validateTargetToModel();
            BaseLaunchConfigurationTab.this.setDirty(true);
            BaseLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

