/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.workflow.launcher;

import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.logging.console.LoggerAppenderStruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMLaunchConfigurationDelegate;
import org.palladiosimulator.core.simulation.SimulationExecutor;
import org.palladiosimulator.simexp.commons.constants.model.QualityObjective;
import org.palladiosimulator.simexp.commons.constants.model.SimulationConstants;
import org.palladiosimulator.simexp.commons.constants.model.SimulationEngine;
import org.palladiosimulator.simexp.commons.constants.model.SimulatorType;
import org.palladiosimulator.simexp.pcm.config.SimulationParameters;
import org.palladiosimulator.simexp.workflow.api.LaunchDescriptionProvider;
import org.palladiosimulator.simexp.workflow.api.SimExpWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.config.ArchitecturalModelsWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.config.EnvironmentalModelsWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.config.MonitorConfiguration;
import org.palladiosimulator.simexp.workflow.config.PrismConfiguration;
import org.palladiosimulator.simexp.workflow.jobs.SimExpAnalyzerRootJob;
import org.palladiosimulator.simexp.workflow.launcher.SimulationExecutorLookup;
import tools.mdsd.probdist.api.random.FixedSeedProvider;
import tools.mdsd.probdist.api.random.ISeedProvider;

public abstract class SimExpLauncher
extends AbstractPCMLaunchConfigurationDelegate<SimExpWorkflowConfiguration> {
    private static final Logger LOGGER = Logger.getLogger((String)SimExpLauncher.class.getName());

    protected IJob createWorkflowJob(SimExpWorkflowConfiguration config, ILaunch launch) throws CoreException {
        LOGGER.debug((Object)"Create SimExp workflow root job");
        try {
            SimulationParameters simulationParameters = config.getSimulationParameters();
            LaunchDescriptionProvider launchDescriptionProvider = new LaunchDescriptionProvider(simulationParameters);
            Optional<ISeedProvider> seedProvider = config.getSeedProvider();
            SimulationExecutorLookup simulationExecutorLookup = new SimulationExecutorLookup();
            SimulationExecutor simulationExecutor = simulationExecutorLookup.lookupSimulationExecutor(config, launchDescriptionProvider, seedProvider);
            if (simulationExecutor == null) {
                throw new IllegalArgumentException("Unable to create simulation executor");
            }
            String policyId = simulationExecutor.getPolicyId();
            launchDescriptionProvider.setPolicyId(policyId);
            return new SimExpAnalyzerRootJob(config, simulationExecutor, launch);
        }
        catch (Exception e) {
            IStatus status = Status.error((String)e.getMessage(), (Throwable)e);
            throw new CoreException(status);
        }
    }

    protected SimExpWorkflowConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        LOGGER.debug((Object)"Derive workflow configuration");
        return this.buildWorkflowConfiguration(configuration, mode);
    }

    private SimExpWorkflowConfiguration buildWorkflowConfiguration(ILaunchConfiguration configuration, String mode) {
        SimExpWorkflowConfiguration workflowConfiguration = null;
        try {
            Map launchConfigurationParams = configuration.getAttributes();
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : launchConfigurationParams.entrySet()) {
                    LOGGER.debug((Object)String.format("launch configuration param ['%s':'%s']", entry.getKey(), entry.getValue()));
                }
            }
            String simulatorTypeStr = (String)launchConfigurationParams.get("Simulator Type");
            SimulatorType simulatorType = SimulatorType.valueOf((String)simulatorTypeStr);
            String simulationEngineStr = (String)launchConfigurationParams.get("Simulation Engine");
            SimulationEngine simulationEngine = SimulationEngine.valueOf((String)simulationEngineStr);
            Set transformationNames = configuration.getAttribute("TransformationsActive", Collections.emptySet());
            SimulationParameters simulationParameters = new SimulationParameters((String)launchConfigurationParams.get("SimulationID"), ((Integer)launchConfigurationParams.get("NumberOfRuns")).intValue(), ((Integer)launchConfigurationParams.get("NumberOfSimulationsPerRun")).intValue());
            ArchitecturalModelsWorkflowConfiguration architecturalModels = new ArchitecturalModelsWorkflowConfiguration(Arrays.asList((String)launchConfigurationParams.get("allocationFile")), (String)launchConfigurationParams.get("usageFile"), (String)launchConfigurationParams.get("experimentsFile"), (String)launchConfigurationParams.get("smodelFile"));
            EnvironmentalModelsWorkflowConfiguration environmentalModels = new EnvironmentalModelsWorkflowConfiguration((String)launchConfigurationParams.get("staticModelFile"), (String)launchConfigurationParams.get("dynamicModelFile"));
            QualityObjective qualityObjective = SimulationConstants.DEFAULT_QUALITY_OBJECTIVE;
            String monitorRepositoryFile = "";
            ArrayList<String> configuredMonitors = new ArrayList<String>();
            if (simulationEngine == SimulationEngine.PCM) {
                String qualityObjectiveStr = (String)launchConfigurationParams.get("Quality Objective");
                qualityObjective = QualityObjective.valueOf((String)qualityObjectiveStr);
                monitorRepositoryFile = (String)launchConfigurationParams.get("monitorRepositoryFile");
                configuredMonitors.addAll((List)launchConfigurationParams.get("monitors"));
            }
            MonitorConfiguration monitors = new MonitorConfiguration(monitorRepositoryFile, configuredMonitors);
            ArrayList<String> prismProperties = new ArrayList<String>();
            ArrayList<String> prismModules = new ArrayList<String>();
            if (simulationEngine == SimulationEngine.PRISM) {
                List launchConfigPrismProperties = (List)launchConfigurationParams.get("prismPropertyFile");
                List launchConfigModulesProperties = (List)launchConfigurationParams.get("prismModuleFile");
                prismProperties.addAll(launchConfigPrismProperties);
                prismModules.addAll(launchConfigModulesProperties);
            }
            PrismConfiguration prismConfig = new PrismConfiguration(prismProperties, prismModules);
            Integer customSeed = (Integer)launchConfigurationParams.get("CustomSeed");
            Optional<ISeedProvider> seedProvider = Optional.empty();
            if (customSeed != null) {
                seedProvider = Optional.of(new FixedSeedProvider((long)customSeed.intValue()));
            }
            workflowConfiguration = new SimExpWorkflowConfiguration(simulatorType, simulationEngine, transformationNames, qualityObjective, architecturalModels, monitors, prismConfig, environmentalModels, simulationParameters, seedProvider);
        }
        catch (CoreException e) {
            LOGGER.error((Object)"Failed to read workflow configuration from passed launch configuration. Please check the provided launch configuration", (Throwable)e);
        }
        return workflowConfiguration;
    }

    protected List<LoggerAppenderStruct> configureLogging(ILaunchConfiguration configuration) throws CoreException {
        Path simulationLogFolder = this.getSimulationLogFolder();
        try {
            Files.createDirectories(simulationLogFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.palladiosimulator.simexp.workflow", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        Map launchConfigurationParams = configuration.getAttributes();
        String simulationId = (String)launchConfigurationParams.get("SimulationID");
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String currentDateTime = dateFormat.format(currentDate);
        String simulationFileName = String.format("%s_%s.log", simulationId, currentDateTime);
        Path simulationLogFile = simulationLogFolder.resolve(simulationFileName);
        FileAppender fa = new FileAppender();
        fa.setName("SimulationLogger");
        fa.setFile(simulationLogFile.toString());
        fa.setLayout((Layout)new PatternLayout("%d %-5p [%-10t] [%F:%L]: %m%n"));
        fa.setThreshold((Priority)Level.DEBUG);
        fa.activateOptions();
        Level logLevel = this.getLogLevel(configuration);
        List<LoggerAppenderStruct> appenders = this.setupLogging(logLevel);
        for (LoggerAppenderStruct entry : appenders) {
            Logger entryLogger = entry.getLogger();
            entryLogger.addAppender((Appender)fa);
        }
        return appenders;
    }

    private Path getSimulationLogFolder() {
        IPath workspaceBasePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path outputBasePath = Paths.get(workspaceBasePath.toString(), new String[0]);
        Path resourcePath = outputBasePath.resolve("log");
        return resourcePath;
    }

    protected List<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>(super.setupLogging(Level.DEBUG));
        loggerList.add(this.setupLogger("org.palladiosimulator.simexp", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("org.palladiosimulator.experimentautomation.application", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("org.palladiosimulator.simulizar.reconfiguration.qvto", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("de.fzi.srp.simulatedexperience.prism.wrapper.service", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("org.palladiosimulator.envdyn.api.entity", logLevel, "[%-10t] %-5p: %m%n"));
        return loggerList;
    }
}

