/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.workflow.api;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.simexp.commons.constants.model.QualityObjective;
import org.palladiosimulator.simexp.commons.constants.model.SimulationEngine;
import org.palladiosimulator.simexp.commons.constants.model.SimulatorType;
import org.palladiosimulator.simexp.pcm.config.IModelledPrismWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.config.IModelledWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.config.IPrismWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.config.SimulationParameters;
import org.palladiosimulator.simexp.pcm.modelled.simulator.config.IModelledPcmWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.simulator.config.IPCMWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.config.ArchitecturalModelsWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.config.EnvironmentalModelsWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.config.MonitorConfiguration;
import org.palladiosimulator.simexp.workflow.config.PrismConfiguration;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class SimExpWorkflowConfiguration
extends AbstractPCMWorkflowRunConfiguration
implements IPCMWorkflowConfiguration,
IPrismWorkflowConfiguration,
IModelledWorkflowConfiguration,
IModelledPcmWorkflowConfiguration,
IModelledPrismWorkflowConfiguration {
    private final URI smodelFile;
    private final SimulatorType simulatorType;
    private final SimulationEngine simulationEngine;
    private final Set<String> transformationNames;
    private final QualityObjective qualityObjective;
    private final URI experimentsFile;
    private final URI staticModelFile;
    private final URI dynamicModelFile;
    private final URI monitorRepositoryFile;
    private final List<URI> propertyFiles;
    private final List<URI> moduleFiles;
    private final List<String> monitorNames;
    private final SimulationParameters simulationParameters;
    private final Optional<ISeedProvider> seedProvider;

    public SimExpWorkflowConfiguration(SimulatorType simulatorType, SimulationEngine simulationEngine, Set<String> transformationNames, QualityObjective qualityObjective, ArchitecturalModelsWorkflowConfiguration architecturalModels, MonitorConfiguration monitors, PrismConfiguration prismConfiguration, EnvironmentalModelsWorkflowConfiguration environmentalModels, SimulationParameters simulationParameters, Optional<ISeedProvider> seedProvider) {
        this.simulatorType = simulatorType;
        this.simulationEngine = simulationEngine;
        this.transformationNames = transformationNames;
        this.qualityObjective = qualityObjective;
        this.setUsageModelFile(architecturalModels.getUsageModelFile());
        this.setAllocationFiles(architecturalModels.getAllocationFiles());
        this.experimentsFile = URI.createURI((String)architecturalModels.getExperimentsFile());
        this.smodelFile = URI.createURI((String)architecturalModels.getSmodelFile());
        this.staticModelFile = URI.createURI((String)environmentalModels.getStaticModelFile());
        this.dynamicModelFile = URI.createURI((String)environmentalModels.getDynamicModelFile());
        this.monitorRepositoryFile = URI.createURI((String)monitors.getMonitorRepositoryFile());
        this.monitorNames = monitors.getMonitors();
        this.propertyFiles = prismConfiguration.getPropertyFiles().stream().map(URI::createURI).toList();
        this.moduleFiles = prismConfiguration.getModuleFIles().stream().map(URI::createURI).toList();
        this.simulationParameters = simulationParameters;
        this.seedProvider = seedProvider;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setDefaults() {
    }

    public URI getSmodelURI() {
        return this.smodelFile;
    }

    public SimulatorType getSimulatorType() {
        return this.simulatorType;
    }

    public SimulationEngine getSimulationEngine() {
        return this.simulationEngine;
    }

    public Set<String> getTransformationNames() {
        return this.transformationNames;
    }

    public QualityObjective getQualityObjective() {
        return this.qualityObjective;
    }

    public URI getExperimentsURI() {
        return this.experimentsFile;
    }

    public URI getStaticModelURI() {
        return this.staticModelFile;
    }

    public URI getDynamicModelURI() {
        return this.dynamicModelFile;
    }

    public URI getMonitorRepositoryURI() {
        return this.monitorRepositoryFile;
    }

    public List<String> getMonitorNames() {
        return List.copyOf(this.monitorNames);
    }

    public List<URI> getPropertyFiles() {
        return List.copyOf(this.propertyFiles);
    }

    public List<URI> getModuleFiles() {
        return List.copyOf(this.moduleFiles);
    }

    public SimulationParameters getSimulationParameters() {
        return this.simulationParameters;
    }

    public Optional<ISeedProvider> getSeedProvider() {
        return this.seedProvider;
    }
}

