/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.workflow.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.palladiosimulator.core.simulation.SimulationExecutor;
import org.palladiosimulator.simexp.pcm.config.IWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.workflow.api.ILaunchFactory;
import org.palladiosimulator.simexp.workflow.api.LaunchDescriptionProvider;
import org.palladiosimulator.simexp.workflow.api.SimExpWorkflowConfiguration;
import org.palladiosimulator.simexp.workflow.launcher.PcmModelLoader;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class SimulationExecutorLookup {
    private static final String LAUNCH_ID = "org.palladiosimulator.simexp.workflow.launch";

    public SimulationExecutor lookupSimulationExecutor(SimExpWorkflowConfiguration config, LaunchDescriptionProvider launchDescriptionProvider, Optional<ISeedProvider> seedProvider) throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        List<ILaunchFactory> factories = this.lookupFactories(registry);
        for (ILaunchFactory factory : factories) {
            if (!factory.canHandle((IWorkflowConfiguration)config)) continue;
            PcmModelLoader.Factory modelLoaderFactory = new PcmModelLoader.Factory();
            return factory.createSimulationExecutor((IWorkflowConfiguration)config, launchDescriptionProvider, seedProvider, (ModelLoader.Factory)modelLoaderFactory);
        }
        return null;
    }

    private List<ILaunchFactory> lookupFactories(IExtensionRegistry registry) throws CoreException {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(LAUNCH_ID);
        ArrayList<ILaunchFactory> factories = new ArrayList<ILaunchFactory>();
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Object o = e.createExecutableExtension("class");
            if (o instanceof ILaunchFactory var9_9) {
                factories.add((ILaunchFactory)launchFactory);
            }
            ++n2;
        }
        return factories;
    }
}

