/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.workflow.trafo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.simexp.pcm.action.IQVTOModelTransformationLoader;
import org.palladiosimulator.simexp.pcm.action.QVTOModelTransformationLoader;
import org.palladiosimulator.simexp.pcm.modelled.ModelledModelLoader;
import org.palladiosimulator.simexp.workflow.launcher.PcmModelLoader;
import org.palladiosimulator.simexp.workflow.trafo.ITrafoNameProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;

public class TrafoNameProvider
implements ITrafoNameProvider {
    private static final Logger LOGGER = Logger.getLogger(TrafoNameProvider.class);

    static {
        LOGGER.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout(), "System.out"));
        LOGGER.setLevel(Level.DEBUG);
    }

    @Override
    public List<String> getAvailableTransformations(URI experimentsFile) {
        if (experimentsFile.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            LOGGER.debug((Object)("new experiment file: " + experimentsFile));
            PcmModelLoader.Factory modelLoaderFactory = new PcmModelLoader.Factory();
            ModelledModelLoader modelLoader = modelLoaderFactory.create();
            Experiment experiment = modelLoader.loadExperiment(experimentsFile);
            String reconfigurationRulesLocation = this.getReconfigurationRulesLocation(experiment);
            LOGGER.debug((Object)("rules folder: " + reconfigurationRulesLocation));
            QVTOModelTransformationLoader qvtoModelTransformationLoader = new QVTOModelTransformationLoader(reconfigurationRulesLocation);
            List<String> availableTransformations = this.getAvailableTransformations((IQVTOModelTransformationLoader)qvtoModelTransformationLoader);
            LOGGER.debug((Object)("found: " + StringUtils.join(availableTransformations, (String)", ")));
            return availableTransformations;
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to load transformation names", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> getAvailableTransformations(IQVTOModelTransformationLoader qvtoModelTransformationLoader) {
        ArrayList<String> availableTransformations = new ArrayList<String>();
        List loadQVTOReconfigurations = qvtoModelTransformationLoader.loadQVTOReconfigurations();
        for (QvtoModelTransformation qvto : loadQVTOReconfigurations) {
            String transformationName = qvto.getTransformationName();
            availableTransformations.add(transformationName);
        }
        return availableTransformations;
    }

    private String getReconfigurationRulesLocation(Experiment experiment) {
        String path = experiment.getInitialModel().getReconfigurationRules().getFolderUri();
        return path;
    }
}

