/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel;

import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockBusyEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockIdleEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockPerformedDebugStepEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockResumedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSimTimeChangedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSimulationStartedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSimulationTerminatedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockStartedDebugStepEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSuspendedEvent;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import java.io.Serializable;
import java.util.Observable;

public class DockModel
extends Observable
implements Serializable {
    private static final long serialVersionUID = -2378222579642029801L;
    private int percentDone = 0;
    private double simTime = 0.0;
    private long measurementCount = 0L;
    private boolean idle = true;
    private String id = null;
    private String remoteMaschineURI;
    private boolean isStepping = false;
    private boolean isSuspended = false;
    private transient SimulationDockService service;
    private boolean isStarted;

    public DockModel(SimulationDockService service) {
        this(service, null);
    }

    public DockModel(SimulationDockService service, String remoteMaschineURI) {
        this.service = service;
        this.id = service.getDockId();
        this.remoteMaschineURI = remoteMaschineURI;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public double getSimTime() {
        return this.simTime;
    }

    public long getMeasurementCount() {
        return this.measurementCount;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setPercentDone(int percentDone) {
        if (!this.isIdle() && this.percentDone != percentDone) {
            this.percentDone = percentDone;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setSimTime(double simTime) {
        if (!this.isIdle() && this.simTime != simTime) {
            this.simTime = simTime;
            this.setChanged();
            this.notifyObservers(new DockSimTimeChangedEvent(this, simTime));
        }
    }

    public void setMeasurementCount(long measurementCount) {
        if (!this.isIdle()) {
            this.measurementCount = measurementCount;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setIdle(boolean idle) {
        if (this.idle != idle) {
            this.idle = idle;
            this.measurementCount = 0L;
            this.simTime = 0.0;
            this.percentDone = 0;
            this.setChanged();
            if (idle) {
                this.notifyObservers(new DockIdleEvent(this));
            } else {
                this.notifyObservers(new DockBusyEvent(this));
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public SimulationDockService getService() {
        return this.service;
    }

    public boolean isRemote() {
        return this.remoteMaschineURI != null;
    }

    public String getRemoteMaschineURI() {
        return this.remoteMaschineURI;
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void setIsStepping(boolean isStepping) {
        if (this.isStepping != isStepping) {
            this.isStepping = isStepping;
            this.setChanged();
            if (isStepping) {
                this.notifyObservers(new DockStartedDebugStepEvent(this));
            } else {
                this.notifyObservers(new DockPerformedDebugStepEvent(this));
            }
        }
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setIsSuspended(boolean isSuspended) {
        if (this.isSuspended != isSuspended) {
            this.isSuspended = isSuspended;
            this.setChanged();
            if (isSuspended) {
                this.notifyObservers(new DockSuspendedEvent(this));
            } else {
                this.notifyObservers(new DockResumedEvent(this));
            }
        }
    }

    public void setStarted(boolean started) {
        if (this.isStarted != started) {
            this.isStarted = started;
            this.setChanged();
            if (this.isStarted) {
                this.notifyObservers(new DockSimulationStartedEvent(this));
            } else {
                this.notifyObservers(new DockSimulationTerminatedEvent(this));
            }
        }
    }
}

