/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.core.runconfig;

import de.uka.ipd.sdq.codegen.simucontroller.core.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.simulation.core.AbstractSimulationConfig;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.workflow.core.runconfig.AccuracyInfluenceAnalysisState;
import org.palladiosimulator.analyzer.workflow.core.runconfig.ExperimentRunDescriptor;
import org.palladiosimulator.analyzer.workflow.core.runconfig.SensitivityAnalysisConfiguration;

public class SimuComWorkflowConfiguration
extends AbstractSimulationWorkflowConfiguration {
    private static final Logger LOGGER = Logger.getLogger(SimuComWorkflowConfiguration.class);
    private SimuComConfig simuComConfig = null;
    private boolean simulateFailures;

    public SimuComWorkflowConfiguration(Map<String, Object> attributes) {
        super(attributes);
    }

    @Override
    public AbstractSimulationConfig getSimulationConfiguration() {
        return this.simuComConfig;
    }

    public void setSimuComConfiguration(SimuComConfig simuComConfig) {
        this.checkFixed();
        this.simuComConfig = simuComConfig;
        this.simulateFailures = simuComConfig.getSimulateFailures();
        this.setSimulateLinkingResources(simuComConfig.getSimulateLinkingResources());
        this.setSimulateThroughputOfLinkingResources(simuComConfig.getSimulateThroughputOfLinkingResources());
        this.setDebug(simuComConfig.isDebug());
    }

    public void setAccuracyInfluenceAnalysisState(AccuracyInfluenceAnalysisState accuracyInfluenceAnalysisState) {
        super.setAccuracyInfluenceAnalysisState(accuracyInfluenceAnalysisState);
        if (this.isAccuracyInfluenceAnalysisEnabled()) {
            this.simuComConfig.setAdditionalExperimentRunDescription(" (" + this.getAccuracyInfluenceAnalysisState() + ")");
        }
    }

    public boolean getSimulateFailures() {
        return this.simulateFailures;
    }

    public void setSimulateFailures(boolean simulateFailures) {
        this.checkFixed();
        this.simulateFailures = simulateFailures;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setDefaults() {
        throw new RuntimeException("Not implemented. No defaults defined.");
    }

    public SimuComWorkflowConfiguration copy(List<SensitivityAnalysisConfiguration> sconfList) {
        SimuComWorkflowConfiguration result;
        try {
            result = (SimuComWorkflowConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.fatal((Object)"Could not clone configuration.", (Throwable)e);
            result = null;
        }
        String name = this.simuComConfig.getNameBase();
        ExperimentRunDescriptor descriptor = new ExperimentRunDescriptor(name, sconfList);
        result.simuComConfig = this.simuComConfig.copy(descriptor);
        result.sensitivityAnalysisConfigurationList = sconfList;
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SimuComWorkflowConfiguration config = (SimuComWorkflowConfiguration)super.clone();
        config.simuComConfig = this.simuComConfig.getClone();
        config.simulateFailures = this.simulateFailures;
        return config;
    }

    public SimuComWorkflowConfiguration getClone() {
        SimuComWorkflowConfiguration config;
        try {
            config = (SimuComWorkflowConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.fatal((Object)"Could not clone configuration.", (Throwable)e);
            config = null;
        }
        return config;
    }
}

