/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.dockmodel;

import ch.ethz.iks.r_osgi.RemoteOSGiService;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.service_discovery.ServiceDiscoveryListener;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.DockModel;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockAddedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockDeletedEvent;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class DocksModel
extends Observable
implements EventHandler {
    private static final Logger LOGGER = Logger.getLogger(DocksModel.class);
    private HashMap<String, DockModel> clientDocks = new HashMap();
    private PriorityBlockingQueue<DockModel> freeDocks = new PriorityBlockingQueue<DockModel>(10, new Comparator<DockModel>(){

        @Override
        public int compare(DockModel o1, DockModel o2) {
            if (o1.isRemote()) {
                return -1;
            }
            if (o2.isRemote()) {
                return 1;
            }
            return 0;
        }
    });
    private ServiceRegistration eventListener = null;
    private BundleContext context = null;
    private ServiceListener localServiceListener;
    private ServiceRegistration remoteServiceListener;

    public DocksModel(BundleContext context) {
        this.context = context;
        this.findExisitingDocks();
        this.addListeners();
        this.registerEventListener();
    }

    protected void finalize() throws Throwable {
        this.context.removeServiceListener(this.localServiceListener);
        this.remoteServiceListener.unregister();
        this.eventListener.unregister();
        super.finalize();
    }

    private void addListeners() {
        try {
            this.localServiceListener = this.createServiceListener();
            this.context.addServiceListener(this.localServiceListener);
            this.remoteServiceListener = this.context.registerService(ServiceDiscoveryListener.class.getName(), (Object)this.createRemoteServiceListener(this.context), new Hashtable());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register dock listners ", e);
        }
    }

    private ServiceDiscoveryListener createRemoteServiceListener(final BundleContext context) {
        return new ServiceDiscoveryListener(){

            public void announceService(String iface, URI uri) {
                RemoteServiceReference[] rserv;
                ServiceReference sRef = context.getServiceReference(RemoteOSGiService.class.getName());
                ServiceTracker remoteService = new ServiceTracker(context, sRef, null);
                remoteService.open();
                RemoteOSGiService roserv = (RemoteOSGiService)remoteService.getService();
                try {
                    rserv = roserv.connect(uri);
                }
                catch (Exception e) {
                    String msg = "Unable to connect to remote server ";
                    if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                        LOGGER.error((Object)msg, (Throwable)e);
                    }
                    throw new RuntimeException(msg, e);
                }
                SimulationDockService service = (SimulationDockService)roserv.getRemoteService(rserv[0]);
                DocksModel.this.addDock(service, uri.toString());
                remoteService.close();
            }

            public void discardService(String iface, URI uri) {
                DockModel dock = DocksModel.this.getDockByURI(uri);
                DocksModel.this.removeDock(dock);
            }
        };
    }

    private ServiceListener createServiceListener() {
        return new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getServiceReference().getProperty("objectClass").equals(SimulationDockService.class.getName())) {
                    event.getType();
                    event.getType();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDock(DockModel dock) {
        HashMap<String, DockModel> hashMap = this.clientDocks;
        synchronized (hashMap) {
            this.clientDocks.remove(dock.getID());
            if (this.freeDocks.contains(dock)) {
                this.freeDocks.remove(dock);
            }
            this.setChanged();
            this.notifyObservers(new DockDeletedEvent(dock));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DockModel getDockByURI(URI uri) {
        HashMap<String, DockModel> hashMap = this.clientDocks;
        synchronized (hashMap) {
            for (DockModel m : this.clientDocks.values()) {
                if (m.getRemoteMaschineURI() == null || !m.getRemoteMaschineURI().equals(uri.toString())) continue;
                return m;
            }
        }
        return null;
    }

    private void findExisitingDocks() {
        block3: {
            try {
                ServiceReference[] services;
                ServiceReference[] serviceReferenceArray = services = this.context.getAllServiceReferences(SimulationDockService.class.getName(), null);
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    this.addDock((SimulationDockService)this.context.getService(ref));
                    ++n2;
                }
            }
            catch (InvalidSyntaxException e1) {
                if (!LOGGER.isEnabledFor((Priority)Level.ERROR)) break block3;
                LOGGER.error((Object)"Dock model status could not be initializd properly. Invalid filter expression used.", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DockModel> getAllDocks() {
        HashMap<String, DockModel> hashMap = this.clientDocks;
        synchronized (hashMap) {
            return Collections.unmodifiableCollection(this.clientDocks.values());
        }
    }

    public DockModel getBestFreeDock() throws InterruptedException {
        DockModel result = this.freeDocks.take();
        return result;
    }

    public List<DockModel> getLocalDocks() {
        return Collections.unmodifiableList(this.findDocksByDistance(false));
    }

    public List<DockModel> getRemoteDocks() {
        return Collections.unmodifiableList(this.findDocksByDistance(true));
    }

    private List<DockModel> findDocksByDistance(boolean remote) {
        return null;
    }

    public void handleEvent(Event event) {
        String dockId = (String)event.getProperty("DOCK_ID");
        DockModel dock = this.getDockById(dockId);
        if (event.getTopic().endsWith("UPDATE_SIM_STATUS")) {
            dock.setPercentDone(((Integer)event.getProperty("PERCENT_DONE")).intValue());
            dock.setSimTime(((Double)event.getProperty("CURRENT_TIME")).doubleValue());
            dock.setMeasurementCount(((Long)event.getProperty("MEASUREMENTS_TAKEN")).longValue());
        }
        if (event.getTopic().endsWith("DOCK_BUSY")) {
            dock.setIdle(false);
            if (this.freeDocks.contains(dock)) {
                this.freeDocks.remove(dock);
            }
        }
        if (event.getTopic().endsWith("DOCK_IDLE")) {
            dock.setIdle(true);
            this.freeDocks.put(dock);
        }
        if (event.getTopic().endsWith("PERFORMED_STEP")) {
            dock.setIsStepping(false);
        }
        if (event.getTopic().endsWith("SIM_STARTED")) {
            dock.setStarted(true);
            dock.setIsSuspended(false);
        }
        if (event.getTopic().endsWith("SIM_STOPPED")) {
            dock.setStarted(false);
        }
        if (event.getTopic().endsWith("SIM_SUSPENDED")) {
            dock.setIsSuspended(true);
        }
        if (event.getTopic().endsWith("SIM_RESUMED")) {
            dock.setIsSuspended(false);
        }
        if (event.getTopic().endsWith("STARTED_STEP")) {
            dock.setIsStepping(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockModel getDockById(String dockId) {
        HashMap<String, DockModel> hashMap = this.clientDocks;
        synchronized (hashMap) {
            if (!this.clientDocks.containsKey(dockId)) {
                throw new IllegalArgumentException("Dock model does not contain dock with ID " + dockId);
            }
            return this.clientDocks.get(dockId);
        }
    }

    private void registerEventListener() {
        String[] topics = new String[]{"de/uka/ipd/sdq/simucomframework/simucomdock/*"};
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        ht.put("event.topics", topics);
        this.eventListener = this.context.registerService(EventHandler.class.getName(), (Object)this, ht);
    }

    private DockModel addDock(SimulationDockService service) {
        return this.addDock(service, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockModel addDock(SimulationDockService service, String remoteMaschineURI) {
        DockModel result = new DockModel(service, remoteMaschineURI);
        HashMap<String, DockModel> hashMap = this.clientDocks;
        synchronized (hashMap) {
            this.clientDocks.put(result.getID(), result);
            this.freeDocks.put(result);
            this.setChanged();
            this.notifyObservers(new DockAddedEvent(result));
        }
        return result;
    }
}

