/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.gui;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerImages;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.DockModel;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import swing2swt.layout.BorderLayout;

public class DockStatusViewer
extends Composite
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(DockStatusViewer.class);
    private Image idleImage;
    private DockModel model;
    private Label simTimeLabel;
    private Label measurementsLabel;
    private ProgressBar progressBar;
    private Label remoteLocationLabel;
    private Label dockIdLabel;
    private Image runningImage;
    private Image pauseImage;
    private Canvas iconCanvas;
    private int lastUIUpdate = -1;
    private ToolItem stop;

    public DockStatusViewer(final DockModel model, Composite parent, int style) {
        super(parent, style);
        this.model = model;
        model.addObserver((Observer)this);
        this.setLayout(new BorderLayout(0, 0));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)"South");
        composite.setLayout((Layout)new FillLayout());
        Group statusGroup = new Group(composite, 0);
        statusGroup.setLayout((Layout)new GridLayout(5, false));
        statusGroup.setText("Status");
        Label idLabel = new Label((Composite)statusGroup, 0);
        idLabel.setText("ID:");
        this.dockIdLabel = new Label((Composite)statusGroup, 0);
        this.dockIdLabel.setText("Label");
        this.dockIdLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.iconCanvas = new Canvas((Composite)statusGroup, 0);
        this.iconCanvas.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 4));
        this.iconCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image image = null;
                image = DockStatusViewer.this.model.isIdle() ? DockStatusViewer.this.idleImage : (DockStatusViewer.this.model.isSuspended() && !DockStatusViewer.this.model.isStepping() ? DockStatusViewer.this.pauseImage : DockStatusViewer.this.runningImage);
                if (!image.isDisposed()) {
                    e.gc.drawImage(image, 0, 0);
                }
            }
        });
        Label locationLabel = new Label((Composite)statusGroup, 0);
        locationLabel.setText("Location:");
        this.remoteLocationLabel = new Label((Composite)statusGroup, 0);
        this.remoteLocationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.remoteLocationLabel.setText("Label");
        Label simulationTimeLabel = new Label((Composite)statusGroup, 0);
        simulationTimeLabel.setText("Simulation Time:");
        this.simTimeLabel = new Label((Composite)statusGroup, 0);
        this.simTimeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.simTimeLabel.setText("Label");
        Label measurementsLabelLabel = new Label((Composite)statusGroup, 0);
        measurementsLabelLabel.setText("Measurements:");
        this.measurementsLabel = new Label((Composite)statusGroup, 0);
        this.measurementsLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.measurementsLabel.setText("Label");
        Composite compositeProgress = new Composite((Composite)statusGroup, 0);
        GridLayout gl_compositeProgress = new GridLayout(2, false);
        gl_compositeProgress.verticalSpacing = 0;
        gl_compositeProgress.marginHeight = 0;
        gl_compositeProgress.marginWidth = 0;
        compositeProgress.setLayout((Layout)gl_compositeProgress);
        compositeProgress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        this.progressBar = new ProgressBar(compositeProgress, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeProgress, 0x820000);
        this.stop = new ToolItem(toolBar, 0);
        this.stop.setEnabled(false);
        this.stop.setDisabledImage(SimuControllerImages.imageRegistry.get("progress_stop_blk"));
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                model.getService().stopSimulation();
            }
        });
        this.stop.setImage(SimuControllerImages.imageRegistry.get("progress_stop"));
        this.idleImage = SimuControllerImages.imageRegistry.get("pc_box2");
        this.runningImage = SimuControllerImages.imageRegistry.get("screen_blue");
        this.pauseImage = SimuControllerImages.imageRegistry.get("screen_pause");
        this.update((Observable)model, null);
    }

    protected void checkSubclass() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.model.getPercentDone() != this.lastUIUpdate || this.model.isStepping() || this.model.isSuspended() || this.model.isIdle()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DockStatusViewer.showSimuDockView();
                    if (!DockStatusViewer.this.dockIdLabel.isDisposed()) {
                        DockStatusViewer.this.dockIdLabel.setText(DockStatusViewer.this.model.getID());
                    }
                    if (!DockStatusViewer.this.remoteLocationLabel.isDisposed()) {
                        DockStatusViewer.this.remoteLocationLabel.setText(DockStatusViewer.this.model.getRemoteMaschineURI() == null ? "<local>" : DockStatusViewer.this.model.getRemoteMaschineURI());
                    }
                    if (!DockStatusViewer.this.measurementsLabel.isDisposed()) {
                        DockStatusViewer.this.measurementsLabel.setText(String.valueOf(DockStatusViewer.this.model.getMeasurementCount()));
                    }
                    if (!DockStatusViewer.this.simTimeLabel.isDisposed()) {
                        DockStatusViewer.this.simTimeLabel.setText(new DecimalFormat("0.#").format(DockStatusViewer.this.model.getSimTime()));
                    }
                    if (!DockStatusViewer.this.progressBar.isDisposed()) {
                        DockStatusViewer.this.progressBar.setSelection(DockStatusViewer.this.model.getPercentDone());
                    }
                    if (!DockStatusViewer.this.iconCanvas.isDisposed()) {
                        DockStatusViewer.this.iconCanvas.redraw();
                    }
                    DockStatusViewer.this.stop.setEnabled(!DockStatusViewer.this.model.isIdle());
                }
            });
        }
        this.lastUIUpdate = this.model.getPercentDone();
    }

    public static void showSimuDockView() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
                    return;
                }
                try {
                    IViewPart viewer = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("de.uka.ipd.sdq.codegen.simucontroller.gui.DockStatusViewPart");
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)viewer);
                    viewer.setFocus();
                }
                catch (PartInitException e) {
                    LOGGER.warn((Object)"Could not show SimuDockView and set focus to it.", (Throwable)e);
                }
            }
        });
    }
}

