/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.core.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.runconfig.SensitivityAnalysisConfiguration;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;

public class TransformPCMForSensitivityAnalysisJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private MDSDBlackboard blackboard;
    private Logger logger = Logger.getLogger(TransformPCMForSensitivityAnalysisJob.class);
    private List<SensitivityAnalysisConfiguration> sconfList;

    public TransformPCMForSensitivityAnalysisJob(AbstractSimulationWorkflowConfiguration configuration) throws CoreException {
        this.sconfList = configuration.getSensitivityAnalysisConfigurations();
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        for (SensitivityAnalysisConfiguration sconf : this.sconfList) {
            this.applyParamterChange(sconf, pcmPartition);
        }
    }

    private void applyParamterChange(SensitivityAnalysisConfiguration sconf, PCMResourceSetPartition pcmPartition) throws JobFailedException {
        if (sconf.getVariable() != null && sconf.getVariable().equals("")) {
            throw new JobFailedException("Bad Sensitivity Analysis Job Configuration, no variable specified.");
        }
        URI uri = URI.createURI((String)sconf.getVariable());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.getResource(uri, true);
        String uriString = sconf.getVariable();
        String varUri = uriString.substring(uriString.indexOf("#") + 1);
        EObject variableToChange = resource.getEObject(varUri);
        EObject o = null;
        for (Resource r : pcmPartition.getResourceSet().getResources()) {
            if (o != null || (o = this.findEObject((EObject)r.getContents().get(0), variableToChange)) == null) continue;
            if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                this.logger.info((Object)"Altering PCM variable for sensitivity analysis");
            }
            this.alterObject(o, sconf);
        }
        if (o == null) {
            throw new JobFailedException("Sensistivity analaysis transformation was unable to find the sensitivity variable");
        }
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return "Inplace Transformation job for Sensitivity Analysis";
    }

    private void alterObject(EObject o, SensitivityAnalysisConfiguration sconf) {
        double value = sconf.getCurrent();
        if (o instanceof PCMRandomVariable) {
            PCMRandomVariable pcmRandVar = (PCMRandomVariable)o;
            if ((double)((int)value) == value) {
                pcmRandVar.setSpecification(String.valueOf((int)value));
            } else {
                pcmRandVar.setSpecification(String.valueOf(value));
            }
        }
        if (o instanceof ClosedWorkload) {
            ClosedWorkload cw = (ClosedWorkload)o;
            cw.setPopulation((int)sconf.getCurrent());
        }
        if (o instanceof OpenWorkload) {
            OpenWorkload ow = (OpenWorkload)o;
            ow.getInterArrivalTime_OpenWorkload().setSpecification("Exp(" + value + ")");
        }
    }

    private EObject findEObject(EObject objectTreeToSearchIn, EObject eObjectToFind) {
        TreeIterator it = objectTreeToSearchIn.eAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            if (!this.entityBasedEquals(eo, eObjectToFind)) continue;
            return eo;
        }
        return null;
    }

    private boolean entityBasedEquals(EObject eObject1, EObject eObject2) {
        return this.entityBasedEquals(eObject1, eObject2, null, null);
    }

    private boolean entityBasedEquals(EObject eObject1, EObject eObject2, EObject fromEObject1, EObject fromEObject2) {
        if (fromEObject1 != null && fromEObject2 != null) {
            int i = 0;
            for (EObject it : eObject1.eContents()) {
                if (it.equals(fromEObject1)) {
                    if (eObject2.eContents().get(i) != null && ((EObject)eObject2.eContents().get(i)).equals(fromEObject2)) break;
                    return false;
                }
                ++i;
            }
        }
        if (eObject1 == eObject2) {
            return true;
        }
        if (eObject1 != null && eObject2 != null) {
            if (eObject1 instanceof Entity && eObject2 instanceof Entity) {
                Entity entity1 = (Entity)eObject1;
                Entity entity2 = (Entity)eObject2;
                if (entity1.getId().equals(entity2.getId())) {
                    return true;
                }
            } else if (eObject1 instanceof Identifier && eObject2 instanceof Identifier) {
                Identifier identifier1 = (Identifier)eObject1;
                Identifier identifier2 = (Identifier)eObject2;
                if (identifier1.getId().equals(identifier2.getId())) {
                    return true;
                }
            } else {
                EClass eClass1 = eObject1.eClass();
                if (eClass1 != eObject2.eClass()) {
                    return false;
                }
                EObject parent1 = eObject1.eContainer();
                EObject parent2 = eObject2.eContainer();
                return this.entityBasedEquals(parent1, parent2, eObject1, eObject2);
            }
        }
        return false;
    }
}

