/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import com.google.inject.Injector;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.xtendworkflow.AllocationWorkflowComponent;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.xtendworkflow.SystemWorkflowComponent;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.xtendworkflow.UsageModelWorkflowComponent;
import de.uka.ipd.sdq.pcm.codegen.simucom.guice.SimuComModule;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.RepositoryXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim.SimAccuracyInfluenceExt;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.palladiosimulator.analyzer.quality.QualityFactory;
import org.palladiosimulator.analyzer.quality.QualityRepository;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.pcm.repository.Repository;

public class XtendTransformPCMToCodeJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final String GLOBAL_VARIABLE_NAME_QUALITY_ANNOTATION_REPOSITORY = "qualityAnnotationRepository";
    private static final String SLOT_NAME_QUALITY_ANNOTATION_MODEL = "qualityannotationmodel";
    private AbstractCodeGenerationWorkflowRunConfiguration configuration = null;

    public XtendTransformPCMToCodeJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void cleanup(IProgressMonitor monitr) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        Workflow workflow = new Workflow();
        Injector guiceInjector = SimuComModule.getInjector((String)this.getBasePath());
        final RepositoryXpt repositoryXpt = (RepositoryXpt)guiceInjector.getInstance(RepositoryXpt.class);
        final SimAccuracyInfluenceExt accuracyInfluenceExt = (SimAccuracyInfluenceExt)guiceInjector.getInstance(SimAccuracyInfluenceExt.class);
        HashMap<String, Object> systemTransformationSlots = this.getSystemTransformationSlots();
        AbstractExpressionsUsingWorkflowComponent.GlobalVarDef[] globalVars = new AbstractExpressionsUsingWorkflowComponent.GlobalVarDef[]{new AbstractExpressionsUsingWorkflowComponent.GlobalVarDef()};
        globalVars[0].setName(GLOBAL_VARIABLE_NAME_QUALITY_ANNOTATION_REPOSITORY);
        if (this.configuration.isAccuracyInfluenceAnalysisEnabled()) {
            globalVars[0].setValue(SLOT_NAME_QUALITY_ANNOTATION_MODEL);
        } else {
            globalVars[0].setValue("null");
        }
        int repositoryIndex = 0;
        while (repositoryIndex < this.getRepositoryCount()) {
            final HashMap<String, Object> currentRepositorySlot = this.getRepositoryTransformationSlots(repositoryIndex);
            final Repository repository = (Repository)currentRepositorySlot.get("pcmmodel");
            if (this.configuration.isAccuracyInfluenceAnalysisEnabled()) {
                workflow.addComponent(new IWorkflowComponent(){

                    public void preInvoke() {
                    }

                    public void postInvoke() {
                    }

                    public void invoke(IWorkflowContext ctx) {
                        accuracyInfluenceExt.setQualityAnnotationRepository((QualityRepository)currentRepositorySlot.get(XtendTransformPCMToCodeJob.SLOT_NAME_QUALITY_ANNOTATION_MODEL));
                        repositoryXpt.root(repository);
                    }
                });
            } else {
                workflow.addComponent(new IWorkflowComponent(){

                    public void preInvoke() {
                    }

                    public void postInvoke() {
                    }

                    public void invoke(IWorkflowContext ctx) {
                        repositoryXpt.root(repository);
                    }
                });
            }
            ++repositoryIndex;
        }
        if (this.configuration.isLoadMiddlewareAndCompletionFiles()) {
            final Repository middlewareRepository = (Repository)this.getMiddlewareRepositorySlots().get("pcmmodel");
            final Repository completionRepository = (Repository)this.getCompletionRepositorySlots().get("pcmmodel");
            workflow.addComponent(new IWorkflowComponent(){

                public void preInvoke() {
                }

                public void postInvoke() {
                }

                public void invoke(IWorkflowContext ctx) {
                    repositoryXpt.root(middlewareRepository);
                }
            });
            workflow.addComponent(new IWorkflowComponent(){

                public void preInvoke() {
                }

                public void postInvoke() {
                }

                public void invoke(IWorkflowContext ctx) {
                    repositoryXpt.root(completionRepository);
                }
            });
        }
        workflow.addComponent((IWorkflowComponent)new SystemWorkflowComponent(systemTransformationSlots, this.getBasePath()));
        workflow.addComponent((IWorkflowComponent)new AllocationWorkflowComponent(systemTransformationSlots, this.getBasePath()));
        workflow.addComponent((IWorkflowComponent)new UsageModelWorkflowComponent(systemTransformationSlots, this.getBasePath()));
        workflow.invoke(null);
    }

    private HashMap<String, Object> getCompletionRepositorySlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        ResourceSetPartition completionRepositoryPartition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcm.completionRepositoryPartition");
        sC2.put("pcmmodel", ((Resource)completionRepositoryPartition.getResourceSet().getResources().get(0)).getContents().get(0));
        return sC2;
    }

    private HashMap<String, Object> getMiddlewareRepositorySlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        ResourceSetPartition mwRepositoryPartition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.pcmmodels.partition.rmimiddleware");
        sC2.put("pcmmodel", ((Resource)mwRepositoryPartition.getResourceSet().getResources().get(0)).getContents().get(0));
        return sC2;
    }

    private HashMap<String, Object> getSystemTransformationSlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        sC2.put("middleware", pcmPartition.getMiddlewareRepository());
        if (this.configuration.isLoadMiddlewareAndCompletionFiles()) {
            sC2.put("featureConfig", pcmPartition.getFeatureConfig());
        }
        sC2.put("system", pcmPartition.getSystem());
        sC2.put("allocation", pcmPartition.getAllocation());
        sC2.put("usage", pcmPartition.getUsageModel());
        return sC2;
    }

    private HashMap<String, Object> getRepositoryTransformationSlots(int repositoryIndex) {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        sC2.put("pcmmodel", pcmPartition.getRepositories().get(repositoryIndex));
        if (this.configuration.isAccuracyInfluenceAnalysisEnabled()) {
            sC2.put(SLOT_NAME_QUALITY_ANNOTATION_MODEL, pcmPartition.getElement((EClass)QualityFactory.eINSTANCE.createQualityRepository()).get(0));
        }
        return sC2;
    }

    private int getRepositoryCount() {
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        return pcmPartition.getRepositories().size();
    }

    private String getBasePath() {
        String basePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/" + this.configuration.getStoragePluginID() + "/" + "src";
        return basePath;
    }

    public String getName() {
        return "Generate SimuCom Plugin Code";
    }
}

