/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations.builder.connectors;

import de.uka.ipd.sdq.featureconfig.FeatureConfig;
import de.uka.ipd.sdq.pcm.transformations.FeatureUtils;
import de.uka.ipd.sdq.pcm.transformations.builder.IBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.IComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.ConfigurableMiddlewareCallingConnectorCompletionBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.IClientServerConnectorCompletionComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.MarshallingConnectorCompletionBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.PairwiseMiddlewareInteractingInnerConnectorCompletionBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.resourceconsumer.LocalCommunicationComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.resourceconsumer.NetworkLoadingComponentBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class ConnectorReplacingBuilder
implements IBuilder {
    private final Logger logger = Logger.getLogger(ConnectorReplacingBuilder.class);
    private final AssemblyConnector connector;
    private final ComposedStructure parent;
    private final LinkingResource linkingRes;
    private final PCMAndCompletionModelHolder models;
    private final FeatureConfig featureConfig;

    public ConnectorReplacingBuilder(PCMAndCompletionModelHolder models, AssemblyConnector con, FeatureConfig featureConfig) {
        this.models = models;
        this.connector = con;
        this.linkingRes = this.findLinkingResource(this.connector);
        this.parent = con.getParentStructure__Connector();
        this.featureConfig = featureConfig;
    }

    @Override
    public void build() {
        if (FeatureUtils.hasFeature(this.featureConfig, "DifferentAddressSpace") || this.linkingRes != null) {
            if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                this.logger.info((Object)("Expanding a completion for remote connector " + this.connector.getEntityName()));
            }
            IClientServerConnectorCompletionComponentBuilder componentBuilder = this.configureCompletionComponentBuilder();
            componentBuilder.build();
            this.parent.getAssemblyContexts__ComposedStructure().add((Object)componentBuilder.getAssemblyContext());
            this.embeddConnectorCompletionInApplication(componentBuilder);
            this.connectConnectorCompletionWithMiddleware(componentBuilder);
            this.parent.getConnectors__ComposedStructure().remove((Object)this.connector);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IClientServerConnectorCompletionComponentBuilder configureCompletionComponentBuilder() {
        void var1_6;
        void var1_8;
        Object var1_1 = null;
        ResourceContainer clientContainer = this.findContainer(this.connector.getRequiringAssemblyContext_AssemblyConnector());
        ResourceContainer serverContainer = null;
        if (this.linkingRes != null) {
            if (this.linkingRes.getConnectedResourceContainers_LinkingResource() == null) throw new RuntimeException("Found Linking resource which does not connect the expected containers. This should not happen.");
            if (this.linkingRes.getConnectedResourceContainers_LinkingResource().size() <= 1) throw new RuntimeException("Found Linking resource which does not connect the expected containers. This should not happen.");
            serverContainer = this.findContainer(this.connector.getProvidingAssemblyContext_AssemblyConnector());
            NetworkLoadingComponentBuilder networkLoadingComponentBuilder = new NetworkLoadingComponentBuilder(this.models, this.connector.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole(), this.linkingRes);
        } else {
            serverContainer = clientContainer;
            LocalCommunicationComponentBuilder localCommunicationComponentBuilder = new LocalCommunicationComponentBuilder(this.models, this.connector.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole());
        }
        if (FeatureUtils.hasFeature(this.featureConfig, "Encryption")) {
            void var1_4;
            PairwiseMiddlewareInteractingInnerConnectorCompletionBuilder pairwiseMiddlewareInteractingInnerConnectorCompletionBuilder = new PairwiseMiddlewareInteractingInnerConnectorCompletionBuilder(this.models, this.connector, clientContainer, serverContainer, (IComponentBuilder)var1_4, "encrypt", "decrypt");
        }
        if (!FeatureUtils.hasFeature(this.featureConfig, "Authentication")) return new MarshallingConnectorCompletionBuilder(this.models, this.connector, clientContainer, serverContainer, (IComponentBuilder)var1_8);
        ConfigurableMiddlewareCallingConnectorCompletionBuilder configurableMiddlewareCallingConnectorCompletionBuilder = new ConfigurableMiddlewareCallingConnectorCompletionBuilder(this.models, this.connector, clientContainer, serverContainer, (IComponentBuilder)var1_6, "createCredentials", "checkCredentials", null, null);
        return new MarshallingConnectorCompletionBuilder(this.models, this.connector, clientContainer, serverContainer, (IComponentBuilder)var1_8);
    }

    private void connectConnectorCompletionWithMiddleware(IClientServerConnectorCompletionComponentBuilder componentBuilder) {
        AllocationContext clientMWContext = this.findClientSideMiddlewareAllocationContext();
        assert (clientMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0) instanceof OperationProvidedRole);
        this.addAssemblyConnector(componentBuilder.getClientSideMiddlewareRole(), componentBuilder.getAssemblyContext(), (OperationProvidedRole)clientMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0), clientMWContext.getAssemblyContext_AllocationContext());
        AllocationContext serverMWContext = this.findServerSideMiddlewareAllocationContext();
        assert (serverMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0) instanceof OperationProvidedRole);
        this.addAssemblyConnector(componentBuilder.getServerSideMiddlewareRole(), componentBuilder.getAssemblyContext(), (OperationProvidedRole)serverMWContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0), serverMWContext.getAssemblyContext_AllocationContext());
    }

    private void embeddConnectorCompletionInApplication(IClientServerConnectorCompletionComponentBuilder componentBuilder) {
        this.addAssemblyConnector(this.connector.getRequiredRole_AssemblyConnector(), this.connector.getRequiringAssemblyContext_AssemblyConnector(), componentBuilder.getOperationProvidedRole(), componentBuilder.getAssemblyContext());
        this.addAssemblyConnector(componentBuilder.getOperationRequiredRole(), componentBuilder.getAssemblyContext(), this.connector.getProvidedRole_AssemblyConnector(), this.connector.getProvidingAssemblyContext_AssemblyConnector());
    }

    private void addAssemblyConnector(OperationRequiredRole from, AssemblyContext fromContext, OperationProvidedRole to, AssemblyContext toContext) {
        AssemblyConnector acon = CompositionFactory.eINSTANCE.createAssemblyConnector();
        acon.setParentStructure__Connector(this.parent);
        acon.setRequiredRole_AssemblyConnector(from);
        acon.setRequiringAssemblyContext_AssemblyConnector(fromContext);
        acon.setProvidedRole_AssemblyConnector(to);
        acon.setProvidingAssemblyContext_AssemblyConnector(toContext);
    }

    private AllocationContext findClientSideMiddlewareAllocationContext() {
        ResourceContainer container = null;
        if (this.linkingRes != null && this.linkingRes.getConnectedResourceContainers_LinkingResource() != null && this.linkingRes.getConnectedResourceContainers_LinkingResource().size() > 0) {
            this.linkingRes.getConnectedResourceContainers_LinkingResource().get(0);
        }
        if (container == null) {
            container = this.findContainer(this.connector.getRequiringAssemblyContext_AssemblyConnector());
        }
        return this.findAllocationContext(container, (Interface)this.models.getMiddlewareRepository().getInterfaces__Repository().get(0));
    }

    private AllocationContext findServerSideMiddlewareAllocationContext() {
        ResourceContainer container = this.linkingRes == null ? this.findContainer(this.connector.getRequiringAssemblyContext_AssemblyConnector()) : (ResourceContainer)this.linkingRes.getConnectedResourceContainers_LinkingResource().get(0);
        return this.findAllocationContext(container, (Interface)this.models.getMiddlewareRepository().getInterfaces__Repository().get(0));
    }

    private AllocationContext findAllocationContext(ResourceContainer resourceContainer, Interface interfaceToSearch) {
        for (AllocationContext context : this.models.getAllocation().getAllocationContexts_Allocation()) {
            OperationProvidedRole role;
            if (context.getResourceContainer_AllocationContext() != resourceContainer || context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().size() <= 0) continue;
            ProvidedRole providedRole = (ProvidedRole)context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().get(0);
            if (providedRole instanceof OperationProvidedRole) {
                role = (OperationProvidedRole)providedRole;
                if (role.getProvidedInterface__OperationProvidedRole() != interfaceToSearch) continue;
                return context;
            }
            if (providedRole instanceof InfrastructureProvidedRole) {
                role = (InfrastructureProvidedRole)providedRole;
                if (role.getProvidedInterface__InfrastructureProvidedRole() != interfaceToSearch) continue;
                return context;
            }
            throw new RuntimeException("Unsupported type of provided role found during transformation.");
        }
        throw new RuntimeException("Model invalid, unable to find middleware component for resource container " + resourceContainer.getEntityName());
    }

    private LinkingResource findLinkingResource(AssemblyConnector con) {
        ResourceContainer providedSide;
        ResourceContainer requiredSide = this.findContainer(con.getRequiringAssemblyContext_AssemblyConnector());
        if (requiredSide == (providedSide = this.findContainer(con.getProvidingAssemblyContext_AssemblyConnector()))) {
            return null;
        }
        for (LinkingResource lr : this.models.getAllocation().getTargetResourceEnvironment_Allocation().getLinkingResources__ResourceEnvironment()) {
            if (!lr.getConnectedResourceContainers_LinkingResource().contains((Object)requiredSide) || !lr.getConnectedResourceContainers_LinkingResource().contains((Object)providedSide)) continue;
            return lr;
        }
        if (this.findContainer(con.getRequiringAssemblyContext_AssemblyConnector()) != this.findContainer(con.getProvidingAssemblyContext_AssemblyConnector())) {
            throw new RuntimeException("AssemblyConnector " + con.getEntityName() + " links different ResourceContainer, but there is no linking resource between the containers!");
        }
        return null;
    }

    private ResourceContainer findContainer(AssemblyContext requiringAssemblyContext_AssemblyConnector) {
        for (AllocationContext ac : this.models.getAllocation().getAllocationContexts_Allocation()) {
            if (!ac.getAssemblyContext_AllocationContext().getId().equals(requiringAssemblyContext_AssemblyConnector.getId())) continue;
            return ac.getResourceContainer_AllocationContext();
        }
        return null;
    }
}

