/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.gui;

import de.uka.ipd.sdq.codegen.simucontroller.SimuControllerPlugin;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.DockModel;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockAddedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockDeletedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.DocksModel;
import de.uka.ipd.sdq.codegen.simucontroller.gui.DockStatusViewer;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DockStatusViewPart
extends ViewPart
implements Observer {
    public static final String ID = "de.uka.ipd.sdq.codegen.simucontroller.gui.DockStatusViewPart";
    private HashMap<String, DockStatusViewer> viewers = new HashMap();
    private DocksModel model;
    private Composite container;

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        this.model = SimuControllerPlugin.getDockModel();
        for (DockModel dock : this.model.getAllDocks()) {
            this.update(this.model, new DockAddedEvent(dock));
        }
        this.model.addObserver(this);
        this.createActions();
    }

    public void dispose() {
        this.model.deleteObserver(this);
        super.dispose();
    }

    private void createActions() {
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof DockAddedEvent) {
            final DockAddedEvent addedEvent = (DockAddedEvent)arg;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DockStatusViewPart.this.viewers.put(addedEvent.getDock().getID(), new DockStatusViewer(addedEvent.getDock(), DockStatusViewPart.this.container, 0));
                    DockStatusViewPart.this.container.layout();
                    DockStatusViewPart.this.container.redraw();
                }
            });
        }
        if (arg instanceof DockDeletedEvent) {
            final DockDeletedEvent deleteEvent = (DockDeletedEvent)arg;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DockStatusViewer viewer = DockStatusViewPart.this.viewers.get(deleteEvent.getDock().getID());
                    DockStatusViewPart.this.viewers.remove(deleteEvent.getDock().getID());
                    viewer.dispose();
                    DockStatusViewPart.this.container.layout();
                    DockStatusViewPart.this.container.redraw();
                }
            });
        }
    }
}

