/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations;

import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;

public class BytesizeComputationForSignature {
    public static String getBytesizeForSignature(OperationSignature sig, Modifier mod) {
        int length;
        DataType returnType;
        StringBuffer result = new StringBuffer();
        EList params = sig.getParameters__OperationSignature();
        for (Parameter param : params) {
            DataType dataType = param.getDataType__Parameter();
            ParameterModifier parMod = param.getModifier__Parameter();
            if (mod == Modifier.IN) {
                if (parMod != ParameterModifier.IN && parMod != ParameterModifier.INOUT && parMod != ParameterModifier.NONE) continue;
                result.append(BytesizeComputationForSignature.getCharacterisationString(dataType, param.getParameterName()));
                continue;
            }
            if (parMod != ParameterModifier.INOUT && parMod != ParameterModifier.OUT) continue;
            result.append(BytesizeComputationForSignature.getCharacterisationString(dataType, param.getParameterName()));
        }
        if (mod == Modifier.OUT && (returnType = sig.getReturnType__OperationSignature()) != null) {
            result.append(BytesizeComputationForSignature.getCharacterisationString(returnType, "RETURN"));
        }
        if ((length = result.length()) > 0) {
            result.delete(length - 3, length);
        } else if (length == 0) {
            result.append("0");
        }
        String resultString = result.toString();
        int numberOfParenthesesToAdd = 0;
        int i = 0;
        while (i < resultString.length()) {
            if ('(' == resultString.charAt(i)) {
                ++numberOfParenthesesToAdd;
            } else if (')' == resultString.charAt(i)) {
                --numberOfParenthesesToAdd;
            }
            ++i;
        }
        while (numberOfParenthesesToAdd > 0) {
            result.append(")");
            --numberOfParenthesesToAdd;
        }
        return result.toString();
    }

    private static String getCharacterisationString(DataType dataType, String name) {
        StringBuffer result = new StringBuffer();
        result.append("(");
        if (dataType instanceof PrimitiveDataType) {
            result.append(String.valueOf(name) + ".BYTESIZE + ");
        } else if (dataType instanceof CollectionDataType) {
            CollectionDataType collDataType = (CollectionDataType)dataType;
            result.append(String.valueOf(name) + ".BYTESIZE + ");
            DataType innerDataType = collDataType.getInnerType_CollectionDataType();
            String innerSize = BytesizeComputationForSignature.getCharacterisationString(innerDataType, String.valueOf(name) + ".INNER");
            result.append("(" + name + ".NUMBER_OF_ELEMENTS * " + innerSize);
            result.delete(result.length() - 3, result.length());
            result.append(") + ");
        } else if (dataType instanceof CompositeDataType) {
            CompositeDataType compDataType = (CompositeDataType)dataType;
            EList innerList = compDataType.getInnerDeclaration_CompositeDataType();
            result.append("(");
            result.append(String.valueOf(name) + ".BYTESIZE + ");
            for (InnerDeclaration decl : innerList) {
                DataType innerDataType = decl.getDatatype_InnerDeclaration();
                result.append(BytesizeComputationForSignature.getCharacterisationString(innerDataType, String.valueOf(name) + "." + decl.getEntityName()));
            }
            result.delete(result.length() - 3, result.length());
            result.append(") + ");
        }
        return result.toString();
    }

    public static enum Modifier {
        IN,
        OUT;

    }
}

