/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.core.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.reliability.FailureStatistics;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.helper.MarkovFailureTypeHelper;

public class DetermineFailureTypesJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private MDSDBlackboard blackboard;
    private AbstractPCMWorkflowRunConfiguration configuration = null;
    private final MarkovFailureTypeHelper helper = new MarkovFailureTypeHelper();

    public DetermineFailureTypesJob(AbstractPCMWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        SimuComWorkflowConfiguration config = (SimuComWorkflowConfiguration)this.configuration;
        if (!config.getSimulateFailures()) {
            return;
        }
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        FailureStatistics.setFailureTypes((List)this.helper.getFailureTypes(MarkovEvaluationType.POINTSOFFAILURE, pcmPartition.getRepositories(), pcmPartition.getResourceEnvironment(), pcmPartition.getSystem()));
    }

    public String getName() {
        return "Perform Failure Types Determination";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

