/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;

public class CompilePluginCodeJob
implements IJob {
    private AbstractCodeGenerationWorkflowRunConfiguration configuration;

    public CompilePluginCodeJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        assert (this.configuration != null);
        IProject project = CreatePluginProjectJob.getProject((String)this.configuration.getStoragePluginID());
        assert (project != null);
        this.createDescription(project, monitor);
        this.setProjectToJavaProject(project);
        this.setClasspath(project);
        this.refreshPluginInWorkspace(monitor, project);
        this.buildProject(monitor, project);
        this.checkForErrors(project);
    }

    private void setClasspath(IProject project) throws JobFailedException {
        try {
            ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)PluginRegistry.findModel((IProject)project));
        }
        catch (CoreException e) {
            throw new JobFailedException("Failed to set JDT classpath", (Throwable)e);
        }
    }

    private void setProjectToJavaProject(IProject project) throws JobFailedException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath srcPath = javaProject.getPath().append("src");
        IPath binPath = javaProject.getPath().append("bin");
        IClasspathEntry[] buildPath = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)srcPath), JavaRuntime.getDefaultJREContainerEntry()};
        try {
            javaProject.setRawClasspath(buildPath, binPath, null);
        }
        catch (JavaModelException e) {
            throw new JobFailedException("Failed setting up JDT project", (Throwable)e);
        }
    }

    private void createDescription(IProject project, IProgressMonitor monitor) throws JobFailedException {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "de.uka.ipd.sdq.codegen.simucontroller.runconfig.simucomnature"});
        description.setLocation(null);
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        description.setBuildSpec((ICommand[])new BuildCommand[]{(BuildCommand)command});
        try {
            project.setDescription(description, monitor);
        }
        catch (CoreException e) {
            throw new JobFailedException("Failed setting Java and PDE nature and builders", (Throwable)e);
        }
    }

    private void buildProject(IProgressMonitor monitor, IProject project) throws JobFailedException {
        try {
            project.build(6, monitor);
        }
        catch (Exception e) {
            throw new JobFailedException("Building plugin project failed", (Throwable)e);
        }
    }

    private void refreshPluginInWorkspace(IProgressMonitor monitor, IProject project) throws JobFailedException {
        try {
            project.refreshLocal(2, monitor);
        }
        catch (Exception e) {
            throw new JobFailedException("Refreshing plugin project failed", (Throwable)e);
        }
    }

    private void checkForErrors(IProject project) throws JobFailedException {
        try {
            if (project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2).length > 0) {
                boolean failed = false;
                IMarker[] markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                String errorList = "";
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if ((Integer)marker.getAttribute("severity") == 2) {
                        errorList = String.valueOf(errorList) + marker.getAttribute("message") + "\n";
                        failed = true;
                    }
                    ++n2;
                }
                if (failed) {
                    throw new JobFailedException("Unable to build the simulation plugin. Failure Messages: " + errorList);
                }
            }
        }
        catch (CoreException e) {
            throw new JobFailedException("Compile Plugin failed. Error finding project markers.", (Throwable)e);
        }
    }

    public String getName() {
        return "Compile Plugin Code";
    }

    public void cleanup(IProgressMonitor monitor) {
    }
}

