/*
 * Decompiled with CFR 0.152.
 */
package swing2swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.AWTLayout;

public class BorderLayout
extends AWTLayout {
    public static final String CENTER = "Center";
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String WEST = "West";
    private int hgap;
    private int vgap;
    private Control centerChild;
    private Control eastChild;
    private Control northChild;
    private Control southChild;
    private Control westChild;

    public BorderLayout() {
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point preferredSize;
        this.readLayoutData(composite);
        Point size = new Point(0, 0);
        if (this.northChild != null) {
            preferredSize = this.getPreferredSize(this.northChild, wHint, -1, flushCache);
            size.y += preferredSize.y + this.vgap;
        }
        if (this.southChild != null) {
            preferredSize = this.getPreferredSize(this.southChild, wHint, -1, flushCache);
            size.y += preferredSize.y + this.vgap;
        }
        if (this.westChild != null) {
            preferredSize = this.getPreferredSize(this.westChild, -1, hHint, flushCache);
            size.x += preferredSize.x + this.hgap;
        }
        if (this.eastChild != null) {
            preferredSize = this.getPreferredSize(this.eastChild, -1, hHint, flushCache);
            size.x += preferredSize.x + this.hgap;
        }
        if (this.centerChild != null) {
            preferredSize = this.getPreferredSize(this.centerChild, wHint, hHint, flushCache);
            size.x += preferredSize.x;
            size.y += preferredSize.y;
        }
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Point preferredSize;
        this.readLayoutData(composite);
        Rectangle clientArea = composite.getClientArea();
        int top = clientArea.y;
        int bottom = clientArea.y + clientArea.height;
        int left = clientArea.x;
        int right = clientArea.x + clientArea.width;
        if (this.northChild != null) {
            preferredSize = this.getPreferredSize(this.northChild, clientArea.width, -1, flushCache);
            this.northChild.setBounds(left, top, right - left, preferredSize.y);
            top += preferredSize.y + this.vgap;
        }
        if (this.southChild != null) {
            preferredSize = this.getPreferredSize(this.southChild, clientArea.width, -1, flushCache);
            this.southChild.setBounds(left, bottom - preferredSize.y, right - left, preferredSize.y);
            bottom -= preferredSize.y + this.vgap;
        }
        if (this.westChild != null) {
            preferredSize = this.getPreferredSize(this.westChild, -1, bottom - top, flushCache);
            this.westChild.setBounds(left, top, preferredSize.x, bottom - top);
            left += preferredSize.x + this.hgap;
        }
        if (this.eastChild != null) {
            preferredSize = this.getPreferredSize(this.eastChild, -1, bottom - top, flushCache);
            this.eastChild.setBounds(right - preferredSize.x, top, preferredSize.x, bottom - top);
            right -= preferredSize.x + this.hgap;
        }
        if (this.centerChild != null) {
            this.centerChild.setBounds(left, top, right - left, bottom - top);
        }
    }

    private void readLayoutData(Composite composite) {
        this.centerChild = null;
        this.westChild = null;
        this.eastChild = null;
        this.southChild = null;
        this.northChild = null;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Object layoutData = children[i].getLayoutData();
            if (NORTH.equals(layoutData)) {
                this.northChild = children[i];
            } else if (SOUTH.equals(layoutData)) {
                this.southChild = children[i];
            } else if (EAST.equals(layoutData)) {
                this.eastChild = children[i];
            } else if (WEST.equals(layoutData)) {
                this.westChild = children[i];
            } else {
                this.centerChild = children[i];
            }
            ++i;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }
}

