package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;

@SuppressWarnings("all")
public class ProvidedPortsXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;

  protected CharSequence _providedPorts(final InterfaceProvidingEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    final Iterable<OperationProvidedRole> operationProvidedRoles = Iterables.<OperationProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class);
    _builder.newLineIfNotEmpty();
    final Iterable<InfrastructureProvidedRole> infrastructureProvidedRoles = Iterables.<InfrastructureProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class);
    _builder.newLineIfNotEmpty();
    {
      for(final OperationProvidedRole role : operationProvidedRoles) {
        this.portImplFile(role);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final InfrastructureProvidedRole role_1 : infrastructureProvidedRoles) {
        this.portImplFile(role_1);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final OperationProvidedRole role_2 : operationProvidedRoles) {
        CharSequence _portMemberVars = this.portMemberVars(role_2);
        _builder.append(_portMemberVars);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final InfrastructureProvidedRole role_3 : infrastructureProvidedRoles) {
        CharSequence _portMemberVars_1 = this.portMemberVars(role_3);
        _builder.append(_portMemberVars_1);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final OperationProvidedRole role_4 : operationProvidedRoles) {
        CharSequence _portGetter = this.portGetter(role_4);
        _builder.append(_portGetter);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final InfrastructureProvidedRole role_5 : infrastructureProvidedRoles) {
        CharSequence _portGetter_1 = this.portGetter(role_5);
        _builder.append(_portGetter_1);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _providedPorts(final ComposedProvidingRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    final Iterable<OperationProvidedRole> operationProvidedRoles = Iterables.<OperationProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class);
    _builder.newLineIfNotEmpty();
    final Iterable<InfrastructureProvidedRole> infrastructureProvidedRoles = Iterables.<InfrastructureProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class);
    _builder.newLineIfNotEmpty();
    {
      for(final OperationProvidedRole role : operationProvidedRoles) {
        this.composedStructurePortImplFile(role, entity);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final InfrastructureProvidedRole role_1 : infrastructureProvidedRoles) {
        this.composedStructurePortImplFile(role_1, entity);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final OperationProvidedRole role_2 : operationProvidedRoles) {
        CharSequence _contextPortGetter = this.contextPortGetter(role_2, entity);
        _builder.append(_contextPortGetter);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final InfrastructureProvidedRole role_3 : infrastructureProvidedRoles) {
        CharSequence _contextPortGetter_1 = this.contextPortGetter(role_3, entity);
        _builder.append(_contextPortGetter_1);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final OperationProvidedRole role_4 : operationProvidedRoles) {
        CharSequence _portGetter = this.portGetter(role_4);
        _builder.append(_portGetter);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      for(final InfrastructureProvidedRole role_5 : infrastructureProvidedRoles) {
        CharSequence _portGetter_1 = this.portGetter(role_5);
        _builder.append(_portGetter_1);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected void _portImplFile(final OperationProvidedRole role) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnPortPackage(role));
    String _plus = (_fqnToDirectoryPath + "/");
    String _portClassName = this._javaNamesExt.portClassName(role);
    String _plus_1 = (_plus + _portClassName);
    final String fileName = (_plus_1 + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnPortPackage = this._javaNamesExt.fqnPortPackage(role);
    _builder.append(_fqnPortPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    CharSequence _portImpl = this.portImpl(role);
    _builder.append(_portImpl);
    _builder.newLineIfNotEmpty();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected void _portImplFile(final InfrastructureProvidedRole role) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnPortPackage(role));
    String _plus = (_fqnToDirectoryPath + "/");
    String _portClassName = this._javaNamesExt.portClassName(role);
    String _plus_1 = (_plus + _portClassName);
    final String fileName = (_plus_1 + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnPortPackage = this._javaNamesExt.fqnPortPackage(role);
    _builder.append(_fqnPortPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    CharSequence _portImpl = this.portImpl(role);
    _builder.append(_portImpl);
    _builder.newLineIfNotEmpty();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected void _composedStructurePortImplFile(final OperationProvidedRole role, final ComposedProvidingRequiringEntity cs) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnPortPackage(role));
    String _plus = (_fqnToDirectoryPath + "/");
    String _portClassName = this._javaNamesExt.portClassName(role);
    String _plus_1 = (_plus + _portClassName);
    final String fileName = (_plus_1 + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnPortPackage = this._javaNamesExt.fqnPortPackage(role);
    _builder.append(_fqnPortPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    CharSequence _composedStructurePortImpl = this.composedStructurePortImpl(role, cs);
    _builder.append(_composedStructurePortImpl);
    _builder.newLineIfNotEmpty();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected void _composedStructurePortImplFile(final InfrastructureProvidedRole role, final ComposedProvidingRequiringEntity cs) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnPortPackage(role));
    String _plus = (_fqnToDirectoryPath + "/");
    String _portClassName = this._javaNamesExt.portClassName(role);
    String _plus_1 = (_plus + _portClassName);
    final String fileName = (_plus_1 + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnPortPackage = this._javaNamesExt.fqnPortPackage(role);
    _builder.append(_fqnPortPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    CharSequence _composedStructurePortImpl = this.composedStructurePortImpl(role, cs);
    _builder.append(_composedStructurePortImpl);
    _builder.newLineIfNotEmpty();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected CharSequence _portImpl(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Port class for ");
    String _portClassName = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _portClassName_1 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_1);
    _builder.append(" implements ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn);
    _builder.append(", java.io.Serializable");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("protected ");
    String _fqnInterface = this._javaNamesExt.fqnInterface(role.getProvidingEntity_ProvidedRole());
    _builder.append(_fqnInterface, "     ");
    _builder.append(" myComponent = null;");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("public ");
    String _portClassName_2 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_2, "     ");
    _builder.append("(){}");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("public ");
    String _portClassName_3 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_3, "     ");
    _builder.append("(");
    String _fqnInterface_1 = this._javaNamesExt.fqnInterface(role.getProvidingEntity_ProvidedRole());
    _builder.append(_fqnInterface_1, "     ");
    _builder.append(" myComponent){");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("this.myComponent = myComponent;");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("     ");
    CharSequence _componentPortHelperMethodsTM = this.componentPortHelperMethodsTM(role);
    _builder.append(_componentPortHelperMethodsTM, "     ");
    _builder.newLineIfNotEmpty();
    {
      EList<OperationSignature> _signatures__OperationInterface = role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
      for(final OperationSignature signature : _signatures__OperationInterface) {
        _builder.append("     ");
        CharSequence _portDelegator = this.portDelegator(signature);
        _builder.append(_portDelegator, "     ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _portImpl(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Port class for ");
    String _portClassName = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _portClassName_1 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_1);
    _builder.append(" implements ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("protected ");
    String _fqnInterface = this._javaNamesExt.fqnInterface(role.getProvidingEntity_ProvidedRole());
    _builder.append(_fqnInterface, "     ");
    _builder.append(" myComponent = null;");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("public ");
    String _portClassName_2 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_2, "     ");
    _builder.append("(){}");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("public ");
    String _portClassName_3 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_3, "     ");
    _builder.append("(");
    String _fqnInterface_1 = this._javaNamesExt.fqnInterface(role.getProvidingEntity_ProvidedRole());
    _builder.append(_fqnInterface_1, "     ");
    _builder.append(" myComponent){");
    _builder.newLineIfNotEmpty();
    _builder.append("        ");
    _builder.append("this.myComponent = myComponent;");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("     ");
    CharSequence _componentPortHelperMethodsTM = this.componentPortHelperMethodsTM(role);
    _builder.append(_componentPortHelperMethodsTM, "     ");
    _builder.newLineIfNotEmpty();
    {
      EList<InfrastructureSignature> _infrastructureSignatures__InfrastructureInterface = role.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface();
      for(final InfrastructureSignature signature : _infrastructureSignatures__InfrastructureInterface) {
        _builder.append("     ");
        CharSequence _portDelegator = this.portDelegator(signature);
        _builder.append(_portDelegator, "     ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedStructurePortImpl(final OperationProvidedRole role, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Port class for ");
    String _portClassName = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _portClassName_1 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_1);
    _builder.append(" implements ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn);
    _builder.append(", java.io.Serializable");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _portClassName_2 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_2, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected ");
    String _fqn_1 = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn_1, "\t");
    _builder.append(" myInnerPort = null;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _portClassName_3 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_3, "\t");
    _builder.append("(");
    String _fqn_2 = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn_2, "\t");
    _builder.append(" myInnerPort){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.myInnerPort = myInnerPort;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _composedComponentPortHelperMethodsTM = this.composedComponentPortHelperMethodsTM(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_composedComponentPortHelperMethodsTM, "\t");
    _builder.newLineIfNotEmpty();
    {
      EList<OperationSignature> _signatures__OperationInterface = role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
      for(final OperationSignature signature : _signatures__OperationInterface) {
        _builder.append("\t     \t");
        CharSequence _composedStructurePortDelegator = this.composedStructurePortDelegator(signature, cs);
        _builder.append(_composedStructurePortDelegator, "\t     \t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedStructurePortImpl(final InfrastructureProvidedRole role, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Port class for ");
    String _portClassName = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _portClassName_1 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_1);
    _builder.append(" implements ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn);
    _builder.append(", java.io.Serializable");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _portClassName_2 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_2, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected ");
    String _fqn_1 = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn_1, "\t");
    _builder.append(" myInnerPort = null;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _portClassName_3 = this._javaNamesExt.portClassName(role);
    _builder.append(_portClassName_3, "\t");
    _builder.append("(");
    String _fqn_2 = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn_2, "\t");
    _builder.append(" myInnerPort){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.myInnerPort = myInnerPort;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t     \t");
    CharSequence _composedComponentPortHelperMethodsTM = this.composedComponentPortHelperMethodsTM(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_composedComponentPortHelperMethodsTM, "\t     \t");
    _builder.newLineIfNotEmpty();
    {
      EList<InfrastructureSignature> _infrastructureSignatures__InfrastructureInterface = role.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface();
      for(final InfrastructureSignature signature : _infrastructureSignatures__InfrastructureInterface) {
        _builder.append("\t     \t");
        CharSequence _composedStructurePortDelegator = this.composedStructurePortDelegator(signature, cs);
        _builder.append(_composedStructurePortDelegator, "\t     \t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedComponentPortHelperMethodsTM(final OperationInterface iface) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _composedComponentPortHelperMethodsTM(final InfrastructureInterface iface) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _portDelegator(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _operationSignature = this._javaCoreXpt.operationSignature(signature);
    _builder.append(_operationSignature);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _portDelegationDelegatingCallTM = this.portDelegationDelegatingCallTM(signature);
    _builder.append(_portDelegationDelegatingCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _portDelegator(final InfrastructureSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _infrastructureSignature = this._javaCoreXpt.infrastructureSignature(signature);
    _builder.append(_infrastructureSignature);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _portDelegationDelegatingCallTM = this.portDelegationDelegatingCallTM(signature);
    _builder.append(_portDelegationDelegatingCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedStructurePortDelegator(final OperationSignature signature, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _operationSignature = this._javaCoreXpt.operationSignature(signature);
    _builder.append(_operationSignature);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _composedStructurePortDelegationDelegatingCallTM = this.composedStructurePortDelegationDelegatingCallTM(signature, cs);
    _builder.append(_composedStructurePortDelegationDelegatingCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedStructurePortDelegator(final InfrastructureSignature signature, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _infrastructureSignature = this._javaCoreXpt.infrastructureSignature(signature);
    _builder.append(_infrastructureSignature);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _composedStructurePortDelegationDelegatingCallTM = this.composedStructurePortDelegationDelegatingCallTM(signature, cs);
    _builder.append(_composedStructurePortDelegationDelegatingCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedStructurePortDelegationDelegatingCallTM(final OperationSignature signature, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _composedStructurePortDelegationDelegatingCallTM(final InfrastructureSignature signature, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _portMemberVars(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqnPort = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort);
    _builder.append(" ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = new ");
    String _fqnPort_1 = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort_1);
    _builder.append("(this);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _portMemberVars(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqnPort = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort);
    _builder.append(" ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = new ");
    String _fqnPort_1 = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort_1);
    _builder.append("(this);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextPortGetter(final OperationProvidedRole role, final ComposedStructure cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqnPort = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort);
    _builder.append(" ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextPortGetter(final InfrastructureProvidedRole role, final ComposedStructure cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqnPort = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort);
    _builder.append(" ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _portGetter(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _portGetterName = this._javaNamesExt.portGetterName(role);
    _builder.append(_portGetterName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _portGetter(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _portGetterName = this._javaNamesExt.portGetterName(role);
    _builder.append(_portGetterName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _portGetterDefinition(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn, "\t");
    _builder.append(" ");
    String _portGetterName = this._javaNamesExt.portGetterName(role);
    _builder.append(_portGetterName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _portGetterDefinition(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn, "\t");
    _builder.append(" ");
    String _portGetterName = this._javaNamesExt.portGetterName(role);
    _builder.append(_portGetterName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _componentPortGetter(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _portGetterName = this._javaNamesExt.portGetterName(role);
    _builder.append(_portGetterName);
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _componentPortGetter(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _portGetterName = this._javaNamesExt.portGetterName(role);
    _builder.append(_portGetterName);
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _componentPortHelperMethodsTM(final OperationProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _componentPortHelperMethodsTM(final InfrastructureProvidedRole role) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _portDelegationDelegatingCallTM(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _portDelegationDelegatingCallTM(final InfrastructureSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence providedPorts(final InterfaceProvidingEntity entity) {
    if (entity instanceof ComposedProvidingRequiringEntity) {
      return _providedPorts((ComposedProvidingRequiringEntity)entity);
    } else if (entity != null) {
      return _providedPorts(entity);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(entity).toString());
    }
  }

  public void portImplFile(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      _portImplFile((InfrastructureProvidedRole)role);
      return;
    } else if (role instanceof OperationProvidedRole) {
      _portImplFile((OperationProvidedRole)role);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public void composedStructurePortImplFile(final ProvidedRole role, final ComposedProvidingRequiringEntity cs) {
    if (role instanceof InfrastructureProvidedRole) {
      _composedStructurePortImplFile((InfrastructureProvidedRole)role, cs);
      return;
    } else if (role instanceof OperationProvidedRole) {
      _composedStructurePortImplFile((OperationProvidedRole)role, cs);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role, cs).toString());
    }
  }

  public CharSequence portImpl(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _portImpl((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _portImpl((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence composedStructurePortImpl(final ProvidedRole role, final ComposedProvidingRequiringEntity cs) {
    if (role instanceof InfrastructureProvidedRole) {
      return _composedStructurePortImpl((InfrastructureProvidedRole)role, cs);
    } else if (role instanceof OperationProvidedRole) {
      return _composedStructurePortImpl((OperationProvidedRole)role, cs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role, cs).toString());
    }
  }

  public CharSequence composedComponentPortHelperMethodsTM(final Interface iface) {
    if (iface instanceof InfrastructureInterface) {
      return _composedComponentPortHelperMethodsTM((InfrastructureInterface)iface);
    } else if (iface instanceof OperationInterface) {
      return _composedComponentPortHelperMethodsTM((OperationInterface)iface);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(iface).toString());
    }
  }

  public CharSequence portDelegator(final Signature signature) {
    if (signature instanceof InfrastructureSignature) {
      return _portDelegator((InfrastructureSignature)signature);
    } else if (signature instanceof OperationSignature) {
      return _portDelegator((OperationSignature)signature);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature).toString());
    }
  }

  public CharSequence composedStructurePortDelegator(final Signature signature, final ComposedProvidingRequiringEntity cs) {
    if (signature instanceof InfrastructureSignature) {
      return _composedStructurePortDelegator((InfrastructureSignature)signature, cs);
    } else if (signature instanceof OperationSignature) {
      return _composedStructurePortDelegator((OperationSignature)signature, cs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature, cs).toString());
    }
  }

  public CharSequence composedStructurePortDelegationDelegatingCallTM(final Signature signature, final ComposedProvidingRequiringEntity cs) {
    if (signature instanceof InfrastructureSignature) {
      return _composedStructurePortDelegationDelegatingCallTM((InfrastructureSignature)signature, cs);
    } else if (signature instanceof OperationSignature) {
      return _composedStructurePortDelegationDelegatingCallTM((OperationSignature)signature, cs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature, cs).toString());
    }
  }

  public CharSequence portMemberVars(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _portMemberVars((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _portMemberVars((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextPortGetter(final ProvidedRole role, final ComposedStructure cs) {
    if (role instanceof InfrastructureProvidedRole) {
      return _contextPortGetter((InfrastructureProvidedRole)role, cs);
    } else if (role instanceof OperationProvidedRole) {
      return _contextPortGetter((OperationProvidedRole)role, cs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role, cs).toString());
    }
  }

  public CharSequence portGetter(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _portGetter((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _portGetter((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence portGetterDefinition(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _portGetterDefinition((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _portGetterDefinition((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence componentPortGetter(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _componentPortGetter((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _componentPortGetter((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence componentPortHelperMethodsTM(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _componentPortHelperMethodsTM((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _componentPortHelperMethodsTM((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence portDelegationDelegatingCallTM(final Signature signature) {
    if (signature instanceof InfrastructureSignature) {
      return _portDelegationDelegatingCallTM((InfrastructureSignature)signature);
    } else if (signature instanceof OperationSignature) {
      return _portDelegationDelegatingCallTM((OperationSignature)signature);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature).toString());
    }
  }
}
