package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaCoreXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.SEFFBodyXpt;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.ImplementationComponentType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;

@SuppressWarnings("all")
public class SimJavaCoreXpt extends JavaCoreXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private SEFFBodyXpt _sEFFBodyXpt;

  @Override
  public CharSequence specificImplementationPartTM(final RepositoryComponent rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("// Component Parameter Defaults");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO: The stackframes are not yet initialised by calling setComponentFrame in Protocom, thus initialize them here, too");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> myDefaultComponentStackFrame = new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Component Parameter setter");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO: The stackframes are not yet initialised by calling setComponentFrame in Protocom, thus initialize them here, too");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> myComponentStackFrame = new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void setComponentFrame(de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> myComponentStackFrame) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.myComponentStackFrame = myComponentStackFrame;\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.myDefaultComponentStackFrame = new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
    _builder.newLine();
    {
      if ((rc instanceof ImplementationComponentType)) {
        {
          EList<VariableUsage> _componentParameterUsage_ImplementationComponentType = ((ImplementationComponentType) rc).getComponentParameterUsage_ImplementationComponentType();
          for(final VariableUsage pu : _componentParameterUsage_ImplementationComponentType) {
            {
              EList<VariableCharacterisation> _variableCharacterisation_VariableUsage = pu.getVariableCharacterisation_VariableUsage();
              for(final VariableCharacterisation vc : _variableCharacterisation_VariableUsage) {
                _builder.append("\t\t");
                _builder.append("this.myDefaultComponentStackFrame.addValue(\"");
                String _parameterUsageLHS = this._pCMext.parameterUsageLHS(pu);
                String _plus = (_parameterUsageLHS + ".");
                String _string = vc.getType().toString();
                String _plus_1 = (_plus + _string);
                _builder.append(_plus_1, "\t\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("   \t");
                _builder.append("new de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy(\"");
                String _specificationString = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                _builder.append(_specificationString, "\t\t   \t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("   \t");
                _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>()));");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Override
  public CharSequence specificImplementationPartForInterfaceTM(final RepositoryComponent rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void setComponentFrame(de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> myComponentStackFrame);");
    _builder.newLine();
    return _builder;
  }

  public CharSequence componentConstructor(final RepositoryComponent rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("private static final org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(de.uka.ipd.sdq.simucomframework.model.SimuComModel.class.getName());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/** Default EMF factory for measuring points. */");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static final org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory measuringpointFactory = org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory.eINSTANCE;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private org.palladiosimulator.pcm.core.composition.AssemblyContext assemblyContext = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final String completeAssemblyContextID;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final java.util.Map<String,java.util.List<org.palladiosimulator.probeframework.probes.Probe>> startStopProbes = new java.util.HashMap<String,java.util.List<org.palladiosimulator.probeframework.probes.Probe>>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getAssemblyContext() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return this.assemblyContext;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private de.uka.ipd.sdq.simucomframework.model.SimuComModel model;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private de.uka.ipd.sdq.simucomframework.model.SimuComModel getModel() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return model;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _passiveResourceDecls = this.passiveResourceDecls(rc);
    _builder.append(_passiveResourceDecls, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _javaName = this._javaNamesExt.javaName(rc);
    _builder.append(_javaName, "\t");
    _builder.append(" (String completeAssemblyContextID, String assemblyContextURI, de.uka.ipd.sdq.simucomframework.model.SimuComModel model) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.completeAssemblyContextID = completeAssemblyContextID;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.assemblyContext = (org.palladiosimulator.pcm.core.composition.AssemblyContext) org.palladiosimulator.commons.emfutils.EMFLoadHelper.loadAndResolveEObject(assemblyContextURI);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.model = model;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    String _initCalculatorsTM = this.initCalculatorsTM(rc);
    _builder.append(_initCalculatorsTM, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _passiveResourceDecls(final RepositoryComponent rc) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _passiveResourceDecls(final BasicComponent bc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Initialize this component\'s passive resources");
    _builder.newLine();
    {
      EList<PassiveResource> _passiveResource_BasicComponent = bc.getPassiveResource_BasicComponent();
      for(final PassiveResource pr : _passiveResource_BasicComponent) {
        _builder.append("de.uka.ipd.sdq.scheduler.IPassiveResource pr_");
        String _javaVariableName = this._javaNamesExt.javaVariableName(pr.getId());
        _builder.append(_javaVariableName);
        _builder.append(" = null;");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence componentHelperMethodsDeclaration(final InterfaceProvidingEntity ipe) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getAssemblyContext();");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _interfaceHelperMethodsDeclaration(final OperationInterface oi) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext();");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _interfaceHelperMethodsDeclaration(final InfrastructureInterface ii) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext();");
    _builder.newLine();
    return _builder;
  }

  @Inject
  private SimCalculatorsXpt simCalculators;

  public String initCalculatorsTM(final RepositoryComponent rc) {
    return this.simCalculators.setupCalculators(rc);
  }

  public CharSequence containerAvailabilityCheck(final OperationSignature os) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (this.getModel().getConfiguration().getSimulateFailures()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Simulate a failure if one or multiple of the processing resources");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// required by the executing resource container are currently unavailable:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer container = ctx.findResource(this.completeAssemblyContextID);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.List<de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource> failedResources = container.getFailedResources();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(failedResources.size() > 0){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("double randValue = ctx.getModel().getConfiguration().getRandomGenerator().random();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int index = (int)Math.floor(randValue * failedResources.size());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.exceptions.FailureException.raise(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.getModel(),this.getModel().getFailureStatistics().getInternalHardwareFailureType(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("container.getResourceContainerID(),");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("failedResources.get(index).getResourceTypeId()));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * Separation of bodies generated for actions and calling these bodies. This is
   * required due to the Java restriction that methods may not longer than 64k which
   * is easily violated if several external actions or infrastructure calls are
   * generated.
   * Use ActionsAsCalls to execute the mapped AbstractAction.
   * Use ActionsAsMethods to generate the mapping for exactly one AbstractAction.
   */
  protected CharSequence _componentService(final OperationSignature os, final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _componentServiceSignature = this.componentServiceSignature(os);
    _builder.append(_componentServiceSignature);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _containerAvailabilityCheckTM = this.containerAvailabilityCheckTM(os);
    _builder.append(_containerAvailabilityCheckTM, "\t");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    {
      boolean _hasSEFF = this._pCMext.hasSEFF(os, component);
      if (_hasSEFF) {
        ServiceEffectSpecification _sEFF = this._pCMext.getSEFF(os, component);
        final ResourceDemandingSEFF seff = ((ResourceDemandingSEFF) _sEFF);
        _builder.newLineIfNotEmpty();
        _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> resultStackFrame =");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
        _builder.newLine();
        _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> methodBodyStackFrame =");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ctx.getStack().currentStackFrame();");
        _builder.newLine();
        _builder.append("if (this.myDefaultComponentStackFrame.getContents().size() > 0) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("methodBodyStackFrame.addVariables(this.myDefaultComponentStackFrame);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("if (this.myComponentStackFrame.getContents().size() > 0) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("methodBodyStackFrame.addVariables(this.myComponentStackFrame);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String _actionsAsCalls = this.actionsAsCalls(this._pCMext.findStart(seff.getSteps_Behaviour()), "ctx");
        _builder.append(_actionsAsCalls);
        _builder.newLineIfNotEmpty();
        _builder.append("return resultStackFrame;");
        _builder.newLine();
      }
    }
    _builder.append("\t   ");
    _builder.append("}   ");
    _builder.newLine();
    {
      boolean _hasSEFF_1 = this._pCMext.hasSEFF(os, component);
      if (_hasSEFF_1) {
        ServiceEffectSpecification _sEFF_1 = this._pCMext.getSEFF(os, component);
        final ResourceDemandingSEFF seff_1 = ((ResourceDemandingSEFF) _sEFF_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\t    \t");
        String _actionsAsMethods = this.actionsAsMethods(this._pCMext.findStart(seff_1.getSteps_Behaviour()));
        _builder.append(_actionsAsMethods, "\t    \t");
        _builder.append("      ");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _componentService(final InfrastructureSignature is, final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _componentServiceSignature = this.componentServiceSignature(is);
    _builder.append(_componentServiceSignature);
    _builder.newLineIfNotEmpty();
    _builder.append("{ ");
    _builder.newLine();
    {
      boolean _hasSEFF = this._pCMext.hasSEFF(is, component);
      if (_hasSEFF) {
        ServiceEffectSpecification _sEFF = this._pCMext.getSEFF(is, component);
        final ResourceDemandingSEFF seff = ((ResourceDemandingSEFF) _sEFF);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> resultStackFrame =");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> methodBodyStackFrame =");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ctx.getStack().currentStackFrame();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (this.myDefaultComponentStackFrame.getContents().size() > 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("methodBodyStackFrame.addVariables(this.myDefaultComponentStackFrame);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (this.myComponentStackFrame.getContents().size() > 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("methodBodyStackFrame.addVariables(this.myComponentStackFrame);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        String _actionsAsCalls = this.actionsAsCalls(this._pCMext.findStart(seff.getSteps_Behaviour()), "ctx");
        _builder.append(_actionsAsCalls, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return resultStackFrame;   ");
        _builder.newLine();
      }
    }
    _builder.append("\t   ");
    _builder.append("}   ");
    _builder.newLine();
    {
      boolean _hasSEFF_1 = this._pCMext.hasSEFF(is, component);
      if (_hasSEFF_1) {
        ServiceEffectSpecification _sEFF_1 = this._pCMext.getSEFF(is, component);
        final ResourceDemandingSEFF seff_1 = ((ResourceDemandingSEFF) _sEFF_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\t    \t");
        String _actionsAsMethods = this.actionsAsMethods(this._pCMext.findStart(seff_1.getSteps_Behaviour()));
        _builder.append(_actionsAsMethods, "\t    \t");
        _builder.append("      ");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public String actionsAsCalls(final AbstractAction aa, final String contextName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("action");
    String _javaVariableName = this._javaNamesExt.javaVariableName(aa.getId());
    _builder.append(_javaVariableName);
    _builder.append("(");
    _builder.append(contextName);
    _builder.append(", resultStackFrame, methodBodyStackFrame);");
    _builder.newLineIfNotEmpty();
    {
      if ((!(aa instanceof StopAction))) {
        _builder.append("\t   ");
        String _actionsAsCalls = this.actionsAsCalls(aa.getSuccessor_AbstractAction(), contextName);
        _builder.append(_actionsAsCalls, "\t   ");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }

  public String actionsAsMethods(final AbstractAction aa) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private void action");
    String _javaVariableName = this._javaNamesExt.javaVariableName(aa.getId());
    _builder.append(_javaVariableName);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("final ");
    CharSequence _contextTypeTM = this.contextTypeTM(aa);
    _builder.append(_contextTypeTM, "\t\t");
    _builder.append(" ctx, ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("final de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> resultStackFrame, ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> methodBodyStackFrame) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// EntityName = ");
    String _javaString = this._javaNamesExt.javaString(aa.getEntityName());
    _builder.append(_javaString, "\t");
    _builder.append(", Type = ");
    String _javaString_1 = this._javaNamesExt.javaString(aa.eClass().getName());
    _builder.append(_javaString_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("   ");
    CharSequence _action = this._sEFFBodyXpt.action(aa);
    _builder.append(_action, "   ");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    CharSequence _actionsAsMethodsSubBehavior = this.actionsAsMethodsSubBehavior(aa);
    _builder.append(_actionsAsMethodsSubBehavior);
    _builder.newLineIfNotEmpty();
    {
      AbstractAction _successor_AbstractAction = aa.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        String _actionsAsMethods = this.actionsAsMethods(aa.getSuccessor_AbstractAction());
        _builder.append(_actionsAsMethods);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }

  protected CharSequence _actionsAsMethodsSubBehavior(final AbstractAction aa) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _actionsAsMethodsSubBehavior(final CollectionIteratorAction cia) {
    StringConcatenation _builder = new StringConcatenation();
    String _actionsAsMethods = this.actionsAsMethods(this._pCMext.findStart(cia.getBodyBehaviour_Loop().getSteps_Behaviour()));
    _builder.append(_actionsAsMethods);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _actionsAsMethodsSubBehavior(final LoopAction la) {
    StringConcatenation _builder = new StringConcatenation();
    String _actionsAsMethods = this.actionsAsMethods(this._pCMext.findStart(la.getBodyBehaviour_Loop().getSteps_Behaviour()));
    _builder.append(_actionsAsMethods);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _actionsAsMethodsSubBehavior(final BranchAction ba) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<AbstractBranchTransition, ResourceDemandingBehaviour> _function = (AbstractBranchTransition it) -> {
        return it.getBranchBehaviour_BranchTransition();
      };
      List<ResourceDemandingBehaviour> _map = ListExtensions.<AbstractBranchTransition, ResourceDemandingBehaviour>map(ba.getBranches_Branch(), _function);
      boolean _hasElements = false;
      for(final ResourceDemandingBehaviour transition : _map) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" ", "");
        }
        String _actionsAsMethods = this.actionsAsMethods(this._pCMext.findStart(transition.getSteps_Behaviour()));
        _builder.append(_actionsAsMethods);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _actionsAsMethodsSubBehavior(final ForkAction fa) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<ForkedBehaviour> _asynchronousForkedBehaviours_ForkAction = fa.getAsynchronousForkedBehaviours_ForkAction();
      boolean _hasElements = false;
      for(final ForkedBehaviour f : _asynchronousForkedBehaviours_ForkAction) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" ", "");
        }
        String _actionsAsMethods = this.actionsAsMethods(this._pCMext.findStart(f.getSteps_Behaviour()));
        _builder.append(_actionsAsMethods);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      SynchronisationPoint _synchronisingBehaviours_ForkAction = fa.getSynchronisingBehaviours_ForkAction();
      boolean _notEquals = (!Objects.equal(_synchronisingBehaviours_ForkAction, null));
      if (_notEquals) {
        {
          EList<ForkedBehaviour> _synchronousForkedBehaviours_SynchronisationPoint = fa.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint();
          boolean _hasElements_1 = false;
          for(final ForkedBehaviour f_1 : _synchronousForkedBehaviours_SynchronisationPoint) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(" ", "");
            }
            String _actionsAsMethods_1 = this.actionsAsMethods(this._pCMext.findStart(f_1.getSteps_Behaviour()));
            _builder.append(_actionsAsMethods_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  @Override
  public CharSequence componentConstructorTM(final RepositoryComponent component) {
    return this.componentConstructor(component);
  }

  @Override
  public CharSequence componentHelperMethodsDeclarationTM(final InterfaceProvidingEntity entity) {
    return this.componentHelperMethodsDeclaration(entity);
  }

  @Override
  public CharSequence parameterListTM(final Signature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.SimuComContext ctx");
    return _builder;
  }

  @Override
  public CharSequence parameterUsageListTM(final Signature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ctx");
    return _builder;
  }

  @Override
  public CharSequence returnTypeTM(final Signature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>");
    return _builder;
  }

  @Override
  public CharSequence contextTypeTM(final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.SimuComContext");
    return _builder;
  }

  @Override
  public CharSequence componentServiceTM(final Signature signature, final RepositoryComponent component) {
    return this.componentService(signature, component);
  }

  @Override
  public CharSequence containerAvailabilityCheckTM(final OperationSignature signature) {
    return this.containerAvailabilityCheck(signature);
  }

  public CharSequence passiveResourceDecls(final RepositoryComponent bc) {
    if (bc instanceof BasicComponent) {
      return _passiveResourceDecls((BasicComponent)bc);
    } else if (bc != null) {
      return _passiveResourceDecls(bc);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(bc).toString());
    }
  }

  public CharSequence interfaceHelperMethodsDeclaration(final Interface ii) {
    if (ii instanceof InfrastructureInterface) {
      return _interfaceHelperMethodsDeclaration((InfrastructureInterface)ii);
    } else if (ii instanceof OperationInterface) {
      return _interfaceHelperMethodsDeclaration((OperationInterface)ii);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ii).toString());
    }
  }

  public CharSequence componentService(final Signature is, final RepositoryComponent component) {
    if (is instanceof InfrastructureSignature) {
      return _componentService((InfrastructureSignature)is, component);
    } else if (is instanceof OperationSignature) {
      return _componentService((OperationSignature)is, component);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is, component).toString());
    }
  }

  public CharSequence actionsAsMethodsSubBehavior(final AbstractAction cia) {
    if (cia instanceof CollectionIteratorAction) {
      return _actionsAsMethodsSubBehavior((CollectionIteratorAction)cia);
    } else if (cia instanceof LoopAction) {
      return _actionsAsMethodsSubBehavior((LoopAction)cia);
    } else if (cia instanceof BranchAction) {
      return _actionsAsMethodsSubBehavior((BranchAction)cia);
    } else if (cia instanceof ForkAction) {
      return _actionsAsMethodsSubBehavior((ForkAction)cia);
    } else if (cia != null) {
      return _actionsAsMethodsSubBehavior(cia);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(cia).toString());
    }
  }
}
