package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.SEFFBodyXpt;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.analyzer.completions.DelegatingExternalCallAction;
import org.palladiosimulator.analyzer.quality.QualityRepository;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMOperationParameterReference;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMParameterPartition;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;

@SuppressWarnings("all")
public class SimSEFFBodyXpt extends SEFFBodyXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private SimAccuracyInfluenceExt _simAccuracyInfluenceExt;

  @Inject
  @Extension
  private SimJavaCoreXpt _simJavaCoreXpt;

  @Inject
  @Extension
  private SimAccuracyXpt _simAccuracyXpt;

  @Inject
  @Extension
  private SimMeasuringPointExt _simMeasuringPointExt;

  @Override
  protected String _action(final CollectionIteratorAction cir) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("for (int iterationCount = 0, maxIterationCount = (Integer)ctx.evaluate(\"");
    String _parameterName = cir.getParameter_CollectionIteratorAction().getParameterName();
    _builder.append(_parameterName);
    _builder.append(".NUMBER_OF_ELEMENTS\",Integer.class);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("iterationCount < maxIterationCount; iterationCount++) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> loopFrame = ctx.getStack().createAndPushNewStackFrame(ctx.getStack().currentStackFrame());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ctx.evaluateInner(loopFrame, \"");
    String _parameterName_1 = cir.getParameter_CollectionIteratorAction().getParameterName();
    _builder.append(_parameterName_1, "\t");
    _builder.append(".INNER\");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    String _actionsAsCalls = this._simJavaCoreXpt.actionsAsCalls(this._pCMext.findStart(cir.getBodyBehaviour_Loop().getSteps_Behaviour()), "ctx");
    _builder.append(_actionsAsCalls, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("ctx.getStack().removeStackFrame();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }

  @Override
  protected String _action(final LoopAction la) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("for (int iterationCount");
    String _javaVariableName = this._javaNamesExt.javaVariableName(la.getId());
    _builder.append(_javaVariableName);
    _builder.append(" = 0, maxIterationCount");
    String _javaVariableName_1 = this._javaNamesExt.javaVariableName(la.getId());
    _builder.append(_javaVariableName_1);
    _builder.append(" = (Integer)ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(la.getIterationCount_LoopAction().getSpecification());
    _builder.append(_specificationString);
    _builder.append("\",Integer.class);");
    _builder.newLineIfNotEmpty();
    _builder.append("         ");
    _builder.append("iterationCount");
    String _javaVariableName_2 = this._javaNamesExt.javaVariableName(la.getId());
    _builder.append(_javaVariableName_2, "         ");
    _builder.append(" < maxIterationCount");
    String _javaVariableName_3 = this._javaNamesExt.javaVariableName(la.getId());
    _builder.append(_javaVariableName_3, "         ");
    _builder.append("; iterationCount");
    String _javaVariableName_4 = this._javaNamesExt.javaVariableName(la.getId());
    _builder.append(_javaVariableName_4, "         ");
    _builder.append("++){");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    String _actionsAsCalls = this._simJavaCoreXpt.actionsAsCalls(this._pCMext.findStart(la.getBodyBehaviour_Loop().getSteps_Behaviour()), "ctx");
    _builder.append(_actionsAsCalls, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }

  @Override
  public CharSequence failureInternalActionPreTM(final InternalAction ia) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _size = ia.getInternalFailureOccurrenceDescriptions__InternalAction().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("// Simulate a failure that occurs with a predefined probability:");
        _builder.newLine();
        _builder.append("if (ctx.getModel().getConfig().getSimulateFailures()) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double accProbability = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double randValue = ctx.getModel().getConfiguration().getRandomGenerator().random();");
        _builder.newLine();
        _builder.append("\t");
        {
          EList<InternalFailureOccurrenceDescription> _internalFailureOccurrenceDescriptions__InternalAction = ia.getInternalFailureOccurrenceDescriptions__InternalAction();
          for(final InternalFailureOccurrenceDescription ifod : _internalFailureOccurrenceDescriptions__InternalAction) {
            CharSequence _failureOccurrence = this.failureOccurrence(ifod);
            _builder.append(_failureOccurrence, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence failureOccurrence(final InternalFailureOccurrenceDescription ifod) {
    StringConcatenation _builder = new StringConcatenation();
    String _javaName = this._javaNamesExt.javaName(ifod.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription());
    final String fp = ("failureProbability" + _javaName);
    _builder.newLineIfNotEmpty();
    _builder.append("double ");
    _builder.append(fp);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t    ");
    _builder.append(fp, "\t    ");
    _builder.append(" = Double.parseDouble(\"");
    double _failureProbability = ifod.getFailureProbability();
    _builder.append(_failureProbability, "\t    ");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("} catch (NumberFormatException exception) {");
    _builder.newLine();
    _builder.append("\t    ");
    _builder.append(fp, "\t    ");
    _builder.append(" = 0.0;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("accProbability += ");
    _builder.append(fp, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if ((");
    _builder.append(fp, "\t");
    _builder.append(" > 0.0) && (accProbability >= randValue)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _raiseInternalSoftwareFailure = this.raiseInternalSoftwareFailure(ifod.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription(), ifod.getInternalAction__InternalFailureOccurrenceDescription().getId());
    _builder.append(_raiseInternalSoftwareFailure, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence raiseInternalSoftwareFailure(final SoftwareInducedFailureType sift, final String internalActionId) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.exceptions.FailureException.raise(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.getModel(),this.getModel().getFailureStatistics().getInternalSoftwareFailureType(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("\"");
    String _id = sift.getId();
    _builder.append(_id, "\t\t");
    _builder.append("\", \"");
    _builder.append(internalActionId, "\t\t");
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  protected CharSequence _action(final BranchAction ba) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    final String counterID = this._javaNamesExt.javaVariableName(ba.getId());
    _builder.newLineIfNotEmpty();
    {
      AbstractBranchTransition _head = IterableExtensions.<AbstractBranchTransition>head(ba.getBranches_Branch());
      if ((_head instanceof ProbabilisticBranchTransition)) {
        _builder.append("\t");
        _builder.append("double u");
        _builder.append(counterID, "\t");
        _builder.append(" = (Double)ctx.evaluate(\"DoublePDF[(1.0;1.0)]\",Double.class);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("double sum");
        _builder.append(counterID, "\t");
        _builder.append(" = 0;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        {
          EList<AbstractBranchTransition> _branches_Branch = ba.getBranches_Branch();
          boolean _hasElements = false;
          for(final AbstractBranchTransition b : _branches_Branch) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate("", "\t");
            }
            CharSequence _branchTransition = this.branchTransition(b, counterID);
            _builder.append(_branchTransition, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        {
          EList<AbstractBranchTransition> _branches_Branch_1 = ba.getBranches_Branch();
          boolean _hasElements_1 = false;
          for(final AbstractBranchTransition b_1 : _branches_Branch_1) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(" else ", "\t");
            }
            CharSequence _branchTransition_1 = this.branchTransition(b_1, counterID);
            _builder.append(_branchTransition_1, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("    ");
        _builder.append("logger.error(\"No branch condition evaluated to true in ");
        String _entityName = ba.getEntityName();
        _builder.append(_entityName, "\t    ");
        _builder.append(" :-(\");  ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _branchTransition(final AbstractBranchTransition abt, final String counterNumber) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _branchTransition(final GuardedBranchTransition gbt, final String counterNumber) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if ((Boolean)ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(gbt.getBranchCondition_GuardedBranchTransition().getSpecification());
    _builder.append(_specificationString);
    _builder.append("\") == true)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    String _actionsAsCalls = this._simJavaCoreXpt.actionsAsCalls(this._pCMext.findStart(gbt.getBranchBehaviour_BranchTransition().getSteps_Behaviour()), "ctx");
    _builder.append(_actionsAsCalls, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _branchTransition(final ProbabilisticBranchTransition pbt, final String counterNumber) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (sum");
    _builder.append(counterNumber);
    _builder.append(" <= u");
    _builder.append(counterNumber);
    _builder.append(" && u");
    _builder.append(counterNumber);
    _builder.append(" < sum");
    _builder.append(counterNumber);
    _builder.append(" + ");
    double _branchProbability = pbt.getBranchProbability();
    _builder.append(_branchProbability);
    _builder.append(" )");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    String _actionsAsCalls = this._simJavaCoreXpt.actionsAsCalls(this._pCMext.findStart(pbt.getBranchBehaviour_BranchTransition().getSteps_Behaviour()), "ctx");
    _builder.append(_actionsAsCalls, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.append("sum");
    _builder.append(counterNumber);
    _builder.append(" += ");
    double _branchProbability_1 = pbt.getBranchProbability();
    _builder.append(_branchProbability_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  protected CharSequence _action(final AcquireAction aa) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.append("// Acquire ");
    PassiveResource _passiveresource_AcquireAction = aa.getPassiveresource_AcquireAction();
    _builder.append(_passiveresource_AcquireAction, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("//TODO Here, a resource demand of 0 is issued to a hard-coded resource \"CPU\" (ID = \"_oro4gG3fEdy4YaaT-RYrLQ\")");
    _builder.newLine();
    _builder.append("double demand = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"0\", Double.class));");
    _builder.newLine();
    _builder.append("ctx.findResource(this.completeAssemblyContextID).loadActiveResource(ctx.getThread(), \"_oro4gG3fEdy4YaaT-RYrLQ\", demand);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("if (pr_");
    String _javaVariableName = this._javaNamesExt.javaVariableName(aa.getPassiveresource_AcquireAction().getId());
    _builder.append(_javaVariableName);
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// Initialize Resource First...");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("pr_");
    String _javaVariableName_1 = this._javaNamesExt.javaVariableName(aa.getPassiveresource_AcquireAction().getId());
    _builder.append(_javaVariableName_1, "\t");
    _builder.append(" = ctx.getPassiveRessourceInContext(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("\"");
    String _resourceURI = this._simMeasuringPointExt.getResourceURI(aa.getPassiveresource_AcquireAction());
    _builder.append(_resourceURI, "\t\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.assemblyContext,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ctx.findResource(this.assemblyContext.getId()),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(Integer)ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(aa.getPassiveresource_AcquireAction().getCapacity_PassiveResource().getSpecification());
    _builder.append(_specificationString, "\t\t");
    _builder.append("\", Integer.class)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(");");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("pr_");
    String _javaVariableName_2 = this._javaNamesExt.javaVariableName(aa.getPassiveresource_AcquireAction().getId());
    _builder.append(_javaVariableName_2);
    _builder.append(".acquire(ctx.getThread(), 1, ");
    boolean _isTimeout = aa.isTimeout();
    _builder.append(_isTimeout);
    _builder.append(", ");
    double _timeoutValue = aa.getTimeoutValue();
    _builder.append(_timeoutValue);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  protected CharSequence _action(final ReleaseAction ra) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Release ");
    PassiveResource _passiveResource_ReleaseAction = ra.getPassiveResource_ReleaseAction();
    _builder.append(_passiveResource_ReleaseAction);
    _builder.newLineIfNotEmpty();
    _builder.append("if (pr_");
    String _javaVariableName = this._javaNamesExt.javaVariableName(ra.getPassiveResource_ReleaseAction().getId());
    _builder.append(_javaVariableName);
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// Initialize Resource First...");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("pr_");
    String _javaVariableName_1 = this._javaNamesExt.javaVariableName(ra.getPassiveResource_ReleaseAction().getId());
    _builder.append(_javaVariableName_1, "\t");
    _builder.append(" = ctx.getPassiveRessourceInContext(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("\"");
    String _resourceURI = this._simMeasuringPointExt.getResourceURI(ra.getPassiveResource_ReleaseAction());
    _builder.append(_resourceURI, "\t\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.assemblyContext,");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ctx.findResource(this.assemblyContext.getId()),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(Integer)ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(ra.getPassiveResource_ReleaseAction().getCapacity_PassiveResource().getSpecification());
    _builder.append(_specificationString, "\t\t");
    _builder.append("\",Integer.class)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(");");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("pr_");
    String _javaVariableName_2 = this._javaNamesExt.javaVariableName(ra.getPassiveResource_ReleaseAction().getId());
    _builder.append(_javaVariableName_2);
    _builder.append(".release(ctx.getThread(), 1);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  protected String _action(final StartAction sa) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EObject _eContainer = sa.eContainer();
      if ((_eContainer instanceof ResourceDemandingSEFF)) {
        EObject _eContainer_1 = sa.eContainer();
        final ResourceDemandingSEFF rdseff = ((ResourceDemandingSEFF) _eContainer_1);
        _builder.newLineIfNotEmpty();
        final QualityAnnotation qualityAnnotation = this._simAccuracyInfluenceExt.getQualityAnnotation(rdseff);
        _builder.newLineIfNotEmpty();
        {
          boolean _notEquals = (!Objects.equal(qualityAnnotation, null));
          if (_notEquals) {
            {
              final Function1<PCMParameterPartition, Boolean> _function = (PCMParameterPartition it) -> {
                return Boolean.valueOf(((it.getParameterReference() instanceof PCMOperationParameterReference) || (it.getParameterReference() instanceof PCMComponentParameterReference)));
              };
              Iterable<PCMParameterPartition> _filter = IterableExtensions.<PCMParameterPartition>filter(Iterables.<PCMParameterPartition>filter(this._simAccuracyInfluenceExt.getQualityAnnotation(rdseff).getValidForParameterPartitions(), PCMParameterPartition.class), _function);
              for(final PCMParameterPartition partition : _filter) {
                _builder.append("\t\t");
                CharSequence _checkAccuracy = this._simAccuracyXpt.checkAccuracy(partition, rdseff, sa);
                _builder.append(_checkAccuracy, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            {
              QualityRepository _qualityAnnotationRepository = this._simAccuracyInfluenceExt.getQualityAnnotationRepository();
              boolean _notEquals_1 = (!Objects.equal(_qualityAnnotationRepository, null));
              if (_notEquals_1) {
                _builder.append("\t\t");
                _builder.append("SeverityAndIssue issue = AccuracyIssueFactory.createMissingQualityAnnotationIssue(\"");
                String _resourceName = this._simAccuracyInfluenceExt.getResourceName(rdseff);
                _builder.append(_resourceName, "\t\t");
                _builder.append("\", \"");
                String _id = rdseff.getId();
                _builder.append(_id, "\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("config.addIssue(issue);");
                _builder.newLine();
              } else {
              }
            }
          }
        }
      }
    }
    return _builder.toString();
  }

  @Override
  protected String _action(final StopAction sa) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder.toString();
  }

  @Override
  protected CharSequence _action(final SetVariableAction sva) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<VariableUsage> _localVariableUsages_SetVariableAction = sva.getLocalVariableUsages_SetVariableAction();
      for(final VariableUsage pu : _localVariableUsages_SetVariableAction) {
        {
          EList<VariableCharacterisation> _variableCharacterisation_VariableUsage = pu.getVariableCharacterisation_VariableUsage();
          for(final VariableCharacterisation vc : _variableCharacterisation_VariableUsage) {
            {
              boolean _isInnerReference = this._pCMext.isInnerReference(pu.getNamedReference__VariableUsage());
              if (_isInnerReference) {
                _builder.append("resultStackFrame.addValue(\"");
                String _parameterUsageLHS = this._pCMext.parameterUsageLHS(pu);
                _builder.append(_parameterUsageLHS);
                _builder.append(".");
                String _string = vc.getType().toString();
                _builder.append(_string);
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("   \t");
                _builder.append("new de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy(\"");
                String _specificationString = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                _builder.append(_specificationString, "   \t");
                _builder.append("\",methodBodyStackFrame.copyFrame()));");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("resultStackFrame.addValue(\"");
                String _parameterUsageLHS_1 = this._pCMext.parameterUsageLHS(pu);
                _builder.append(_parameterUsageLHS_1);
                _builder.append(".");
                String _string_1 = vc.getType().toString();
                _builder.append(_string_1);
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("ctx.evaluate(\"");
                String _specificationString_1 = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                _builder.append(_specificationString_1, "\t");
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    return _builder;
  }

  @Override
  protected CharSequence _action(final ForkAction fa) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess[] forks =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("new de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess[]{");
    _builder.newLine();
    {
      EList<ForkedBehaviour> _asynchronousForkedBehaviours_ForkAction = fa.getAsynchronousForkedBehaviours_ForkAction();
      boolean _hasElements = false;
      for(final ForkedBehaviour f : _asynchronousForkedBehaviours_ForkAction) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t\t");
        }
        _builder.append("\t\t");
        _builder.append("new de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess(ctx, this.assemblyContext.getId(), true, ctx.getThread().getPriority(), ctx.getResourceTableManager()){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("public void executeBehaviour() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t\t");
        _builder.append("// this.forkContext refers to the member variable ForkedBehaviorProcess.forkContext");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t\t");
        String _actionsAsCalls = this._simJavaCoreXpt.actionsAsCalls(this._pCMext.findStart(f.getSteps_Behaviour()), "this.forkContext");
        _builder.append(_actionsAsCalls, "\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("} catch (de.uka.ipd.sdq.simucomframework.exceptions.FailureException exception) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t\t");
        _builder.append("if (ctx.getModel().getConfig().getSimulateFailures()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t\t\t");
        _builder.append("ctx.getModel().getFailureStatistics().increaseUnhandledFailureCounter(exception.getFailureType(), ctx.getSessionId());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      int _size = fa.getAsynchronousForkedBehaviours_ForkAction().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t\t");
        _builder.append(",");
        _builder.newLine();
      }
    }
    {
      SynchronisationPoint _synchronisingBehaviours_ForkAction = fa.getSynchronisingBehaviours_ForkAction();
      boolean _notEquals = (!Objects.equal(_synchronisingBehaviours_ForkAction, null));
      if (_notEquals) {
        {
          EList<ForkedBehaviour> _synchronousForkedBehaviours_SynchronisationPoint = fa.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint();
          boolean _hasElements_1 = false;
          for(final ForkedBehaviour f_1 : _synchronousForkedBehaviours_SynchronisationPoint) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(",", "\t\t");
            }
            _builder.append("\t\t");
            _builder.append("new de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess(ctx, this.assemblyContext.getId(), false, ctx.getResourceTableManager()){");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("public void executeBehaviour() {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("try {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("// this.forkContext refers to the member variable ForkedBehaviorProcess.forkContext");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            String _actionsAsCalls_1 = this._simJavaCoreXpt.actionsAsCalls(this._pCMext.findStart(f_1.getSteps_Behaviour()), "this.forkContext");
            _builder.append(_actionsAsCalls_1, "\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("} catch (de.uka.ipd.sdq.simucomframework.exceptions.FailureException exception) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("if (ctx.getModel().getConfig().getSimulateFailures()) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t\t");
            _builder.append("ctx.getModel().getFailureStatistics().increaseUnhandledFailureCounter(exception.getFailureType(), ctx.getSessionId());");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new de.uka.ipd.sdq.simucomframework.fork.ForkExecutor(ctx.getThread(),forks).run();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Override
  protected CharSequence _action(final DelegatingExternalCallAction deca) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> currentFrame = ctx");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append(".getStack().currentStackFrame();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// prepare stackframe");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> stackframe = ctx");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append(".getStack().createAndPushNewStackFrame(currentFrame);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stackframe.addVariables(methodBodyStackFrame);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stackframe.addVariables(resultStackFrame);");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> callResult =");
    _builder.newLine();
    _builder.append("   \t");
    _builder.append("myContext.getRole");
    String _javaName = this._javaNamesExt.javaName(deca.getRole_ExternalService());
    _builder.append(_javaName, "   \t");
    _builder.append("().");
    String _javaSignature = this._javaNamesExt.javaSignature(deca.getCalledService_ExternalService());
    _builder.append(_javaSignature, "   \t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t   \t");
    _builder.append("(");
    CharSequence _parameterUsageListTM = this._simJavaCoreXpt.parameterUsageListTM(deca.getCalledService_ExternalService());
    _builder.append(_parameterUsageListTM, "\t   \t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("resultStackFrame.addVariables(callResult);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Copy the result variables in my own stack frame so that we can access them in the post actions");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("methodBodyStackFrame.addVariables(callResult);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ctx.getStack().removeStackFrame();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Override
  public CharSequence action(final AbstractAction deca) {
    if (deca instanceof DelegatingExternalCallAction) {
      return _action((DelegatingExternalCallAction)deca);
    } else if (deca instanceof CollectionIteratorAction) {
      return _action((CollectionIteratorAction)deca);
    } else if (deca instanceof LoopAction) {
      return _action((LoopAction)deca);
    } else if (deca instanceof AcquireAction) {
      return _action((AcquireAction)deca);
    } else if (deca instanceof BranchAction) {
      return _action((BranchAction)deca);
    } else if (deca instanceof ExternalCallAction) {
      return _action((ExternalCallAction)deca);
    } else if (deca instanceof ForkAction) {
      return _action((ForkAction)deca);
    } else if (deca instanceof InternalAction) {
      return _action((InternalAction)deca);
    } else if (deca instanceof ReleaseAction) {
      return _action((ReleaseAction)deca);
    } else if (deca instanceof SetVariableAction) {
      return _action((SetVariableAction)deca);
    } else if (deca instanceof StartAction) {
      return _action((StartAction)deca);
    } else if (deca instanceof StopAction) {
      return _action((StopAction)deca);
    } else if (deca instanceof RecoveryAction) {
      return _action((RecoveryAction)deca);
    } else if (deca != null) {
      return _action(deca);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(deca).toString());
    }
  }

  public CharSequence branchTransition(final AbstractBranchTransition gbt, final String counterNumber) {
    if (gbt instanceof GuardedBranchTransition) {
      return _branchTransition((GuardedBranchTransition)gbt, counterNumber);
    } else if (gbt instanceof ProbabilisticBranchTransition) {
      return _branchTransition((ProbabilisticBranchTransition)gbt, counterNumber);
    } else if (gbt != null) {
      return _branchTransition(gbt, counterNumber);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(gbt, counterNumber).toString());
    }
  }
}
