package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;

@SuppressWarnings("all")
public abstract class ComposedStructureXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private DelegatorClassXpt _delegatorClassXpt;

  public CharSequence composedStructureStart(final ComposedProvidingRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(entity);
    _builder.append(_implementationPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _className = this._javaNamesExt.className(entity);
    _builder.append(_className);
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _className_1 = this._javaNamesExt.className(entity);
    _builder.append(_className_1, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    CharSequence _constructor = this.constructor(entity);
    _builder.append(_constructor);
    _builder.newLineIfNotEmpty();
    CharSequence _innerImplementation = this.innerImplementation(entity);
    _builder.append(_innerImplementation);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence constructor(final ComposedProvidingRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _composedPREConstructorStartTM = this.composedPREConstructorStartTM(entity);
    _builder.append(_composedPREConstructorStartTM);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("logger.info(\"Creating composed structure ");
    String _entityName = entity.getEntityName();
    _builder.append(_entityName, "\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _allChildMemberVarInit = this.allChildMemberVarInit(entity);
    _builder.append(_allChildMemberVarInit, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.newLine();
    {
      if ((entity instanceof InterfaceProvidingEntity)) {
        _builder.append("\t");
        _builder.append("/* And finally, my ports */");
        _builder.newLine();
        {
          Iterable<OperationProvidedRole> _filter = Iterables.<OperationProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class);
          for(final OperationProvidedRole role : _filter) {
            _builder.append("\t");
            CharSequence _portInit = this.portInit(role, entity);
            _builder.append(_portInit, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          Iterable<InfrastructureProvidedRole> _filter_1 = Iterables.<InfrastructureProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class);
          for(final InfrastructureProvidedRole role_1 : _filter_1) {
            _builder.append("\t");
            CharSequence _portInit_1 = this.portInit(role_1, entity);
            _builder.append(_portInit_1, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }

  public CharSequence composedPREConstructorStartTM(final ComposedProvidingRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("public ");
    String _className = this._javaNamesExt.className(entity);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public abstract CharSequence composedStructureEnd(final ComposedStructure entity);

  public abstract CharSequence componentConstructorParametersTM(final AssemblyContext obj);

  public CharSequence childMemberVar(final AssemblyContext ac) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    _builder.newLine();
    _builder.append("   ");
    String _fqn = this._javaNamesExt.fqn(ac.getEncapsulatedComponent__AssemblyContext());
    _builder.append(_fqn, "   ");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("my");
    String _javaName = this._javaNamesExt.javaName(ac);
    _builder.append(_javaName, "      ");
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence allChildMemberVarInit(final ComposedProvidingRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<AssemblyContext> _assemblyContexts__ComposedStructure = entity.getAssemblyContexts__ComposedStructure();
      for(final AssemblyContext context : _assemblyContexts__ComposedStructure) {
        CharSequence _childMemberVarInitTM = this.childMemberVarInitTM(context);
        _builder.append(_childMemberVarInitTM);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence childMemberVarInitTM(final AssemblyContext context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("my");
    String _javaName = this._javaNamesExt.javaName(context);
    _builder.append(_javaName);
    _builder.append(" = new ");
    String _fqn = this._javaNamesExt.fqn(context.getEncapsulatedComponent__AssemblyContext());
    _builder.append(_fqn);
    _builder.newLineIfNotEmpty();
    _builder.append("      \t");
    _builder.append("(");
    CharSequence _componentConstructorParametersTM = this.componentConstructorParametersTM(context);
    _builder.append(_componentConstructorParametersTM, "      \t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence innerImplementation(final ComposedStructure cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("// Composed child components member variables");
    _builder.newLine();
    _builder.append("\t");
    {
      EList<AssemblyContext> _assemblyContexts__ComposedStructure = cs.getAssemblyContexts__ComposedStructure();
      for(final AssemblyContext context : _assemblyContexts__ComposedStructure) {
        CharSequence _childMemberVar = this.childMemberVar(context);
        _builder.append(_childMemberVar, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* Inner Structure initialisation");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void initInnerComponents() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/* First, initialize composite child structures */");
    _builder.newLine();
    {
      final Function1<AssemblyContext, Boolean> _function = (AssemblyContext c) -> {
        RepositoryComponent _encapsulatedComponent__AssemblyContext = c.getEncapsulatedComponent__AssemblyContext();
        return Boolean.valueOf((_encapsulatedComponent__AssemblyContext instanceof ComposedStructure));
      };
      Iterable<AssemblyContext> _filter = IterableExtensions.<AssemblyContext>filter(cs.getAssemblyContexts__ComposedStructure(), _function);
      for(final AssemblyContext child : _filter) {
        _builder.append("\t\t");
        _builder.append("init");
        String _javaName = this._javaNamesExt.javaName(child);
        _builder.append(_javaName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("/* Then initialize basic components */");
    _builder.newLine();
    {
      final Function1<AssemblyContext, Boolean> _function_1 = (AssemblyContext c) -> {
        RepositoryComponent _encapsulatedComponent__AssemblyContext = c.getEncapsulatedComponent__AssemblyContext();
        return Boolean.valueOf((!(_encapsulatedComponent__AssemblyContext instanceof ComposedStructure)));
      };
      Iterable<AssemblyContext> _filter_1 = IterableExtensions.<AssemblyContext>filter(cs.getAssemblyContexts__ComposedStructure(), _function_1);
      for(final AssemblyContext child_1 : _filter_1) {
        _builder.append("\t\t");
        _builder.append("init");
        String _javaName_1 = this._javaNamesExt.javaName(child_1);
        _builder.append(_javaName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    {
      EList<AssemblyContext> _assemblyContexts__ComposedStructure_1 = cs.getAssemblyContexts__ComposedStructure();
      for(final AssemblyContext context_1 : _assemblyContexts__ComposedStructure_1) {
        CharSequence _init = this.init(context_1, cs);
        _builder.append(_init, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("* Inner Structure initialisation end");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _portInit(final OperationProvidedRole role, final ComposedStructure cs) {
    StringConcatenation _builder = new StringConcatenation();
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = new ");
    String _fqnPort = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    {
      boolean _hasProvidedDelegationConnector = this._pCMext.hasProvidedDelegationConnector(cs, role);
      if (_hasProvidedDelegationConnector) {
        _builder.append("\t\t");
        _builder.append("my");
        String _javaName = this._javaNamesExt.javaName(this._pCMext.getProvidedDelegationConnector(cs, role).getAssemblyContext_ProvidedDelegationConnector());
        _builder.append(_javaName, "\t\t");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _portGetterName = this._javaNamesExt.portGetterName(this._pCMext.getProvidedDelegationConnector(cs, role).getInnerProvidedRole_ProvidedDelegationConnector());
        _builder.append(_portGetterName, "\t\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t\t");
        _builder.append("null");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append(");");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _portInit(final InfrastructureProvidedRole role, final ComposedStructure cs) {
    StringConcatenation _builder = new StringConcatenation();
    String _portMemberVar = this._javaNamesExt.portMemberVar(role);
    _builder.append(_portMemberVar);
    _builder.append(" = new ");
    String _fqnPort = this._javaNamesExt.fqnPort(role);
    _builder.append(_fqnPort);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    {
      boolean _hasProvidedInfrastructureDelegationConnector = this._pCMext.hasProvidedInfrastructureDelegationConnector(cs, role);
      if (_hasProvidedInfrastructureDelegationConnector) {
        _builder.append("\t\t");
        _builder.append("my");
        String _javaName = this._javaNamesExt.javaName(this._pCMext.getProvidedInfastructureDelegationConnector(cs, role).getAssemblyContext__ProvidedInfrastructureDelegationConnector());
        _builder.append(_javaName, "\t\t");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _portGetterName = this._javaNamesExt.portGetterName(this._pCMext.getProvidedInfastructureDelegationConnector(cs, role).getInnerProvidedRole__ProvidedInfrastructureDelegationConnector());
        _builder.append(_portGetterName, "\t\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t\t");
        _builder.append("null");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append(");");
    _builder.newLine();
    return _builder;
  }

  public CharSequence init(final AssemblyContext context, final ComposedStructure s) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private void init");
    String _javaName = this._javaNamesExt.javaName(context);
    _builder.append(_javaName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _fqnContext = this._javaNamesExt.fqnContext(context.getEncapsulatedComponent__AssemblyContext());
    _builder.append(_fqnContext, "\t");
    _builder.append(" context = new ");
    String _fqnContext_1 = this._javaNamesExt.fqnContext(context.getEncapsulatedComponent__AssemblyContext());
    _builder.append(_fqnContext_1, "\t");
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    {
      Iterable<OperationRequiredRole> _filter = Iterables.<OperationRequiredRole>filter(context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class);
      boolean _hasElements = false;
      for(final OperationRequiredRole role : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t");
        }
        _builder.append("\t");
        CharSequence _portQuery = this.portQuery(role, s, context);
        _builder.append(_portQuery, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      int _size = IterableExtensions.size(Iterables.<InfrastructureRequiredRole>filter(context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t");
        {
          int _size_1 = IterableExtensions.size(Iterables.<OperationRequiredRole>filter(context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class));
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            _builder.append(",");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          Iterable<InfrastructureRequiredRole> _filter_1 = Iterables.<InfrastructureRequiredRole>filter(context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class);
          boolean _hasElements_1 = false;
          for(final InfrastructureRequiredRole role_1 : _filter_1) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(",", "\t");
            }
            _builder.append("\t");
            CharSequence _portQuery_1 = this.portQuery(role_1, s, context);
            _builder.append(_portQuery_1, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append(");");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _childInitTM = this.childInitTM(context, s);
    _builder.append(_childInitTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("my");
    String _javaName_1 = this._javaNamesExt.javaName(context);
    _builder.append(_javaName_1, "\t");
    _builder.append(".setContext(context);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public abstract CharSequence childInitTM(final AssemblyContext context, final ComposedStructure s);

  protected CharSequence _portQuery(final OperationRequiredRole role, final ComposedStructure s, final AssemblyContext ctx) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasConnector = this._pCMext.hasConnector(s, ctx, role);
      if (_hasConnector) {
        Connector _connector = this._pCMext.getConnector(s, ctx, role);
        final AssemblyConnector connector = ((AssemblyConnector) _connector);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* From Connector ");
        String _id = connector.getId();
        _builder.append(_id, "\t");
        _builder.append(" */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("my");
        String _javaName = this._javaNamesExt.javaName(connector.getProvidingAssemblyContext_AssemblyConnector());
        _builder.append(_javaName, "\t");
        _builder.append(".");
        String _portGetterName = this._javaNamesExt.portGetterName(connector.getProvidedRole_AssemblyConnector());
        _builder.append(_portGetterName, "\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
      } else {
        {
          boolean _hasRequiredDelegationConnector = this._pCMext.hasRequiredDelegationConnector(s, ctx, role);
          if (_hasRequiredDelegationConnector) {
            {
              if ((s instanceof Completion)) {
                OperationInterface _requiredInterface__OperationRequiredRole = role.getRequiredInterface__OperationRequiredRole();
                String _javaName_1 = this._javaNamesExt.javaName(s);
                String _plus = (_javaName_1 + "Delegator");
                this._delegatorClassXpt.delegatorClass(_requiredInterface__OperationRequiredRole, _plus);
                _builder.newLineIfNotEmpty();
                _builder.append("new ");
                String _implementationPackage = this._javaNamesExt.implementationPackage(role.getRequiredInterface__OperationRequiredRole());
                _builder.append(_implementationPackage);
                _builder.append(".delegates.");
                String _javaName_2 = this._javaNamesExt.javaName(s);
                String _plus_1 = (_javaName_2 + "Delegator");
                _builder.append(_plus_1);
                String _javaName_3 = this._javaNamesExt.javaName(role.getRequiredInterface__OperationRequiredRole());
                _builder.append(_javaName_3);
                _builder.newLineIfNotEmpty();
                _builder.append("(");
                _builder.newLine();
              }
            }
            final RequiredDelegationConnector connector2 = this._pCMext.getRequiredDelegationConnector(s, ctx, role);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this.myContext.getRole");
            String _javaName_4 = this._javaNamesExt.javaName(connector2.getOuterRequiredRole_RequiredDelegationConnector());
            _builder.append(_javaName_4, "\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            {
              if ((s instanceof Completion)) {
                _builder.append(")");
                _builder.newLine();
              }
            }
          } else {
            _builder.append("null");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _portQuery(final InfrastructureRequiredRole role, final ComposedStructure s, final AssemblyContext ctx) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasConnector = this._pCMext.hasConnector(s, ctx, role);
      if (_hasConnector) {
        Connector _connector = this._pCMext.getConnector(s, ctx, role);
        final AssemblyInfrastructureConnector connector = ((AssemblyInfrastructureConnector) _connector);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* From Connector ");
        String _id = connector.getId();
        _builder.append(_id, "\t");
        _builder.append(" */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("my");
        String _javaName = this._javaNamesExt.javaName(connector.getProvidingAssemblyContext__AssemblyInfrastructureConnector());
        _builder.append(_javaName, "\t");
        _builder.append(".");
        String _portGetterName = this._javaNamesExt.portGetterName(connector.getProvidedRole__AssemblyInfrastructureConnector());
        _builder.append(_portGetterName, "\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
      } else {
        {
          boolean _hasRequiredInfrastructureDelegationConnector = this._pCMext.hasRequiredInfrastructureDelegationConnector(s, ctx, role);
          if (_hasRequiredInfrastructureDelegationConnector) {
            {
              if ((s instanceof Completion)) {
                InfrastructureInterface _requiredInterface__InfrastructureRequiredRole = role.getRequiredInterface__InfrastructureRequiredRole();
                String _javaName_1 = this._javaNamesExt.javaName(s);
                String _plus = (_javaName_1 + "Delegator");
                this._delegatorClassXpt.delegatorClass(_requiredInterface__InfrastructureRequiredRole, _plus);
                _builder.newLineIfNotEmpty();
                _builder.append("new ");
                String _implementationPackage = this._javaNamesExt.implementationPackage(role.getRequiredInterface__InfrastructureRequiredRole());
                _builder.append(_implementationPackage);
                _builder.append(".delegates.");
                String _javaName_2 = this._javaNamesExt.javaName(s);
                String _plus_1 = (_javaName_2 + "Delegator");
                _builder.append(_plus_1);
                String _javaName_3 = this._javaNamesExt.javaName(role.getRequiredInterface__InfrastructureRequiredRole());
                _builder.append(_javaName_3);
                _builder.newLineIfNotEmpty();
                _builder.append("(");
                _builder.newLine();
              }
            }
            final RequiredInfrastructureDelegationConnector connector2 = this._pCMext.getRequiredInfrastructureDelegationConnector(s, ctx, role);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this.myContext.getRole");
            String _javaName_4 = this._javaNamesExt.javaName(connector2.getOuterRequiredRole__RequiredInfrastructureDelegationConnector());
            _builder.append(_javaName_4, "\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            {
              if ((s instanceof Completion)) {
                _builder.append(")");
                _builder.newLine();
              }
            }
          } else {
            _builder.append("null");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence portInit(final ProvidedRole role, final ComposedStructure cs) {
    if (role instanceof InfrastructureProvidedRole) {
      return _portInit((InfrastructureProvidedRole)role, cs);
    } else if (role instanceof OperationProvidedRole) {
      return _portInit((OperationProvidedRole)role, cs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role, cs).toString());
    }
  }

  public CharSequence portQuery(final RequiredRole role, final ComposedStructure s, final AssemblyContext ctx) {
    if (role instanceof InfrastructureRequiredRole) {
      return _portQuery((InfrastructureRequiredRole)role, s, ctx);
    } else if (role instanceof OperationRequiredRole) {
      return _portQuery((OperationRequiredRole)role, s, ctx);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role, s, ctx).toString());
    }
  }
}
