package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import de.uka.ipd.sdq.pcm.transformations.Helper;
import java.util.Arrays;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

@SuppressWarnings("all")
public class JavaNamesExt {
  public String removeAllSpecialChars(final String s) {
    return Helper.removeAllSpecialChars(s);
  }

  public String javaName(final Entity e) {
    return e.getEntityName().replaceAll("\"", "_").replaceAll(" ", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll(":", "_").replaceAll("\\.", "_").replaceAll("\\,", "_").replaceAll("\\+", "_").replaceAll("-", "_").replaceAll("\\(", "_").replaceAll("\\)", "_");
  }

  public String javaString(final String s) {
    return s.replaceAll("\"", "\\\\\"").replaceAll(" ", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll(":", "_").replaceAll("\\.", "_");
  }

  public String javaVariableName(final String s) {
    return s.replaceAll("\"", "_").replaceAll(" ", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll(":", "_").replaceAll("\\.", "_").replaceAll("\\,", "_").replaceAll("\\+", "_").replaceAll("-", "__").replaceAll("\\(", "_").replaceAll("\\)", "_");
  }

  public String specificationString(final String s) {
    return this.removeAllSpecialChars(s.replaceAll("\"", "\\\\\""));
  }

  public String javaSignature(final OperationSignature s) {
    String _entityName = s.getEntityName();
    String _posInInterface = this.posInInterface(s, 0);
    return (_entityName + _posInInterface);
  }

  public String posInInterface(final OperationSignature s, final int pos) {
    String _xifexpression = null;
    OperationSignature _get = s.getInterface__OperationSignature().getSignatures__OperationInterface().get(pos);
    boolean _equals = Objects.equal(_get, s);
    if (_equals) {
      _xifexpression = Integer.valueOf(pos).toString();
    } else {
      _xifexpression = this.posInInterface(s, (pos + 1));
    }
    return _xifexpression;
  }

  public String javaSignature(final InfrastructureSignature s) {
    String _entityName = s.getEntityName();
    String _posInInterface = this.posInInterface(s, 0);
    return (_entityName + _posInInterface);
  }

  public String posInInterface(final InfrastructureSignature s, final int pos) {
    String _xifexpression = null;
    InfrastructureSignature _get = s.getInfrastructureInterface__InfrastructureSignature().getInfrastructureSignatures__InfrastructureInterface().get(pos);
    boolean _equals = Objects.equal(_get, s);
    if (_equals) {
      _xifexpression = Integer.valueOf(pos).toString();
    } else {
      _xifexpression = this.posInInterface(s, (pos + 1));
    }
    return _xifexpression;
  }

  protected String _portClassName(final OperationProvidedRole r) {
    String _javaName = this.javaName(r.getProvidedInterface__OperationProvidedRole());
    String _plus = (_javaName + "_");
    String _javaName_1 = this.javaName(r.getProvidingEntity_ProvidedRole());
    return (_plus + _javaName_1);
  }

  protected String _portClassName(final InfrastructureProvidedRole r) {
    String _javaName = this.javaName(r.getProvidedInterface__InfrastructureProvidedRole());
    String _plus = (_javaName + "_");
    String _javaName_1 = this.javaName(r.getProvidingEntity_ProvidedRole());
    return (_plus + _javaName_1);
  }

  public String contextClassName(final InterfaceRequiringEntity c) {
    String _javaName = this.javaName(c);
    return (_javaName + "Context");
  }

  public String contextInterfaceName(final InterfaceRequiringEntity c) {
    String _javaName = this.javaName(c);
    String _plus = ("I" + _javaName);
    return (_plus + "Context");
  }

  protected String _portMemberVar(final OperationProvidedRole r) {
    String _javaName = this.javaName(r);
    return ("m_port" + _javaName);
  }

  protected String _portMemberVar(final InfrastructureProvidedRole r) {
    String _javaName = this.javaName(r);
    return ("m_port" + _javaName);
  }

  protected String _portGetterName(final OperationProvidedRole r) {
    String _javaName = this.javaName(r);
    return ("getPort" + _javaName);
  }

  protected String _portGetterName(final InfrastructureProvidedRole r) {
    String _javaName = this.javaName(r);
    return ("getPort" + _javaName);
  }

  public String className(final ComposedStructure s) {
    return this.javaName(s);
  }

  public String fqnAllocationContextPackage(final Allocation a) {
    String _implementationPackage = this.implementationPackage(a.getSystem_Allocation());
    return (_implementationPackage + ".allocation");
  }

  public String fqnAllocationContextClass(final Allocation a) {
    String _javaName = this.javaName(a);
    return (_javaName + "RuntimeContext");
  }

  public String fqnAllocationContext(final Allocation a) {
    String _fqnAllocationContextPackage = this.fqnAllocationContextPackage(a);
    String _plus = (_fqnAllocationContextPackage + ".");
    String _fqnAllocationContextClass = this.fqnAllocationContextClass(a);
    return (_plus + _fqnAllocationContextClass);
  }

  protected String _fqn(final Entity e) {
    return "Should never be called";
  }

  protected String _fqn(final OperationInterface i) {
    String _implementationPackage = this.implementationPackage(i);
    String _plus = (_implementationPackage + ".");
    String _javaName = this.javaName(i);
    return (_plus + _javaName);
  }

  protected String _fqn(final InfrastructureInterface i) {
    String _implementationPackage = this.implementationPackage(i);
    String _plus = (_implementationPackage + ".");
    String _javaName = this.javaName(i);
    return (_plus + _javaName);
  }

  protected String _fqn(final RepositoryComponent c) {
    String _implementationPackage = this.implementationPackage(c);
    String _plus = (_implementationPackage + ".");
    String _javaName = this.javaName(c);
    return (_plus + _javaName);
  }

  protected String _fqn(final org.palladiosimulator.pcm.system.System s) {
    String _implementationPackage = this.implementationPackage(s);
    String _plus = (_implementationPackage + ".");
    String _javaName = this.javaName(s);
    return (_plus + _javaName);
  }

  protected String _fqn(final UsageScenario us) {
    String _implementationPackage = this.implementationPackage(us);
    String _plus = (_implementationPackage + ".");
    String _javaName = this.javaName(us);
    return (_plus + _javaName);
  }

  public String fqnContextPackage(final Entity c) {
    String _implementationPackage = this.implementationPackage(c);
    return (_implementationPackage + ".contexts");
  }

  public String fqnContext(final InterfaceRequiringEntity c) {
    String _fqnContextPackage = this.fqnContextPackage(c);
    String _plus = (_fqnContextPackage + ".");
    String _contextClassName = this.contextClassName(c);
    return (_plus + _contextClassName);
  }

  public String fqnContextInterface(final InterfaceRequiringEntity c) {
    String _fqnContextPackage = this.fqnContextPackage(c);
    String _plus = (_fqnContextPackage + ".I");
    String _contextClassName = this.contextClassName(c);
    return (_plus + _contextClassName);
  }

  protected String _fqnPortPackage(final OperationProvidedRole pr) {
    String _implementationPackage = this.implementationPackage(pr.getProvidingEntity_ProvidedRole());
    return (_implementationPackage + ".ports");
  }

  protected String _fqnPortPackage(final InfrastructureProvidedRole pr) {
    String _implementationPackage = this.implementationPackage(pr.getProvidingEntity_ProvidedRole());
    return (_implementationPackage + ".ports");
  }

  protected String _fqnPort(final OperationProvidedRole pr) {
    String _implementationPackage = this.implementationPackage(pr.getProvidingEntity_ProvidedRole());
    String _plus = (_implementationPackage + ".ports.");
    String _portClassName = this.portClassName(pr);
    return (_plus + _portClassName);
  }

  protected String _fqnPort(final InfrastructureProvidedRole pr) {
    String _implementationPackage = this.implementationPackage(pr.getProvidingEntity_ProvidedRole());
    String _plus = (_implementationPackage + ".ports.");
    String _portClassName = this.portClassName(pr);
    return (_plus + _portClassName);
  }

  public String beanName(final RepositoryComponent c) {
    String _javaName = this.javaName(c);
    return (_javaName + "Bean");
  }

  public String fqnInterface(final InterfaceProvidingEntity c) {
    String _implementationPackage = this.implementationPackage(c);
    String _plus = (_implementationPackage + ".I");
    String _javaName = this.javaName(c);
    return (_plus + _javaName);
  }

  public String interfaceName(final InterfaceProvidingEntity c) {
    String _javaName = this.javaName(c);
    return ("I" + _javaName);
  }

  protected String _dummyComponentName(final OperationRequiredRole rr) {
    String _javaName = this.javaName(rr.getRequiredInterface__OperationRequiredRole());
    return (_javaName + "Dummy");
  }

  protected String _dummyComponentName(final InfrastructureRequiredRole rr) {
    String _javaName = this.javaName(rr.getRequiredInterface__InfrastructureRequiredRole());
    return (_javaName + "Dummy");
  }

  protected String _fqnDummyComponentPackage(final OperationRequiredRole rr) {
    return "dummies";
  }

  protected String _fqnDummyComponentPackage(final InfrastructureRequiredRole rr) {
    return "dummies";
  }

  protected String _fqnDummyComponent(final OperationRequiredRole rr) {
    String _fqnDummyComponentPackage = this.fqnDummyComponentPackage(rr);
    String _plus = (_fqnDummyComponentPackage + ".");
    String _dummyComponentName = this.dummyComponentName(rr);
    return (_plus + _dummyComponentName);
  }

  protected String _fqnDummyComponent(final InfrastructureRequiredRole rr) {
    String _fqnDummyComponentPackage = this.fqnDummyComponentPackage(rr);
    String _plus = (_fqnDummyComponentPackage + ".");
    String _dummyComponentName = this.dummyComponentName(rr);
    return (_plus + _dummyComponentName);
  }

  public String basePackageName(final Entity s) {
    return this.javaName(s).toLowerCase();
  }

  protected String _implementationPackage(final Entity e) {
    return "should never be called!";
  }

  protected String _implementationPackage(final OperationInterface i) {
    return this.basePackageName(i.getRepository__Interface());
  }

  protected String _implementationPackage(final InfrastructureInterface i) {
    return this.basePackageName(i.getRepository__Interface());
  }

  protected String _implementationPackage(final org.palladiosimulator.pcm.system.System s) {
    String _basePackageName = this.basePackageName(s);
    return (_basePackageName + ".impl");
  }

  protected String _implementationPackage(final Completion s) {
    String _basePackageName = this.basePackageName(s);
    return (_basePackageName + ".impl");
  }

  protected String _implementationPackage(final UsageScenario u) {
    String _basePackageName = this.basePackageName(u);
    return (_basePackageName + ".impl");
  }

  protected String _implementationPackage(final RepositoryComponent c) {
    String _basePackageName = this.basePackageName(c.getRepository__RepositoryComponent());
    return (_basePackageName + ".impl");
  }

  protected String _implementationPackage(final FailureType ft) {
    String _basePackageName = this.basePackageName(ft.getRepository__FailureType());
    return (_basePackageName + ".exceptions");
  }

  public String fqnToDirectoryPath(final String fqn) {
    return fqn.replaceAll("\\.", "/");
  }

  public String getFileName(final Entity e) {
    String _fqnToDirectoryPath = this.fqnToDirectoryPath(this.implementationPackage(e));
    String _plus = (_fqnToDirectoryPath + "/");
    String _javaName = this.javaName(e);
    String _plus_1 = (_plus + _javaName);
    return (_plus_1 + ".java");
  }

  public String portClassName(final ProvidedRole r) {
    if (r instanceof InfrastructureProvidedRole) {
      return _portClassName((InfrastructureProvidedRole)r);
    } else if (r instanceof OperationProvidedRole) {
      return _portClassName((OperationProvidedRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(r).toString());
    }
  }

  public String portMemberVar(final ProvidedRole r) {
    if (r instanceof InfrastructureProvidedRole) {
      return _portMemberVar((InfrastructureProvidedRole)r);
    } else if (r instanceof OperationProvidedRole) {
      return _portMemberVar((OperationProvidedRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(r).toString());
    }
  }

  public String portGetterName(final ProvidedRole r) {
    if (r instanceof InfrastructureProvidedRole) {
      return _portGetterName((InfrastructureProvidedRole)r);
    } else if (r instanceof OperationProvidedRole) {
      return _portGetterName((OperationProvidedRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(r).toString());
    }
  }

  public String fqn(final Entity s) {
    if (s instanceof org.palladiosimulator.pcm.system.System) {
      return _fqn((org.palladiosimulator.pcm.system.System)s);
    } else if (s instanceof RepositoryComponent) {
      return _fqn((RepositoryComponent)s);
    } else if (s instanceof InfrastructureInterface) {
      return _fqn((InfrastructureInterface)s);
    } else if (s instanceof OperationInterface) {
      return _fqn((OperationInterface)s);
    } else if (s instanceof UsageScenario) {
      return _fqn((UsageScenario)s);
    } else if (s != null) {
      return _fqn(s);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(s).toString());
    }
  }

  public String fqnPortPackage(final ProvidedRole pr) {
    if (pr instanceof InfrastructureProvidedRole) {
      return _fqnPortPackage((InfrastructureProvidedRole)pr);
    } else if (pr instanceof OperationProvidedRole) {
      return _fqnPortPackage((OperationProvidedRole)pr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(pr).toString());
    }
  }

  public String fqnPort(final ProvidedRole pr) {
    if (pr instanceof InfrastructureProvidedRole) {
      return _fqnPort((InfrastructureProvidedRole)pr);
    } else if (pr instanceof OperationProvidedRole) {
      return _fqnPort((OperationProvidedRole)pr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(pr).toString());
    }
  }

  public String dummyComponentName(final RequiredRole rr) {
    if (rr instanceof InfrastructureRequiredRole) {
      return _dummyComponentName((InfrastructureRequiredRole)rr);
    } else if (rr instanceof OperationRequiredRole) {
      return _dummyComponentName((OperationRequiredRole)rr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(rr).toString());
    }
  }

  public String fqnDummyComponentPackage(final RequiredRole rr) {
    if (rr instanceof InfrastructureRequiredRole) {
      return _fqnDummyComponentPackage((InfrastructureRequiredRole)rr);
    } else if (rr instanceof OperationRequiredRole) {
      return _fqnDummyComponentPackage((OperationRequiredRole)rr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(rr).toString());
    }
  }

  public String fqnDummyComponent(final RequiredRole rr) {
    if (rr instanceof InfrastructureRequiredRole) {
      return _fqnDummyComponent((InfrastructureRequiredRole)rr);
    } else if (rr instanceof OperationRequiredRole) {
      return _fqnDummyComponent((OperationRequiredRole)rr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(rr).toString());
    }
  }

  public String implementationPackage(final Entity s) {
    if (s instanceof Completion) {
      return _implementationPackage((Completion)s);
    } else if (s instanceof org.palladiosimulator.pcm.system.System) {
      return _implementationPackage((org.palladiosimulator.pcm.system.System)s);
    } else if (s instanceof RepositoryComponent) {
      return _implementationPackage((RepositoryComponent)s);
    } else if (s instanceof InfrastructureInterface) {
      return _implementationPackage((InfrastructureInterface)s);
    } else if (s instanceof OperationInterface) {
      return _implementationPackage((OperationInterface)s);
    } else if (s instanceof FailureType) {
      return _implementationPackage((FailureType)s);
    } else if (s instanceof UsageScenario) {
      return _implementationPackage((UsageScenario)s);
    } else if (s != null) {
      return _implementationPackage(s);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(s).toString());
    }
  }
}
