package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class SystemXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private CompletionsXpt _completionsXpt;

  @Inject
  @Extension
  private ComposedStructureXpt _composedStructureXpt;

  @Inject
  @Extension
  private ProvidedPortsXpt _providedPortsXpt;

  @Inject
  @Extension
  private ContextPatternXpt _contextPatternXpt;

  public void root(final org.palladiosimulator.pcm.system.System s) {
    this._completionsXpt.expandCompletions(s);
    final String fileName = this._javaNamesExt.getFileName(s);
    final CharSequence fileContent = this.system(s);
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence system(final org.palladiosimulator.pcm.system.System s) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _composedStructureStart = this._composedStructureXpt.composedStructureStart(s);
    _builder.append(_composedStructureStart);
    _builder.newLineIfNotEmpty();
    CharSequence _providedPorts = this._providedPortsXpt.providedPorts(s);
    _builder.append(_providedPorts);
    _builder.newLineIfNotEmpty();
    CharSequence _requiredInterfaces = this._contextPatternXpt.requiredInterfaces(s);
    _builder.append(_requiredInterfaces);
    _builder.newLineIfNotEmpty();
    CharSequence _systemInnerAdditionsTM = this.systemInnerAdditionsTM(s);
    _builder.append(_systemInnerAdditionsTM);
    _builder.newLineIfNotEmpty();
    CharSequence _composedStructureEnd = this._composedStructureXpt.composedStructureEnd(s);
    _builder.append(_composedStructureEnd);
    _builder.newLineIfNotEmpty();
    CharSequence _systemAdditionsTM = this.systemAdditionsTM(s);
    _builder.append(_systemAdditionsTM);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence systemInnerAdditionsTM(final org.palladiosimulator.pcm.system.System s) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence systemAdditionsTM(final org.palladiosimulator.pcm.system.System s) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
