package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.CallsXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.SEFFBodyXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.SensorsExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.SensorsXpt;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.analyzer.quality.QualityRepository;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMParameterPartition;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotation;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;

@SuppressWarnings("all")
public class SimCallsXpt extends CallsXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private SensorsExt _sensorsExt;

  @Inject
  @Extension
  private SensorsXpt _sensorsXpt;

  @Inject
  @Extension
  private SEFFBodyXpt _sEFFBodyXpt;

  @Inject
  @Extension
  private SimAccuracyInfluenceExt _simAccuracyInfluenceExt;

  @Inject
  @Extension
  private SimAccuracyXpt _simAccuracyXpt;

  protected CharSequence _preCall(final OperationSignature signature, final Object call, final String prefix, final List<VariableUsage> parameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((call instanceof ExternalCallAction)) {
        final ExternalCallAction externalCall = ((ExternalCallAction) call);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        final String id = this._javaNamesExt.javaVariableName(externalCall.getId());
        _builder.newLineIfNotEmpty();
        _builder.append("//start handling potential failures");
        _builder.newLine();
        _builder.append("\t\t");
        String _javaSignature = this._javaNamesExt.javaSignature(externalCall.getCalledService_ExternalService());
        String _plus = ("tries_" + _javaSignature);
        final String triesVar = this._javaNamesExt.javaVariableName(_plus);
        _builder.newLineIfNotEmpty();
        _builder.append("int ");
        _builder.append(triesVar);
        _builder.append(" = 1 + ");
        int _retryCount = externalCall.getRetryCount();
        _builder.append(_retryCount);
        _builder.append("; //The call plus the retries");
        _builder.newLineIfNotEmpty();
        _builder.append("// Execute the external call until it succeeds or the maximal try count is exeeded.");
        _builder.newLine();
        _builder.append("boolean callSucceeded = false;");
        _builder.newLine();
        _builder.append("for(int retries=0; retries<");
        _builder.append(triesVar);
        _builder.append("; ++retries) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Check if the call has already succeeded:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(callSucceeded == true) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _initFailureHandling = this._sEFFBodyXpt.initFailureHandling(externalCall, id);
        _builder.append(_initFailureHandling, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("try { // needs to be closed after the call in PostCall");
        _builder.newLine();
        _builder.append("// end of failure handling before the call");
        _builder.newLine();
        _builder.newLine();
      }
    }
    CharSequence _genericPreCall = this.genericPreCall(signature, call, parameterUsages, prefix);
    _builder.append(_genericPreCall);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _preCall(final InfrastructureSignature signature, final Object call, final String prefix, final List<VariableUsage> parameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((!(call instanceof InternalAction))) {
        _builder.append("\t");
        _builder.newLine();
      }
    }
    CharSequence _genericPreCall = this.genericPreCall(signature, call, parameterUsages);
    _builder.append(_genericPreCall);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence genericPreCall(final OperationSignature signature, final Object call, final List<VariableUsage> parameterUsages, final String prefix) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("try {");
    _builder.newLine();
    CharSequence _prepareSimulatedStackFrame = this.prepareSimulatedStackFrame(signature, parameterUsages);
    _builder.append(_prepareSimulatedStackFrame);
    _builder.newLineIfNotEmpty();
    {
      if ((call instanceof ExternalCallAction)) {
        CharSequence _startResponseTimeMeasurementTM = this._sensorsXpt.startResponseTimeMeasurementTM(this._sensorsExt.externalCallActionDescription(signature, call));
        _builder.append(_startResponseTimeMeasurementTM);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _startResponseTimeMeasurementTM_1 = this._sensorsXpt.startResponseTimeMeasurementTM(this._sensorsExt.entryLevelSystemCallActionDescription(signature, call));
        _builder.append(_startResponseTimeMeasurementTM_1);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if (((call instanceof ExternalCallAction) || (call instanceof InternalAction))) {
        CharSequence _handleRemoteExternalCall = this.handleRemoteExternalCall(signature, prefix, "stackframe");
        _builder.append(_handleRemoteExternalCall);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> callResult =");
    _builder.newLine();
    return _builder;
  }

  public CharSequence genericPreCall(final InfrastructureSignature signature, final Object call, final List<VariableUsage> parameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _prepareSimulatedStackFrame = this.prepareSimulatedStackFrame(signature, parameterUsages);
    _builder.append(_prepareSimulatedStackFrame);
    _builder.newLineIfNotEmpty();
    {
      if ((call instanceof InternalAction)) {
        CharSequence _startResponseTimeMeasurementTM = this._sensorsXpt.startResponseTimeMeasurementTM(this._sensorsExt.internalActionDescription(signature, call));
        _builder.append(_startResponseTimeMeasurementTM);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> callResult =");
    _builder.newLine();
    return _builder;
  }

  public CharSequence prepareSimulatedStackFrame(final Signature signature, final List<VariableUsage> parameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Start Simulate an external call");
    _builder.newLine();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> currentFrame = ctx.getStack().currentStackFrame();");
    _builder.newLine();
    _builder.append("// prepare stackframe");
    _builder.newLine();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> stackframe = ctx.getStack().createAndPushNewStackFrame();");
    _builder.newLine();
    {
      for(final VariableUsage pu : parameterUsages) {
        final String lhs_prefix = this._pCMext.parameterUsageLHS(pu);
        _builder.newLineIfNotEmpty();
        {
          EList<VariableCharacterisation> _variableCharacterisation_VariableUsage = pu.getVariableCharacterisation_VariableUsage();
          for(final VariableCharacterisation vc : _variableCharacterisation_VariableUsage) {
            {
              boolean _isInnerReference = this._pCMext.isInnerReference(pu.getNamedReference__VariableUsage());
              if (_isInnerReference) {
                _builder.append("\t");
                _builder.append("stackframe.addValue(\"");
                String _string = vc.getType().toString();
                String _plus = ((lhs_prefix + ".") + _string);
                _builder.append(_plus, "\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("   \t");
                _builder.append("new de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy(\"");
                String _specificationString = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                _builder.append(_specificationString, "\t   \t");
                _builder.append("\",currentFrame.copyFrame()));");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("stackframe.addValue(\"");
                String _string_1 = vc.getType().toString();
                String _plus_1 = ((lhs_prefix + ".") + _string_1);
                _builder.append(_plus_1, "\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("   \t");
                _builder.append("ctx.evaluate(\"");
                String _specificationString_1 = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                _builder.append(_specificationString_1, "\t   \t");
                _builder.append("\",currentFrame));");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence tidySimulatedStackFrame(final Signature siganture) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ctx.getStack().removeStackFrame();");
    _builder.newLine();
    return _builder;
  }

  public CharSequence genericPostCall(final OperationSignature signature, final Object call, final String prefix, final List<VariableUsage> outParameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((call instanceof ExternalCallAction)) {
        _builder.append("\t");
        CharSequence _handleRemoteExternalCall = this.handleRemoteExternalCall(signature, prefix, "callResult");
        _builder.append(_handleRemoteExternalCall, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// Stop the time measurement");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _endResponseTimeMeasurementTM = this._sensorsXpt.endResponseTimeMeasurementTM(this._sensorsExt.externalCallActionDescription(signature, call));
        _builder.append(_endResponseTimeMeasurementTM, "\t");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t\t    ");
        _builder.append("// Stop the time measurement");
        _builder.newLine();
        _builder.append("\t");
        String _javaSignature = this._javaNamesExt.javaSignature(signature);
        String _plus = ("Call_" + _javaSignature);
        String _plus_1 = (_plus + " <EntryLevelSystemCall id: ");
        String _id = ((Entity) call).getId();
        String _plus_2 = (_plus_1 + _id);
        CharSequence _endResponseTimeMeasurementTM_1 = this._sensorsXpt.endResponseTimeMeasurementTM((_plus_2 + " >"));
        _builder.append(_endResponseTimeMeasurementTM_1, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((call instanceof AbstractAction)) {
        {
          QualityRepository _qualityAnnotationRepository = this._simAccuracyInfluenceExt.getQualityAnnotationRepository();
          boolean _notEquals = (!Objects.equal(_qualityAnnotationRepository, null));
          if (_notEquals) {
            {
              QualityAnnotation _qualityAnnotation = this._simAccuracyInfluenceExt.getQualityAnnotation(this._pCMext.getRdseff(((AbstractAction) call)));
              boolean _notEquals_1 = (!Objects.equal(_qualityAnnotation, null));
              if (_notEquals_1) {
                _builder.append("\t");
                final QualityAnnotation qualityAnnotation = this._simAccuracyInfluenceExt.getQualityAnnotation(this._pCMext.getRdseff(((AbstractAction) call)));
                _builder.newLineIfNotEmpty();
                {
                  Iterable<PCMParameterPartition> _filter = Iterables.<PCMParameterPartition>filter(qualityAnnotation.getValidForParameterPartitions(), PCMParameterPartition.class);
                  for(final PCMParameterPartition partition : _filter) {
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _checkAccuracy = this._simAccuracyXpt.checkAccuracy(partition, this._pCMext.getRdseff(((AbstractAction) call)), ((AbstractAction) call));
                    _builder.append(_checkAccuracy, "\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              } else {
                _builder.append("\t");
                _builder.append("SeverityAndIssue issue = AccuracyIssueFactory.createMissingQualityAnnotationIssue(\"");
                String _resourceName = this._simAccuracyInfluenceExt.getResourceName(this._pCMext.getRdseff(((AbstractAction) call)));
                _builder.append(_resourceName, "\t");
                _builder.append("\", \"");
                String _id_1 = this._pCMext.getRdseff(((AbstractAction) call)).getId();
                _builder.append(_id_1, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("config.addIssue(issue);");
                _builder.newLine();
              }
            }
          } else {
          }
        }
      }
    }
    _builder.newLine();
    {
      boolean _notEquals_2 = (!Objects.equal(outParameterUsages, null));
      if (_notEquals_2) {
        {
          for(final VariableUsage pu : outParameterUsages) {
            _builder.append("\t");
            final String lhs_prefix = this._pCMext.parameterUsageLHS(pu);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// Copy out parameter ");
            _builder.append(lhs_prefix, "\t\t");
            _builder.append(" to local stack frame");
            _builder.newLineIfNotEmpty();
            {
              EList<VariableCharacterisation> _variableCharacterisation_VariableUsage = pu.getVariableCharacterisation_VariableUsage();
              for(final VariableCharacterisation vc : _variableCharacterisation_VariableUsage) {
                {
                  boolean _isInnerReference = this._pCMext.isInnerReference(pu.getNamedReference__VariableUsage());
                  if (_isInnerReference) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("methodBodyStackFrame.addValue(\"");
                    String _string = vc.getType().toString();
                    String _plus_3 = ((lhs_prefix + ".") + _string);
                    _builder.append(_plus_3, "\t\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("   \t");
                    _builder.append("new de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy(\"");
                    String _specificationString = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                    _builder.append(_specificationString, "\t\t   \t");
                    _builder.append("\",callResult.copyFrame()));");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("methodBodyStackFrame.addValue(\"");
                    String _string_1 = vc.getType().toString();
                    String _plus_4 = ((lhs_prefix + ".") + _string_1);
                    _builder.append(_plus_4, "\t\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("   \t");
                    _builder.append("ctx.evaluate(\"");
                    String _specificationString_1 = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                    _builder.append(_specificationString_1, "\t\t   \t");
                    _builder.append("\",callResult));");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("finally");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _tidySimulatedStackFrame = this.tidySimulatedStackFrame(signature);
    _builder.append(_tidySimulatedStackFrame, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// END Simulate an external call");
    _builder.newLine();
    return _builder;
  }

  public CharSequence genericPostCall(final InfrastructureSignature is, final Object call, final String prefix) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Stop the time measurement");
    _builder.newLine();
    {
      if ((call instanceof InternalAction)) {
        _builder.append("\t\t    ");
        CharSequence _handleRemoteExternalCall = this.handleRemoteExternalCall(is, prefix, "callResult");
        _builder.append(_handleRemoteExternalCall, "\t\t    ");
        _builder.newLineIfNotEmpty();
        CharSequence _endResponseTimeMeasurementTM = this._sensorsXpt.endResponseTimeMeasurementTM(this._sensorsExt.internalActionDescription(is, call));
        _builder.append(_endResponseTimeMeasurementTM);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        _builder.newLine();
      }
    }
    CharSequence _tidySimulatedStackFrame = this.tidySimulatedStackFrame(is);
    _builder.append(_tidySimulatedStackFrame);
    _builder.newLineIfNotEmpty();
    _builder.append("// END Simulate an external call");
    _builder.newLine();
    return _builder;
  }

  public CharSequence postCall(final OperationSignature os, final Object call, final String prefix, final List<VariableUsage> outParameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genericPostCall = this.genericPostCall(os, call, prefix, outParameterUsages);
    _builder.append(_genericPostCall);
    _builder.newLineIfNotEmpty();
    {
      if ((call instanceof ExternalCallAction)) {
        _builder.append("} // end of try block from the pre call failure handling section");
        _builder.newLine();
        final ExternalCallAction externalCall = ((ExternalCallAction) call);
        _builder.newLineIfNotEmpty();
        final String id = this._javaNamesExt.javaVariableName(externalCall.getId());
        _builder.newLineIfNotEmpty();
        String _javaSignature = this._javaNamesExt.javaSignature(externalCall.getCalledService_ExternalService());
        String _plus = ("tries_" + _javaSignature);
        final String triesVar = this._javaNamesExt.javaVariableName(_plus);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _catchFailureExceptions = this._sEFFBodyXpt.catchFailureExceptions(externalCall, id);
        _builder.append(_catchFailureExceptions, "\t\t");
        _builder.newLineIfNotEmpty();
        String _entityName = os.getInterface__OperationSignature().getEntityName();
        String _plus_1 = ("Call " + _entityName);
        String _plus_2 = (_plus_1 + ".");
        String _javaSignature_1 = this._javaNamesExt.javaSignature(os);
        String _plus_3 = (_plus_2 + _javaSignature_1);
        String _plus_4 = (_plus_3 + " <Component: ");
        String _entityName_1 = this._pCMext.findContainerComponent(((ExternalCallAction) call)).getEntityName();
        String _plus_5 = (_plus_4 + _entityName_1);
        String _plus_6 = (_plus_5 + ", AssemblyCtx: \"+this.assemblyContext.getId()+\", CallID: ");
        String _id = ((ExternalCallAction) call).getId();
        String _plus_7 = (_plus_6 + _id);
        final String callName = (_plus_7 + ">");
        _builder.newLineIfNotEmpty();
        _builder.append("de.uka.ipd.sdq.simucomframework.ReliabilitySensorHelper.recordExternalCallResult(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"");
        _builder.append(callName, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"");
        String _id_1 = externalCall.getId();
        _builder.append(_id_1, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("failureException_");
        _builder.append(id, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ctx.getModel(),");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ctx.getThread().getRequestContext());");
        _builder.newLine();
        _builder.append("if(failureException_");
        _builder.append(id);
        _builder.append(" != null) { // failure occurred");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Check if we handle this failure-on-demand occurrence:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(!");
        CharSequence _checkIfExceptionIsHandled = this._sEFFBodyXpt.checkIfExceptionIsHandled(externalCall, id);
        _builder.append(_checkIfExceptionIsHandled, "\t");
        _builder.append(") { // is this failure type handled?");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("throw failureException_");
        _builder.append(id, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(retries == ");
        _builder.append(triesVar, "\t");
        _builder.append("-1) { // retry count exceeded?");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("throw failureException_");
        _builder.append(id, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// If the failure-on-demand occurrence is handled,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// update the failure statistics accordingly:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.getModel().getFailureStatistics().increaseFailureCounter(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.palladiosimulator.reliability.FailureStatistics.FailureType.HANDLED, failureException_");
        _builder.append(id, "\t\t");
        _builder.append(".getFailureType()); //count handled failure");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("} else {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Mark this call as successful:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("callSucceeded = true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// End failure handling section.");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence postCall(final InfrastructureSignature is, final Object call, final String prefix) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genericPostCall = this.genericPostCall(is, call, prefix);
    _builder.append(_genericPostCall);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _handleRemoteExternalCall(final OperationSignature os, final String prefix, final String nameOfStackframe) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _handleNetworkLatencyAndFailures = this.handleNetworkLatencyAndFailures(os, prefix, nameOfStackframe);
    _builder.append(_handleNetworkLatencyAndFailures);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _handleRemoteExternalCall(final InfrastructureSignature is, final String prefix, final String nameOfStackframe) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _handleNetworkLatencyAndFailures = this.handleNetworkLatencyAndFailures(is, prefix, nameOfStackframe);
    _builder.append(_handleNetworkLatencyAndFailures);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence handleNetworkLatencyAndFailures(final Signature signature, final String prefix, final String nameOfStackframe) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// If the call goes over network, simulate the link latency and the possibility of a communication link failure.");
    _builder.newLine();
    _builder.append("// Do this only in case that the \"simulate linking resources\" option is deactivated, because otherwise,");
    _builder.newLine();
    _builder.append("// completions handle the link behaviour.");
    _builder.newLine();
    _builder.append("if (!ctx.getModel().getConfiguration().getSimulateLinkingResources()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer fromContainer = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer toContainer = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fromContainer = ctx.findResource(this.assemblyContext.getId());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("toContainer = ctx.findResource(");
    _builder.append(prefix, "\t\t");
    _builder.append("getComponentAssemblyContext().getId());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} catch (de.uka.ipd.sdq.simucomframework.exceptions.ResourceContainerNotFound exception) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// If the call is system external, no target resource container will be found.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if ((fromContainer != null) && (toContainer != null) && (!fromContainer.getResourceContainerID().equals(toContainer.getResourceContainerID()))) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String linkingResourceID = main.ResourceEnvironment.getInstance().getLinkingResourceContainerID(fromContainer.getResourceContainerID(), toContainer.getResourceContainerID());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (linkingResourceID == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("linkingResourceID = main.ResourceEnvironment.getInstance().getLinkingResourceContainerID(toContainer.getResourceContainerID(), fromContainer.getResourceContainerID());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// If the linkingResourceID is NULL, we have to assume that no linking resource has been specified.");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// In this case, we assume a perfect link that never fails and has no latency and unlimited throughput.");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (linkingResourceID != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer linkingContainer = ctx.findLinkingResource(linkingResourceID);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// Load linking resource with a demand of 0 byte so that only the latency is considered.");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// The bytesize is only considered when the completions are activated (ctx.getModel().getConfig().getSimulateLinkingResources() == true).");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("double demand = 0.0;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("// If completions are activated, they fill in the results of their BYTESIZE calculation into the variable stream.BYTESIZE");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("// in the stackframe of this method (stored as currentStackframe above).");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (currentFrame.getValue(\"stream.BYTESIZE\") != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("demand = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(de.uka.ipd.sdq.simucomframework.variables.StackContext.evaluateStatic(\"stream.BYTESIZE\", Double.class, currentFrame));");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} catch(de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException valueNotInFrameException) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (ctx.getModel().getConfiguration().getSimulateThroughputOfLinkingResources()){");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("// if no stream.BYTESIZE variable is available, the demand is calculated by summing up all the sent variables with BYTESIZE characterization  ");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("java.util.ArrayList<java.util.Map.Entry<String, Object>> stackFrameContent = ");
    _builder.append(nameOfStackframe, "\t\t\t\t\t\t");
    _builder.append(".getContents();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("for (java.util.Map.Entry<String, Object> entry : stackFrameContent) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("if (entry.getKey().endsWith(\"BYTESIZE\")){");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("if (entry.getKey().contains(\".INNER.\")){");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t\t");
    _builder.append("// TODO: include logic to determine proper BYTESIZE of the call, take from completions code. ");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t\t");
    _builder.append("logger.warn(\"Network demand cannot be properly determined for INNER BYTESIZE characterizations yet, the simulation will assume that there is just a single element in the collection. Please enable the \'\'simulate middleware marshalling / demarshalling of remote calls\'\' in the feature settings tab or directly define the BYTESIZE of the collection.\");");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("demand += de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(entry.getValue());");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("} // else the demand stays 0.0");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} catch (RuntimeException e){");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("logger.error(\"Cannot cast BYTESIZE characterization of the following variable to double for calculating the network demand in \"+this.getClass()+\": \"+e.getMessage());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("linkingContainer.loadActiveResource(ctx.getThread(), fromContainer.getResourceContainerID(), linkingContainer.getLinkingResourceTypeId(), demand);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new RuntimeException(\"A component on the resource container with id \"+fromContainer.getResourceContainerID()+\" calls a component on resource container with id \"+toContainer.getResourceContainerID()+\", but there is no linking resource between the containers! Add a LinkingResource or change the component allocation.\");");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Override
  public CharSequence preCallTM(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages) {
    return this.preCall(signature, call, prefix, parameterUsages);
  }

  @Override
  public CharSequence preCallTM(final InfrastructureSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages) {
    return this.preCall(signature, call, prefix, parameterUsages);
  }

  @Override
  public CharSequence postCallTM(final InfrastructureSignature signature, final Entity call, final String prefix) {
    return this.postCall(signature, call, prefix);
  }

  @Override
  public CharSequence postCallTM(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> outParameterUsages) {
    return this.postCall(signature, call, prefix, outParameterUsages);
  }

  public CharSequence preCall(final Signature signature, final Object call, final String prefix, final List<VariableUsage> parameterUsages) {
    if (signature instanceof InfrastructureSignature) {
      return _preCall((InfrastructureSignature)signature, call, prefix, parameterUsages);
    } else if (signature instanceof OperationSignature) {
      return _preCall((OperationSignature)signature, call, prefix, parameterUsages);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature, call, prefix, parameterUsages).toString());
    }
  }

  public CharSequence handleRemoteExternalCall(final Signature is, final String prefix, final String nameOfStackframe) {
    if (is instanceof InfrastructureSignature) {
      return _handleRemoteExternalCall((InfrastructureSignature)is, prefix, nameOfStackframe);
    } else if (is instanceof OperationSignature) {
      return _handleRemoteExternalCall((OperationSignature)is, prefix, nameOfStackframe);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is, prefix, nameOfStackframe).toString());
    }
  }
}
