package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;

@SuppressWarnings("all")
public abstract class DummiesXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;

  protected void _dummyComponent(final OperationRequiredRole orr, final org.palladiosimulator.pcm.system.System s) {
    String _implementationPackage = this._javaNamesExt.implementationPackage(s);
    String _plus = (_implementationPackage + ".");
    String _fqnDummyComponent = this._javaNamesExt.fqnDummyComponent(orr);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath((_plus + _fqnDummyComponent));
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage_1 = this._javaNamesExt.implementationPackage(s);
    _builder.append(_implementationPackage_1);
    _builder.append(".");
    String _fqnDummyComponentPackage = this._javaNamesExt.fqnDummyComponentPackage(orr);
    _builder.append(_fqnDummyComponentPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("public class ");
    String _dummyComponentName = this._javaNamesExt.dummyComponentName(orr);
    _builder.append(_dummyComponentName);
    _builder.newLineIfNotEmpty();
    _builder.append("implements ");
    String _fqn = this._javaNamesExt.fqn(orr.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _dummyComponentName_1 = this._javaNamesExt.dummyComponentName(orr);
    _builder.append(_dummyComponentName_1, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _dummyComponentPortHelperMethodTM = this.dummyComponentPortHelperMethodTM(orr.getRequiredInterface__OperationRequiredRole());
    _builder.append(_dummyComponentPortHelperMethodTM, "\t");
    _builder.newLineIfNotEmpty();
    {
      EList<OperationSignature> _signatures__OperationInterface = orr.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface();
      for(final OperationSignature signature : _signatures__OperationInterface) {
        _builder.append("\t");
        CharSequence _dummyMethod = this.dummyMethod(signature, s, orr);
        _builder.append(_dummyMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected void _dummyComponent(final InfrastructureRequiredRole irr, final org.palladiosimulator.pcm.system.System s) {
    String _implementationPackage = this._javaNamesExt.implementationPackage(s);
    String _plus = (_implementationPackage + ".");
    String _fqnDummyComponent = this._javaNamesExt.fqnDummyComponent(irr);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath((_plus + _fqnDummyComponent));
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage_1 = this._javaNamesExt.implementationPackage(s);
    _builder.append(_implementationPackage_1);
    _builder.append(".");
    String _fqnDummyComponentPackage = this._javaNamesExt.fqnDummyComponentPackage(irr);
    _builder.append(_fqnDummyComponentPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _dummyComponentName = this._javaNamesExt.dummyComponentName(irr);
    _builder.append(_dummyComponentName);
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("implements ");
    String _fqn = this._javaNamesExt.fqn(irr.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static org.apache.log4j.Logger logger = ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.apache.log4j.Logger.getLogger(");
    String _dummyComponentName_1 = this._javaNamesExt.dummyComponentName(irr);
    _builder.append(_dummyComponentName_1, "\t\t");
    _builder.append(".class.getName());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _dummyComponentPortHelperMethodTM = this.dummyComponentPortHelperMethodTM(irr.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_dummyComponentPortHelperMethodTM, "\t");
    _builder.newLineIfNotEmpty();
    {
      EList<InfrastructureSignature> _infrastructureSignatures__InfrastructureInterface = irr.getRequiredInterface__InfrastructureRequiredRole().getInfrastructureSignatures__InfrastructureInterface();
      for(final InfrastructureSignature signature : _infrastructureSignatures__InfrastructureInterface) {
        _builder.append("\t");
        CharSequence _dummyMethod = this.dummyMethod(signature, s, irr);
        _builder.append(_dummyMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected CharSequence _dummyMethod(final OperationSignature os, final org.palladiosimulator.pcm.system.System s, final OperationRequiredRole r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _operationSignature = this._javaCoreXpt.operationSignature(os);
    _builder.append(_operationSignature);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _dummyMethodBodyTM = this.dummyMethodBodyTM(os, s, r);
    _builder.append(_dummyMethodBodyTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dummyMethod(final InfrastructureSignature is, final org.palladiosimulator.pcm.system.System s, final InfrastructureRequiredRole r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _infrastructureSignature = this._javaCoreXpt.infrastructureSignature(is);
    _builder.append(_infrastructureSignature);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _dummyMethodBodyTM = this.dummyMethodBodyTM(is, s, r);
    _builder.append(_dummyMethodBodyTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public abstract CharSequence dummyMethodBodyTM(final OperationSignature os, final org.palladiosimulator.pcm.system.System s, final OperationRequiredRole r);

  public abstract CharSequence dummyMethodBodyTM(final InfrastructureSignature os, final org.palladiosimulator.pcm.system.System s, final InfrastructureRequiredRole r);

  public abstract CharSequence dummyComponentPortHelperMethodTM(final OperationInterface oi);

  public abstract CharSequence dummyComponentPortHelperMethodTM(final InfrastructureInterface oi);

  public void dummyComponent(final RequiredRole irr, final org.palladiosimulator.pcm.system.System s) {
    if (irr instanceof InfrastructureRequiredRole) {
      _dummyComponent((InfrastructureRequiredRole)irr, s);
      return;
    } else if (irr instanceof OperationRequiredRole) {
      _dummyComponent((OperationRequiredRole)irr, s);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(irr, s).toString());
    }
  }

  public CharSequence dummyMethod(final Signature is, final org.palladiosimulator.pcm.system.System s, final RequiredRole r) {
    if (is instanceof InfrastructureSignature
         && r instanceof InfrastructureRequiredRole) {
      return _dummyMethod((InfrastructureSignature)is, s, (InfrastructureRequiredRole)r);
    } else if (is instanceof OperationSignature
         && r instanceof OperationRequiredRole) {
      return _dummyMethod((OperationSignature)is, s, (OperationRequiredRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is, s, r).toString());
    }
  }
}
