package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.subsystem.SubSystem;

@SuppressWarnings("all")
public abstract class RepositoryXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private ComposedStructureXpt _composedStructureXpt;

  @Inject
  @Extension
  private ContextPatternXpt _contextPatternXpt;

  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private ProvidedPortsXpt _providedPortsXpt;

  public void root(final Repository repo) {
    final Consumer<OperationInterface> _function = (OperationInterface it) -> {
      this.interfaceFile(it);
    };
    Iterables.<OperationInterface>filter(repo.getInterfaces__Repository(), OperationInterface.class).forEach(_function);
    final Consumer<InfrastructureInterface> _function_1 = (InfrastructureInterface it) -> {
      this.interfaceFile(it);
    };
    Iterables.<InfrastructureInterface>filter(repo.getInterfaces__Repository(), InfrastructureInterface.class).forEach(_function_1);
    final Consumer<RepositoryComponent> _function_2 = (RepositoryComponent it) -> {
      this.componentRoot(it);
    };
    repo.getComponents__Repository().forEach(_function_2);
  }

  protected void _interfaceFile(final OperationInterface oi) {
    final String fileName = this._javaNamesExt.getFileName(oi);
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _interfaceHeader = this.interfaceHeader(oi);
    _builder.append(_interfaceHeader);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _interfaceHelperMethodsDeclarationTM = this.interfaceHelperMethodsDeclarationTM(oi);
    _builder.append(_interfaceHelperMethodsDeclarationTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      EList<OperationSignature> _signatures__OperationInterface = oi.getSignatures__OperationInterface();
      boolean _hasElements = false;
      for(final OperationSignature iface : _signatures__OperationInterface) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(";", "\t");
        }
        CharSequence _operationSignature = this._javaCoreXpt.operationSignature(iface);
        _builder.append(_operationSignature, "\t");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected void _interfaceFile(final InfrastructureInterface ii) {
    final String fileName = this._javaNamesExt.getFileName(ii);
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _interfaceHeader = this.interfaceHeader(ii);
    _builder.append(_interfaceHeader);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _interfaceHelperMethodsDeclarationTM = this.interfaceHelperMethodsDeclarationTM(ii);
    _builder.append(_interfaceHelperMethodsDeclarationTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      EList<InfrastructureSignature> _infrastructureSignatures__InfrastructureInterface = ii.getInfrastructureSignatures__InfrastructureInterface();
      boolean _hasElements = false;
      for(final InfrastructureSignature iface : _infrastructureSignatures__InfrastructureInterface) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(";", "\t");
        }
        CharSequence _infrastructureSignature = this._javaCoreXpt.infrastructureSignature(iface);
        _builder.append(_infrastructureSignature, "\t");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  protected CharSequence _interfaceHeader(final OperationInterface oi) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _basePackageName = this._javaNamesExt.basePackageName(oi.getRepository__Interface());
    _builder.append(_basePackageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public interface ");
    String _javaName = this._javaNamesExt.javaName(oi);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _interfaceHeader(final InfrastructureInterface ii) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _basePackageName = this._javaNamesExt.basePackageName(ii.getRepository__Interface());
    _builder.append(_basePackageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public interface ");
    String _javaName = this._javaNamesExt.javaName(ii);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected void _componentRoot(final RepositoryComponent rc) {
    if ((rc instanceof SubSystem)) {
      this.compositeComponentRoot(((SubSystem) rc));
    } else {
      this._javaCoreXpt.componentImplementation(rc);
    }
  }

  protected void _componentRoot(final CompositeComponent cc) {
    this.compositeComponentRoot(cc);
  }

  protected void _componentRoot(final SubSystem ss) {
    this.compositeComponentRoot(ss);
  }

  private void compositeComponentRoot(final ComposedProvidingRequiringEntity cpre) {
    final String fileName = this._javaNamesExt.getFileName(cpre);
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _composedStructureStart = this._composedStructureXpt.composedStructureStart(cpre);
    _builder.append(_composedStructureStart);
    _builder.newLineIfNotEmpty();
    CharSequence _providedPorts = this._providedPortsXpt.providedPorts(cpre);
    _builder.append(_providedPorts);
    _builder.newLineIfNotEmpty();
    CharSequence _requiredInterfaces = this._contextPatternXpt.requiredInterfaces(cpre);
    _builder.append(_requiredInterfaces);
    _builder.newLineIfNotEmpty();
    CharSequence _composedStructureEnd = this._composedStructureXpt.composedStructureEnd(cpre);
    _builder.append(_composedStructureEnd);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public abstract CharSequence interfaceHelperMethodsDeclarationTM(final OperationInterface oi);

  public abstract CharSequence interfaceHelperMethodsDeclarationTM(final InfrastructureInterface ii);

  public void interfaceFile(final Interface ii) {
    if (ii instanceof InfrastructureInterface) {
      _interfaceFile((InfrastructureInterface)ii);
      return;
    } else if (ii instanceof OperationInterface) {
      _interfaceFile((OperationInterface)ii);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ii).toString());
    }
  }

  public CharSequence interfaceHeader(final Interface ii) {
    if (ii instanceof InfrastructureInterface) {
      return _interfaceHeader((InfrastructureInterface)ii);
    } else if (ii instanceof OperationInterface) {
      return _interfaceHeader((OperationInterface)ii);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ii).toString());
    }
  }

  public void componentRoot(final RepositoryComponent cc) {
    if (cc instanceof CompositeComponent) {
      _componentRoot((CompositeComponent)cc);
      return;
    } else if (cc instanceof SubSystem) {
      _componentRoot((SubSystem)cc);
      return;
    } else if (cc != null) {
      _componentRoot(cc);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(cc).toString());
    }
  }
}
