package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

@SuppressWarnings("all")
public abstract class UsageXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private UserActionsXpt _userActionsXpt;

  public CharSequence usageModel(final UsageModel um, final Allocation a) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<UsageScenario> _usageScenario_UsageModel = um.getUsageScenario_UsageModel();
      for(final UsageScenario scenario : _usageScenario_UsageModel) {
        CharSequence _usageScenarioTM = this.usageScenarioTM(scenario, a);
        _builder.append(_usageScenarioTM);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _mainTM = this.mainTM(um);
    _builder.append(_mainTM);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _systemMemberVar(final OperationProvidedRole opr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqn = this._javaNamesExt.fqn(opr.getProvidedInterface__OperationProvidedRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(opr);
    _builder.append(_portMemberVar);
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _systemMemberVar(final InfrastructureProvidedRole ipr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqn = this._javaNamesExt.fqn(ipr.getProvidedInterface__InfrastructureProvidedRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _portMemberVar = this._javaNamesExt.portMemberVar(ipr);
    _builder.append(_portMemberVar);
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public String userActions(final AbstractUserAction aua) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _userAction = this._userActionsXpt.userAction(aua);
    _builder.append(_userAction);
    _builder.newLineIfNotEmpty();
    {
      if ((!(aua instanceof Stop))) {
        String _userActions = this.userActions(aua.getSuccessor());
        _builder.append(_userActions);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }

  protected CharSequence _dummyRequiredSystemTM(final OperationRequiredRole orr, final org.palladiosimulator.pcm.system.System s) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("null");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dummyRequiredSystemTM(final InfrastructureRequiredRole irr, final org.palladiosimulator.pcm.system.System s) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("null");
    _builder.newLine();
    return _builder;
  }

  public CharSequence usageScenarioConstructorContextInit(final UsageScenario us, final Allocation a) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Initialise local interface pointer pointing to system roles");
    _builder.newLine();
    {
      final Function1<EntryLevelSystemCall, OperationProvidedRole> _function = (EntryLevelSystemCall it) -> {
        return it.getProvidedRole_EntryLevelSystemCall();
      };
      Set<OperationProvidedRole> _set = IterableExtensions.<OperationProvidedRole>toSet(ListExtensions.<EntryLevelSystemCall, OperationProvidedRole>map(this._pCMext.querySystemCalls(us), _function));
      for(final OperationProvidedRole pr : _set) {
        String _portMemberVar = this._javaNamesExt.portMemberVar(pr);
        _builder.append(_portMemberVar);
        _builder.append(" = my");
        String _javaName = this._javaNamesExt.javaName(pr.getProvidingEntity_ProvidedRole());
        _builder.append(_javaName);
        _builder.append(".");
        String _portGetterName = this._javaNamesExt.portGetterName(pr);
        _builder.append(_portGetterName);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public abstract CharSequence mainTM(final UsageModel um);

  public abstract CharSequence usageScenarioTM(final UsageScenario us, final Allocation a);

  public CharSequence systemMemberVar(final ProvidedRole ipr) {
    if (ipr instanceof InfrastructureProvidedRole) {
      return _systemMemberVar((InfrastructureProvidedRole)ipr);
    } else if (ipr instanceof OperationProvidedRole) {
      return _systemMemberVar((OperationProvidedRole)ipr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ipr).toString());
    }
  }

  public CharSequence dummyRequiredSystemTM(final RequiredRole irr, final org.palladiosimulator.pcm.system.System s) {
    if (irr instanceof InfrastructureRequiredRole) {
      return _dummyRequiredSystemTM((InfrastructureRequiredRole)irr, s);
    } else if (irr instanceof OperationRequiredRole) {
      return _dummyRequiredSystemTM((OperationRequiredRole)irr, s);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(irr, s).toString());
    }
  }
}
