package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.inject.Inject;
import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.analyzer.quality.parameters.ParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMOperationParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMRequiredBusinessOperationReturnParameterReference;
import org.palladiosimulator.analyzer.quality.qualityannotation.CharacterisedPCMParameterPartition;
import org.palladiosimulator.analyzer.quality.qualityannotation.CharacterisedPCMParameterPartitionInterval;
import org.palladiosimulator.analyzer.quality.qualityannotation.CharacterisedPCMParameterPartitionRange;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMParameterPartition;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;

@SuppressWarnings("all")
public class SimAccuracyXpt {
  @Inject
  @Extension
  private SimAccuracyInfluenceExt _simAccuracyInfluenceExt;

  protected CharSequence _checkAccuracy(final CharacterisedPCMParameterPartitionInterval ival, final ResourceDemandingSEFF rdseff, final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.accuracy.AccuracyAnalysisHelper.checkBoundsInterval(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\"");
    String _id = ival.getId();
    _builder.append(_id, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _resourceName = this._simAccuracyInfluenceExt.getResourceName(ival);
    _builder.append(_resourceName, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("ctx.getModel(),");
    _builder.newLine();
    {
      ParameterReference _parameterReference = ival.getPcmParameterPartition().getParameterReference();
      if ((_parameterReference instanceof PCMOperationParameterReference)) {
        _builder.append("\t");
        _builder.append("methodBodyStackFrame");
        _builder.newLine();
      } else {
        ParameterReference _parameterReference_1 = ival.getPcmParameterPartition().getParameterReference();
        if ((_parameterReference_1 instanceof PCMRequiredBusinessOperationReturnParameterReference)) {
          _builder.append("\t");
          _builder.append("callResult");
          _builder.newLine();
        } else {
          ParameterReference _parameterReference_2 = ival.getPcmParameterPartition().getParameterReference();
          if ((_parameterReference_2 instanceof PCMComponentParameterReference)) {
            _builder.append("\t");
            _builder.append("methodBodyStackFrame");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
          }
        }
      }
    }
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    {
      ParameterReference _parameterReference_3 = ival.getPcmParameterPartition().getParameterReference();
      if ((_parameterReference_3 instanceof PCMOperationParameterReference)) {
        _builder.append("\t");
        _builder.append("\"");
        String _simuComId = this._simAccuracyInfluenceExt.getSimuComId(ival.getPcmParameterPartition().getParameterReference());
        _builder.append(_simuComId, "\t");
        _builder.append(".");
        VariableCharacterisationType _forCharacterisation = ival.getForCharacterisation();
        _builder.append(_forCharacterisation, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      } else {
        ParameterReference _parameterReference_4 = ival.getPcmParameterPartition().getParameterReference();
        if ((_parameterReference_4 instanceof PCMRequiredBusinessOperationReturnParameterReference)) {
          _builder.append("\t");
          _builder.append("\"RETURN.");
          VariableCharacterisationType _forCharacterisation_1 = ival.getForCharacterisation();
          _builder.append(_forCharacterisation_1, "\t");
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        } else {
          ParameterReference _parameterReference_5 = ival.getPcmParameterPartition().getParameterReference();
          if ((_parameterReference_5 instanceof PCMComponentParameterReference)) {
            _builder.append("\t");
            _builder.append("\"");
            String _simuComId_1 = this._simAccuracyInfluenceExt.getSimuComId(ival.getPcmParameterPartition().getParameterReference());
            _builder.append(_simuComId_1, "\t");
            _builder.append(".");
            VariableCharacterisationType _forCharacterisation_2 = ival.getForCharacterisation();
            _builder.append(_forCharacterisation_2, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
          }
        }
      }
    }
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _id_1 = rdseff.getId();
    _builder.append(_id_1, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _id_2 = action.getId();
    _builder.append(_id_2, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _resourceName_1 = this._simAccuracyInfluenceExt.getResourceName(rdseff);
    _builder.append(_resourceName_1, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _specification = ival.getFrom().getSpecification();
    _builder.append(_specification, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _specification_1 = ival.getTo().getSpecification();
    _builder.append(_specification_1, "\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _checkAccuracy(final CharacterisedPCMParameterPartitionRange range, final ResourceDemandingSEFF rdseff, final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("de.uka.ipd.sdq.simucomframework.accuracy.AccuracyAnalysisHelper.checkBoundsRange(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\"");
    String _id = range.getId();
    _builder.append(_id, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _resourceName = this._simAccuracyInfluenceExt.getResourceName(range);
    _builder.append(_resourceName, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("ctx.getModel(),");
    _builder.newLine();
    {
      ParameterReference _parameterReference = range.getPcmParameterPartition().getParameterReference();
      if ((_parameterReference instanceof PCMOperationParameterReference)) {
        _builder.append("\t");
        _builder.append("ctx.getStack().currentStackFrame()");
        _builder.newLine();
      } else {
        ParameterReference _parameterReference_1 = range.getPcmParameterPartition().getParameterReference();
        if ((_parameterReference_1 instanceof PCMRequiredBusinessOperationReturnParameterReference)) {
          _builder.append("\t");
          _builder.append("callResult");
          _builder.newLine();
        } else {
          ParameterReference _parameterReference_2 = range.getPcmParameterPartition().getParameterReference();
          if ((_parameterReference_2 instanceof PCMComponentParameterReference)) {
            _builder.append("\t");
            _builder.append("ctx.getStack().currentStackFrame()");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
          }
        }
      }
    }
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    {
      ParameterReference _parameterReference_3 = range.getPcmParameterPartition().getParameterReference();
      if ((_parameterReference_3 instanceof PCMOperationParameterReference)) {
        _builder.append("\t");
        _builder.append("\"");
        String _simuComId = this._simAccuracyInfluenceExt.getSimuComId(range.getPcmParameterPartition().getParameterReference());
        _builder.append(_simuComId, "\t");
        _builder.append(".");
        VariableCharacterisationType _forCharacterisation = range.getForCharacterisation();
        _builder.append(_forCharacterisation, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      } else {
        ParameterReference _parameterReference_4 = range.getPcmParameterPartition().getParameterReference();
        if ((_parameterReference_4 instanceof PCMRequiredBusinessOperationReturnParameterReference)) {
          _builder.append("\t");
          _builder.append("\"RETURN.");
          VariableCharacterisationType _forCharacterisation_1 = range.getForCharacterisation();
          _builder.append(_forCharacterisation_1, "\t");
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        } else {
          ParameterReference _parameterReference_5 = range.getPcmParameterPartition().getParameterReference();
          if ((_parameterReference_5 instanceof PCMComponentParameterReference)) {
            _builder.append("\t");
            _builder.append("\"");
            String _simuComId_1 = this._simAccuracyInfluenceExt.getSimuComId(range.getPcmParameterPartition().getParameterReference());
            _builder.append(_simuComId_1, "\t");
            _builder.append(".");
            VariableCharacterisationType _forCharacterisation_2 = range.getForCharacterisation();
            _builder.append(_forCharacterisation_2, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
          }
        }
      }
    }
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _id_1 = rdseff.getId();
    _builder.append(_id_1, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _id_2 = action.getId();
    _builder.append(_id_2, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _resourceName_1 = this._simAccuracyInfluenceExt.getResourceName(rdseff);
    _builder.append(_resourceName_1, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      EList<PCMRandomVariable> _values = range.getValues();
      boolean _hasElements = false;
      for(final PCMRandomVariable value : _values) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "\t");
        }
        _builder.append("\"");
        String _specification = value.getSpecification();
        _builder.append(_specification, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(");");
    _builder.newLine();
    return _builder;
  }

  protected String _checkAccuracy(final CharacterisedPCMParameterPartition partition, final ResourceDemandingSEFF rdseff, final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.newLine();
    return _builder.toString();
  }

  protected String _checkAccuracy(final PCMParameterPartition partition, final ResourceDemandingSEFF rdseff, final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<CharacterisedPCMParameterPartition> _characerisedParameterPartitions = partition.getCharacerisedParameterPartitions();
      for(final CharacterisedPCMParameterPartition part : _characerisedParameterPartitions) {
        CharSequence _checkAccuracy = this.checkAccuracy(part, rdseff, action);
        _builder.append(_checkAccuracy);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }

  public CharSequence checkAccuracy(final Identifier ival, final ResourceDemandingSEFF rdseff, final AbstractAction action) {
    if (ival instanceof CharacterisedPCMParameterPartitionInterval) {
      return _checkAccuracy((CharacterisedPCMParameterPartitionInterval)ival, rdseff, action);
    } else if (ival instanceof CharacterisedPCMParameterPartitionRange) {
      return _checkAccuracy((CharacterisedPCMParameterPartitionRange)ival, rdseff, action);
    } else if (ival instanceof PCMParameterPartition) {
      return _checkAccuracy((PCMParameterPartition)ival, rdseff, action);
    } else if (ival instanceof CharacterisedPCMParameterPartition) {
      return _checkAccuracy((CharacterisedPCMParameterPartition)ival, rdseff, action);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ival, rdseff, action).toString());
    }
  }
}
