package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaCoreXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.ProvidedPortsXpt;
import java.util.Arrays;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;

@SuppressWarnings("all")
public class SimProvidedPortsXpt extends ProvidedPortsXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;

  protected CharSequence _portDelegationDelegatingCall(final OperationSignature os) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return myComponent.");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(os.getInterface__OperationSignature()));
    _builder.append(_firstLower);
    _builder.append("_");
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    _builder.append(_javaSignature);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(os);
    _builder.append(_parameterUsageListTM, "     ");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _portDelegationDelegatingCall(final InfrastructureSignature is) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return myComponent.");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(is.getInfrastructureInterface__InfrastructureSignature()));
    _builder.append(_firstLower);
    _builder.append("_");
    String _javaSignature = this._javaNamesExt.javaSignature(is);
    _builder.append(_javaSignature);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(is);
    _builder.append(_parameterUsageListTM, "     ");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _composedStructurePortDelegationDelegatingCall(final OperationSignature os, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("//logger.debug(\"Entering port of composed structure ");
    String _entityName = cs.getEntityName();
    _builder.append(_entityName);
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    CharSequence _prePortCode = this.prePortCode(cs);
    _builder.append(_prePortCode);
    _builder.newLineIfNotEmpty();
    CharSequence _returnTypeTM = this._javaCoreXpt.returnTypeTM(os);
    _builder.append(_returnTypeTM);
    _builder.append(" result = myInnerPort.");
    String _javaSignature = this._javaNamesExt.javaSignature(os);
    _builder.append(_javaSignature);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(os);
    _builder.append(_parameterUsageListTM, "     ");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _postPortCode = this.postPortCode(cs);
    _builder.append(_postPortCode);
    _builder.newLineIfNotEmpty();
    _builder.append("return result;");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedStructurePortDelegationDelegatingCall(final InfrastructureSignature is, final ComposedProvidingRequiringEntity cs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("//logger.debug(\"Entering port of composed structure ");
    String _entityName = cs.getEntityName();
    _builder.append(_entityName);
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    CharSequence _prePortCode = this.prePortCode(cs);
    _builder.append(_prePortCode);
    _builder.newLineIfNotEmpty();
    CharSequence _returnTypeTM = this._javaCoreXpt.returnTypeTM(is);
    _builder.append(_returnTypeTM);
    _builder.append(" result = myInnerPort.");
    String _javaSignature = this._javaNamesExt.javaSignature(is);
    _builder.append(_javaSignature);
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(is);
    _builder.append(_parameterUsageListTM, "     ");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _postPortCode = this.postPortCode(cs);
    _builder.append(_postPortCode);
    _builder.newLineIfNotEmpty();
    _builder.append("return result;");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _prePortCode(final ComposedProvidingRequiringEntity cpre) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _prePortCode(final Completion c) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ctx.setEvaluationMode(de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode.RETURN_DEFAULT_ON_NOT_FOUND);");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _postPortCode(final ComposedProvidingRequiringEntity cpre) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _postPortCode(final Completion c) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ctx.setEvaluationMode(de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode.EXCEPTION_ON_NOT_FOUND);");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _componentPortHelperMethods(final OperationProvidedRole opr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext() {");
    _builder.newLine();
    _builder.append("return this.myComponent.getAssemblyContext();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _componentPortHelperMethods(final InfrastructureProvidedRole ipr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext() {");
    _builder.newLine();
    _builder.append("return this.myComponent.getAssemblyContext();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedComponentPortHelperMethods(final OperationInterface oi) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext() {");
    _builder.newLine();
    _builder.append("return this.myInnerPort.getComponentAssemblyContext();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _composedComponentPortHelperMethods(final InfrastructureInterface ii) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return this.myInnerPort.getComponentAssemblyContext();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dummyComponentPortHelperMethod(final OperationInterface oi) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _dummyComponentPortHelperMethod(final InfrastructureInterface ii) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getComponentAssemblyContext() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Override
  public CharSequence componentPortHelperMethodsTM(final ProvidedRole role) {
    return this.componentPortHelperMethods(role);
  }

  @Override
  public CharSequence composedComponentPortHelperMethodsTM(final Interface iface) {
    return this.composedComponentPortHelperMethods(iface);
  }

  @Override
  public CharSequence portDelegationDelegatingCallTM(final Signature signature) {
    return this.portDelegationDelegatingCall(signature);
  }

  @Override
  public CharSequence composedStructurePortDelegationDelegatingCallTM(final Signature signature, final ComposedProvidingRequiringEntity cs) {
    return this.composedStructurePortDelegationDelegatingCall(signature, cs);
  }

  public CharSequence portDelegationDelegatingCall(final Signature is) {
    if (is instanceof InfrastructureSignature) {
      return _portDelegationDelegatingCall((InfrastructureSignature)is);
    } else if (is instanceof OperationSignature) {
      return _portDelegationDelegatingCall((OperationSignature)is);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is).toString());
    }
  }

  public CharSequence composedStructurePortDelegationDelegatingCall(final Signature is, final ComposedProvidingRequiringEntity cs) {
    if (is instanceof InfrastructureSignature) {
      return _composedStructurePortDelegationDelegatingCall((InfrastructureSignature)is, cs);
    } else if (is instanceof OperationSignature) {
      return _composedStructurePortDelegationDelegatingCall((OperationSignature)is, cs);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(is, cs).toString());
    }
  }

  public CharSequence prePortCode(final ComposedProvidingRequiringEntity c) {
    if (c instanceof Completion) {
      return _prePortCode((Completion)c);
    } else if (c != null) {
      return _prePortCode(c);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c).toString());
    }
  }

  public CharSequence postPortCode(final ComposedProvidingRequiringEntity c) {
    if (c instanceof Completion) {
      return _postPortCode((Completion)c);
    } else if (c != null) {
      return _postPortCode(c);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c).toString());
    }
  }

  public CharSequence componentPortHelperMethods(final ProvidedRole ipr) {
    if (ipr instanceof InfrastructureProvidedRole) {
      return _componentPortHelperMethods((InfrastructureProvidedRole)ipr);
    } else if (ipr instanceof OperationProvidedRole) {
      return _componentPortHelperMethods((OperationProvidedRole)ipr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ipr).toString());
    }
  }

  public CharSequence composedComponentPortHelperMethods(final Interface ii) {
    if (ii instanceof InfrastructureInterface) {
      return _composedComponentPortHelperMethods((InfrastructureInterface)ii);
    } else if (ii instanceof OperationInterface) {
      return _composedComponentPortHelperMethods((OperationInterface)ii);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ii).toString());
    }
  }

  public CharSequence dummyComponentPortHelperMethod(final Interface ii) {
    if (ii instanceof InfrastructureInterface) {
      return _dummyComponentPortHelperMethod((InfrastructureInterface)ii);
    } else if (ii instanceof OperationInterface) {
      return _dummyComponentPortHelperMethod((OperationInterface)ii);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ii).toString());
    }
  }
}
