package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.DummiesXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.UsageXpt;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UserData;
import org.palladiosimulator.pcm.usagemodel.Workload;

@SuppressWarnings("all")
public class SimUsageXpt extends UsageXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private SimUsageFactoryXpt _simUsageFactoryXpt;

  public void main(final UsageModel _this) {
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = (EntryLevelSystemCall it) -> {
      return it.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
    };
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = (InterfaceProvidingEntity it) -> {
      return ((org.palladiosimulator.pcm.system.System) it);
    };
    final List<org.palladiosimulator.pcm.system.System> systemList = this._pCMext.uniqueSystemList(ListExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(ListExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(this._pCMext.querySystemCalls(IterableExtensions.<UsageScenario>head(_this.getUsageScenario_UsageModel())), _function), _function_1));
    final String fileName = "main/SimuComControl.java";
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package main;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append("* Main class of this SimuCom instance. Used as entry by the SimuCom Framework. The ");
    _builder.newLine();
    _builder.append("* simulation starts executing in the abstract base class and calls the methods of this ");
    _builder.newLine();
    _builder.append("* class as template methods from the template method design pattern. This class is instanciated");
    _builder.newLine();
    _builder.append("* by the SimuCom framework simulation loader via the simulation dock and Eclipse\'s service");
    _builder.newLine();
    _builder.append("* instanciation mechanismn.");
    _builder.newLine();
    _builder.append("**/");
    _builder.newLine();
    _builder.append("public class SimuComControl extends de.uka.ipd.sdq.simucomframework.AbstractMain ");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Override abstract framework method and return the workloads of this usage model");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver[] getWorkloads(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("de.uka.ipd.sdq.simucomframework.SimuComConfig config, IResourceTableManager resourceTableManager) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// Create ");
    int _size = systemList.size();
    _builder.append(_size, "\t\t\t");
    _builder.append(" System(s)");
    _builder.newLineIfNotEmpty();
    {
      for(final org.palladiosimulator.pcm.system.System system : systemList) {
        _builder.append("\t\t\t");
        String _fqn = this._javaNamesExt.fqn(system);
        _builder.append(_fqn, "\t\t\t");
        _builder.append(" my");
        String _javaName = this._javaNamesExt.javaName(system);
        _builder.append(_javaName, "\t\t\t");
        _builder.append(" = new ");
        String _fqn_1 = this._javaNamesExt.fqn(system);
        _builder.append(_fqn_1, "\t\t\t");
        _builder.append("(getModel());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _usageScenarioConstructorContextInit = this.usageScenarioConstructorContextInit(system, _this);
        _builder.append(_usageScenarioConstructorContextInit, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("return new de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver[] {");
    _builder.newLine();
    _builder.append("\t\t\t");
    {
      EList<UsageScenario> _usageScenario_UsageModel = _this.getUsageScenario_UsageModel();
      boolean _hasElements = false;
      for(final UsageScenario us : _usageScenario_UsageModel) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t\t\t");
        }
        CharSequence _workloadDriver = this.workloadDriver(us);
        _builder.append(_workloadDriver, "\t\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Return the generated resource container class");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected de.uka.ipd.sdq.simucomframework.resources.IResourceContainerFactory getResourceContainerFactory(){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new ResourceEnvironment();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence usageScenarioConstructorContextInit(final org.palladiosimulator.pcm.system.System _this, final UsageModel usageModel) {
    StringConcatenation _builder = new StringConcatenation();
    String _fqnContext = this._javaNamesExt.fqnContext(_this);
    _builder.append(_fqnContext);
    _builder.append(" context");
    String _javaName = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName);
    _builder.append(" = ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("new ");
    String _fqnContext_1 = this._javaNamesExt.fqnContext(_this);
    _builder.append(_fqnContext_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("(");
    _builder.newLine();
    _builder.append("\t\t");
    {
      Iterable<OperationRequiredRole> _filter = Iterables.<OperationRequiredRole>filter(_this.getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class);
      boolean _hasElements = false;
      for(final OperationRequiredRole orr : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t\t");
        }
        CharSequence _dummyRequiredSystemTM = this.dummyRequiredSystemTM(orr, _this);
        _builder.append(_dummyRequiredSystemTM, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      int _size = IterableExtensions.size(Iterables.<InfrastructureRequiredRole>filter(_this.getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t\t");
        {
          int _size_1 = IterableExtensions.size(Iterables.<OperationRequiredRole>filter(_this.getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class));
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            _builder.append(", ");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        {
          Iterable<InfrastructureRequiredRole> _filter_1 = Iterables.<InfrastructureRequiredRole>filter(_this.getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class);
          boolean _hasElements_1 = false;
          for(final InfrastructureRequiredRole irr : _filter_1) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(",", "\t\t");
            }
            CharSequence _dummyRequiredSystemTM_1 = this.dummyRequiredSystemTM(irr, _this);
            _builder.append(_dummyRequiredSystemTM_1, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append(");");
    _builder.newLine();
    _builder.append("// read UserData");
    _builder.newLine();
    _builder.append("de.uka.ipd.sdq.simucomframework.variables.userdata.UserData userData");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("= new de.uka.ipd.sdq.simucomframework.variables.userdata.UserData();");
    _builder.newLine();
    {
      EList<UserData> _userData_UsageModel = usageModel.getUserData_UsageModel();
      for(final UserData ud : _userData_UsageModel) {
        CharSequence _initUserData = this.initUserData(ud);
        _builder.append(_initUserData);
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("context");
    String _javaName_1 = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName_1);
    _builder.append(".setUserData(userData);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("my");
    String _javaName_2 = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName_2);
    _builder.append(".setContext(context");
    String _javaName_3 = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName_3);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence initUserData(final UserData _this) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<VariableUsage> _userDataParameterUsages_UserData = _this.getUserDataParameterUsages_UserData();
      for(final VariableUsage pu : _userDataParameterUsages_UserData) {
        {
          EList<VariableCharacterisation> _variableCharacterisation_VariableUsage = pu.getVariableCharacterisation_VariableUsage();
          for(final VariableCharacterisation vc : _variableCharacterisation_VariableUsage) {
            _builder.append("userData.addUserData(");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"");
            String _id = _this.getAssemblyContext_userData().getId();
            _builder.append(_id, "\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\"");
            String _parameterUsageLHS = this._pCMext.parameterUsageLHS(pu);
            String _plus = (_parameterUsageLHS + ".");
            String _string = vc.getType().toString();
            String _plus_1 = (_plus + _string);
            _builder.append(_plus_1, "\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("new de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy(\"");
            String _specificationString = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
            _builder.append(_specificationString, "\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>()));");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  public void usageScenario(final UsageScenario _this, final Allocation a) {
    this._simUsageFactoryXpt.usageScenarioFactory(_this);
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.implementationPackage(_this));
    String _plus = (_fqnToDirectoryPath + "/");
    String _javaName = this._javaNamesExt.javaName(_this);
    String _plus_1 = (_plus + _javaName);
    final String fileName = (_plus_1 + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.append("package ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(_this);
    _builder.append(_implementationPackage, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public class ");
    String _javaName_1 = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("implements de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/** Default EMF factory for measuring points. */");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory measuringpointFactory = org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory.eINSTANCE;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("private static java.util.Map<String,java.util.List<org.palladiosimulator.probeframework.probes.Probe>> startStopProbes = null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    {
      final Function1<EntryLevelSystemCall, OperationProvidedRole> _function = (EntryLevelSystemCall it) -> {
        return it.getProvidedRole_EntryLevelSystemCall();
      };
      Set<OperationProvidedRole> _set = IterableExtensions.<OperationProvidedRole>toSet(ListExtensions.<EntryLevelSystemCall, OperationProvidedRole>map(this._pCMext.querySystemCalls(_this), _function));
      for(final OperationProvidedRole pr : _set) {
        CharSequence _systemMemberVar = this.systemMemberVar(pr);
        _builder.append(_systemMemberVar, "\t\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// Workaround to specify and retrieve the priority for a system call");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public int getPriorityForEntryLevelSystemCallID(String id){");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("int defaultPriority = 0;");
    _builder.newLine();
    {
      List<EntryLevelSystemCall> _querySystemCalls = this._pCMext.querySystemCalls(_this);
      for(final EntryLevelSystemCall entrycall : _querySystemCalls) {
        _builder.append("\t\t\t");
        _builder.append("// priority for EntrySystemLevelCall ");
        String _entityName = entrycall.getProvidedRole_EntryLevelSystemCall().getEntityName();
        _builder.append(_entityName, "\t\t\t");
        _builder.append(": ");
        int _priority = entrycall.getPriority();
        _builder.append(_priority, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if(id.equalsIgnoreCase(\"");
        String _id = entrycall.getProvidedRole_EntryLevelSystemCall().getId();
        _builder.append(_id, "\t\t\t");
        _builder.append("\")){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return ");
        int _priority_1 = entrycall.getPriority();
        _builder.append(_priority_1, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("} ");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("return defaultPriority;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("private de.uka.ipd.sdq.simucomframework.SimuComContext ctx = null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("private final de.uka.ipd.sdq.simucomframework.model.SimuComModel simuComModel;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("private de.uka.ipd.sdq.simucomframework.model.SimuComModel getModel() {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return this.simuComModel;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _usageScenarioConstructor = this.usageScenarioConstructor(_this, a);
    _builder.append(_usageScenarioConstructor, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _scenarioRunner = this.scenarioRunner(_this.getScenarioBehaviour_UsageScenario(), _this);
    _builder.append(_scenarioRunner, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("private void setupCalculators() {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    String _initCalculatorsTM = this.initCalculatorsTM(_this);
    _builder.append(_initCalculatorsTM, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence scenarioRunner(final ScenarioBehaviour _this, final UsageScenario us) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void scenarioRunner(de.uka.ipd.sdq.simucomframework.SimuComSimProcess thread) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Store our thread in the context. The thread is used later to suspend execution in case");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// of waiting at a resource");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ctx.setSimProcess(thread);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Here comes the usage scenario code...");
    _builder.newLine();
    _builder.append("\t");
    String _userActions = this.userActions(((Start[])Conversions.unwrapArray((Iterables.<Start>filter(_this.getActions_ScenarioBehaviour(), Start.class)), Start.class))[0]);
    _builder.append(_userActions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// A run through this usage model is complete");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// The counter for main measurements is incremented by the SimuComSimProcess.internalLifeCycle that called this  ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ctx.getModel().increaseMainMeasurementsCount();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence workloadDriver(final UsageScenario _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new ");
    CharSequence _workloadClass = this.workloadClass(_this.getWorkload_UsageScenario(), _this);
    _builder.append(_workloadClass);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _workloadClass(final Workload _this, final UsageScenario u) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _workloadClass(final ClosedWorkload _this, final UsageScenario u) {
    StringConcatenation _builder = new StringConcatenation();
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = (EntryLevelSystemCall it) -> {
      return it.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
    };
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = (InterfaceProvidingEntity it) -> {
      return ((org.palladiosimulator.pcm.system.System) it);
    };
    final List<org.palladiosimulator.pcm.system.System> systemList = this._pCMext.uniqueSystemList(ListExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(ListExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(this._pCMext.querySystemCalls(u), _function), _function_1));
    _builder.newLineIfNotEmpty();
    _builder.append("de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(u);
    String _plus = (_implementationPackage + ".");
    String _javaName = this._javaNamesExt.javaName(u);
    String _plus_1 = (_plus + _javaName);
    String _plus_2 = (_plus_1 + "Factory");
    _builder.append(_plus_2, "\t");
    _builder.append("(getModel(), \"");
    String _javaString = this._javaNamesExt.javaString(u.getEntityName());
    _builder.append(_javaString, "\t");
    _builder.append("\",");
    {
      boolean _hasElements = false;
      for(final org.palladiosimulator.pcm.system.System system : systemList) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t");
        }
        CharSequence _systemVariableParameter = this.systemVariableParameter(system);
        _builder.append(_systemVariableParameter, "\t");
      }
    }
    _builder.append(", resourceTableManager),");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    int _population = _this.getPopulation();
    _builder.append(_population, "\t");
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence systemVariableParameter(final org.palladiosimulator.pcm.system.System _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("my");
    String _javaName = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence systemVariableDecl(final org.palladiosimulator.pcm.system.System _this) {
    StringConcatenation _builder = new StringConcatenation();
    String _fqn = this._javaNamesExt.fqn(_this);
    _builder.append(_fqn);
    _builder.append(" my");
    String _javaName = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _workloadClass(final OpenWorkload _this, final UsageScenario u) {
    StringConcatenation _builder = new StringConcatenation();
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = (EntryLevelSystemCall it) -> {
      return it.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
    };
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = (InterfaceProvidingEntity it) -> {
      return ((org.palladiosimulator.pcm.system.System) it);
    };
    final List<org.palladiosimulator.pcm.system.System> systemList = this._pCMext.uniqueSystemList(ListExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(ListExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(this._pCMext.querySystemCalls(u), _function), _function_1));
    _builder.newLineIfNotEmpty();
    _builder.append("de.uka.ipd.sdq.simucomframework.usage.OpenWorkload(getModel(),");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(u);
    String _plus = (_implementationPackage + ".");
    String _javaName = this._javaNamesExt.javaName(u);
    String _plus_1 = (_plus + _javaName);
    String _plus_2 = (_plus_1 + "Factory");
    _builder.append(_plus_2, "\t");
    _builder.append("(getModel(), \"");
    String _javaString = this._javaNamesExt.javaString(u.getEntityName());
    _builder.append(_javaString, "\t");
    _builder.append("\",");
    {
      boolean _hasElements = false;
      for(final org.palladiosimulator.pcm.system.System system : systemList) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t");
        }
        CharSequence _systemVariableParameter = this.systemVariableParameter(system);
        _builder.append(_systemVariableParameter, "\t");
      }
    }
    _builder.append(", resourceTableManager),");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"");
    String _specificationString = this._javaNamesExt.specificationString(_this.getInterArrivalTime_OpenWorkload().getSpecification());
    _builder.append(_specificationString, "\t");
    _builder.append("\", resourceTableManager)");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence usageScenarioConstructor(final UsageScenario _this, final Allocation a) {
    StringConcatenation _builder = new StringConcatenation();
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = (EntryLevelSystemCall it) -> {
      return it.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
    };
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = (InterfaceProvidingEntity it) -> {
      return ((org.palladiosimulator.pcm.system.System) it);
    };
    final List<org.palladiosimulator.pcm.system.System> systemList = this._pCMext.uniqueSystemList(ListExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(ListExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(this._pCMext.querySystemCalls(_this), _function), _function_1));
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    String _javaName = this._javaNamesExt.javaName(_this);
    _builder.append(_javaName);
    _builder.append("(de.uka.ipd.sdq.simucomframework.model.SimuComModel model,");
    {
      boolean _hasElements = false;
      for(final org.palladiosimulator.pcm.system.System system : systemList) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        CharSequence _systemVariableDecl = this.systemVariableDecl(system);
        _builder.append(_systemVariableDecl);
      }
    }
    _builder.append(", de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager resourceTableManager) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.simuComModel = model;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ctx = new ");
    String _fqnAllocationContext = this._javaNamesExt.fqnAllocationContext(a);
    _builder.append(_fqnAllocationContext, "\t");
    _builder.append("(model, resourceTableManager);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("ctx.getStack().createAndPushNewStackFrame();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _usageScenarioConstructorContextInit = this.usageScenarioConstructorContextInit(_this, a);
    _builder.append(_usageScenarioConstructorContextInit, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (startStopProbes == null) {");
    _builder.newLine();
    _builder.append("\t    ");
    _builder.append("startStopProbes = new java.util.HashMap<String,java.util.List<org.palladiosimulator.probeframework.probes.Probe>>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setupCalculators();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Inject
  private SimCalculatorsXpt simCalculators;

  public String initCalculatorsTM(final UsageScenario _this) {
    return this.simCalculators.setupCalculators(_this);
  }

  @Inject
  private DummiesXpt dummies;

  @Override
  public CharSequence dummyRequiredSystemTM(final RequiredRole _this, final org.palladiosimulator.pcm.system.System s) {
    StringConcatenation _builder = new StringConcatenation();
    this.dummies.dummyComponent(_this, s);
    _builder.newLineIfNotEmpty();
    _builder.append("new ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(s);
    _builder.append(_implementationPackage);
    _builder.append(".");
    String _fqnDummyComponent = this._javaNamesExt.fqnDummyComponent(_this);
    _builder.append(_fqnDummyComponent);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  public CharSequence mainTM(final UsageModel um) {
    String _xblockexpression = null;
    {
      this.main(um);
      _xblockexpression = "";
    }
    return _xblockexpression;
  }

  @Override
  public CharSequence usageScenarioTM(final UsageScenario us, final Allocation a) {
    String _xblockexpression = null;
    {
      this.usageScenario(us, a);
      _xblockexpression = "";
    }
    return _xblockexpression;
  }

  public CharSequence workloadClass(final Workload _this, final UsageScenario u) {
    if (_this instanceof ClosedWorkload) {
      return _workloadClass((ClosedWorkload)_this, u);
    } else if (_this instanceof OpenWorkload) {
      return _workloadClass((OpenWorkload)_this, u);
    } else if (_this != null) {
      return _workloadClass(_this, u);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(_this, u).toString());
    }
  }
}
