/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class BuildXpt {
    @Inject
    private M2TFileSystemAccess fsa;
    @Inject
    @Extension
    private JavaNamesExt _javaNamesExt;
    @Inject
    @Extension
    private PCMext _pCMext;

    public void buildScripts(UsageModel um) {
        this.buildProperties(um);
        this.fileList(um);
        this.clientXML(um);
        this.applicationXML(um);
    }

    private void buildProperties(UsageModel um) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# Name of the application to build");
        _builder.newLine();
        _builder.append("projectname=pcm-generated-default-name");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Source Directory");
        _builder.newLine();
        _builder.append("src=src");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Class Directory");
        _builder.newLine();
        _builder.append("build=bin");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Directory in which the jar contents are collected");
        _builder.newLine();
        _builder.append("dist-dir=dist");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Path to a folder containing all additionally needed libs");
        _builder.newLine();
        _builder.append("lib-dir=libs");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Path to the SUN Appserver Bin Directory");
        _builder.newLine();
        _builder.append("sun-appserver-dir=C:/sun/sdk/bin");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Name of the Directory in which to place the final jars/ears");
        _builder.newLine();
        _builder.append("output=output");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("build.properties", fileContent);
    }

    private void fileList(UsageModel um) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<project name=\"generated-filesets\">");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<fileset id=\"client-classes\" dir=\"${dist-dir}\">");
        _builder.newLine();
        EList _usageScenario_UsageModel = um.getUsageScenario_UsageModel();
        for (UsageScenario us : _usageScenario_UsageModel) {
            _builder.append("\t\t");
            _builder.append("<include name=\"");
            String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.basePackageName((Entity)us));
            _builder.append(_fqnToDirectoryPath, "\t\t");
            _builder.append("/**/*.class\" />");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("<include name=\"*.class\" />");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<include name=\"META-INF/application-client.xml\" />");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</fileset>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<fileset id=\"ejb-classes\" dir=\"${dist-dir}\">");
        _builder.newLine();
        _builder.append("\t\t");
        Functions.Function1 _function = it -> it.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour();
        Functions.Function1 _function_1 = it -> it.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
        Set systems = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)um.getUsageScenario_UsageModel(), (Functions.Function1)_function)), EntryLevelSystemCall.class), (Functions.Function1)_function_1), System.class));
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        for (System system : systems) {
            String _includeClasses = this.includeClasses((CDOObject)system);
            _builder.append(_includeClasses, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<include name=\"META-INF/ejb-jar.xml\" />");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</fileset>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("</project>\t");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("generated-filesets.xml", fileContent);
    }

    private void applicationXML(UsageModel um) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<application version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd\">");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<display-name>@@projectname@@</display-name>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<module>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<java>@@projectname@@-client.jar</java>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("</module>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<module>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<ejb>@@projectname@@-ejb.jar</ejb>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("</module>");
        _builder.newLine();
        _builder.append("</application>");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("META-INF/application.xml", fileContent);
    }

    private void clientXML(UsageModel um) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<application-client version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<display-name>@@projectname@@-Client</display-name>");
        _builder.newLine();
        _builder.append("    ");
        Functions.Function1 _function = it -> it.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour();
        Functions.Function1 _function_1 = it -> it.getProvidedRole_EntryLevelSystemCall();
        Set systemCalls = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)um.getUsageScenario_UsageModel(), (Functions.Function1)_function)), EntryLevelSystemCall.class), (Functions.Function1)_function_1));
        _builder.newLineIfNotEmpty();
        _builder.append("   ");
        for (OperationProvidedRole systemCall : systemCalls) {
            CharSequence _ejbClientRef = this.ejbClientRef((ProvidedRole)systemCall);
            _builder.append((Object)_ejbClientRef, "   ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append(".providedRole_EntryLevelSystemCall.toSet()\u00bb");
        _builder.newLine();
        _builder.append("</application-client>");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("META-INF/application-client.xml", fileContent);
    }

    protected String _includeClasses(Repository repository) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<include name=\"");
        String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.javaName((Entity)repository).toLowerCase());
        _builder.append(_fqnToDirectoryPath);
        _builder.append("\"/**/*.class\" />");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _includeClasses(System system) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<include name=\"");
        String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.javaName((Entity)system).toLowerCase());
        _builder.append(_fqnToDirectoryPath);
        _builder.append("\"/**/*.class\" />");
        _builder.newLineIfNotEmpty();
        Set<Entity> _collectRepositories = this._pCMext.collectRepositories((CDOObject)system);
        for (Entity repository : _collectRepositories) {
            String _includeClasses = this.includeClasses((CDOObject)repository);
            _builder.append(_includeClasses);
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected CharSequence _ejbClientRef(OperationProvidedRole role) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<ejb-ref>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<ejb-ref-name>ejb/");
        String _javaName = this._javaNamesExt.javaName((Entity)role.getProvidedInterface__OperationProvidedRole());
        _builder.append(_javaName, "\t");
        _builder.append("</ejb-ref-name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<ejb-ref-type>Session</ejb-ref-type> ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<remote>");
        String _fqn = this._javaNamesExt.fqn((Entity)role.getProvidedInterface__OperationProvidedRole());
        _builder.append(_fqn, "\t");
        _builder.append("</remote>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        InterfaceProvidingEntity _providingEntity_ProvidedRole = role.getProvidingEntity_ProvidedRole();
        Functions.Function1 _function = it -> {
            OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
            return Objects.equal((Object)_outerProvidedRole_ProvidedDelegationConnector, (Object)role);
        };
        ProvidedDelegationConnector delegationConnector = (ProvidedDelegationConnector)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((System)_providingEntity_ProvidedRole).getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), (Functions.Function1)_function));
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        AssemblyContext componentContext = delegationConnector.getAssemblyContext_ProvidedDelegationConnector();
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<ejb-link>");
        String _javaName_1 = this._javaNamesExt.javaName((Entity)componentContext.getEncapsulatedComponent__AssemblyContext());
        _builder.append(_javaName_1, "\t");
        _builder.append("_");
        String _javaName_2 = this._javaNamesExt.javaName((Entity)role.getProvidedInterface__OperationProvidedRole());
        _builder.append(_javaName_2, "\t");
        _builder.append("_");
        String _id = componentContext.getId();
        _builder.append(_id, "\t");
        _builder.append("</ejb-link> ");
        _builder.newLineIfNotEmpty();
        _builder.append("</ejb-ref>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _ejbClientRef(InfrastructureProvidedRole role) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<ejb-ref>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<ejb-ref-name>ejb/");
        String _javaName = this._javaNamesExt.javaName((Entity)role.getProvidedInterface__InfrastructureProvidedRole());
        _builder.append(_javaName, "\t");
        _builder.append("</ejb-ref-name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t   ");
        _builder.append("<ejb-ref-type>Session</ejb-ref-type> ");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("<remote>");
        String _fqn = this._javaNamesExt.fqn((Entity)role.getProvidedInterface__InfrastructureProvidedRole());
        _builder.append(_fqn, "\t   ");
        _builder.append("</remote>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t   ");
        InterfaceProvidingEntity _providingEntity_ProvidedRole = role.getProvidingEntity_ProvidedRole();
        Functions.Function1 _function = it -> {
            OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
            return Objects.equal((Object)_outerProvidedRole_ProvidedDelegationConnector, (Object)role);
        };
        ProvidedDelegationConnector delegationConnector = (ProvidedDelegationConnector)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((System)_providingEntity_ProvidedRole).getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), (Functions.Function1)_function));
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        AssemblyContext componentContext = delegationConnector.getAssemblyContext_ProvidedDelegationConnector();
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<ejb-link>");
        String _javaName_1 = this._javaNamesExt.javaName((Entity)componentContext.getEncapsulatedComponent__AssemblyContext());
        _builder.append(_javaName_1, "\t");
        _builder.append("_");
        String _javaName_2 = this._javaNamesExt.javaName((Entity)role.getProvidedInterface__InfrastructureProvidedRole());
        _builder.append(_javaName_2, "\t");
        _builder.append("_");
        String _id = componentContext.getId();
        _builder.append(_id, "\t");
        _builder.append("</ejb-link> ");
        _builder.newLineIfNotEmpty();
        _builder.append("</ejb-ref>");
        _builder.newLine();
        return _builder;
    }

    public String includeClasses(CDOObject system) {
        if (system instanceof System) {
            return this._includeClasses((System)system);
        }
        if (system instanceof Repository) {
            return this._includeClasses((Repository)system);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(system).toString());
    }

    public CharSequence ejbClientRef(ProvidedRole role) {
        if (role instanceof InfrastructureProvidedRole) {
            return this._ejbClientRef((InfrastructureProvidedRole)role);
        }
        if (role instanceof OperationProvidedRole) {
            return this._ejbClientRef((OperationProvidedRole)role);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(role).toString());
    }
}

