/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core.resources;

import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.exceptions.ResourceContainerIsMissingRequiredResourceType;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractScheduledResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractSimulatedResourceContainer {
    protected static final Logger LOGGER = Logger.getLogger((String)AbstractSimulatedResourceContainer.class.getName());
    protected final SimuComModel myModel;
    protected final String myContainerID;
    protected HashMap<String, AbstractScheduledResource> activeResources = new HashMap();
    protected final HashMap<String, String> activeResourceProvidedInterfaces = new HashMap();

    public AbstractSimulatedResourceContainer(SimuComModel myModel, String myContainerID) {
        this.myModel = myModel;
        this.myContainerID = myContainerID;
        if (LOGGER.isEnabledFor((Priority)Level.DEBUG)) {
            LOGGER.debug((Object)("Simulated Resource Container created. ContainerID " + myContainerID));
        }
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, String typeID, double demand) {
        AbstractScheduledResource resource = this.activeResources.get(typeID);
        if (resource == null) {
            throw new ResourceContainerIsMissingRequiredResourceType(typeID);
        }
        resource.consumeResource(requestingProcess, 1, Collections.emptyMap(), demand);
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, String providedInterfaceID, int resourceServiceID, double demand) {
        AbstractScheduledResource resource = null;
        String typeID = this.activeResourceProvidedInterfaces.get(providedInterfaceID);
        if (typeID != null) {
            resource = this.activeResources.get(typeID);
        }
        if (resource == null) {
            throw new ResourceContainerIsMissingRequiredResourceType(typeID);
        }
        resource.consumeResource(requestingProcess, resourceServiceID, Collections.emptyMap(), demand);
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, String providedInterfaceID, int resourceServiceID, Map<String, Serializable> parameterMap, double demand) {
        AbstractScheduledResource resource = null;
        String typeID = this.activeResourceProvidedInterfaces.get(providedInterfaceID);
        if (typeID != null) {
            resource = this.activeResources.get(typeID);
        }
        if (resource == null) {
            throw new ResourceContainerIsMissingRequiredResourceType(typeID);
        }
        resource.consumeResource(requestingProcess, resourceServiceID, parameterMap, demand);
    }

    public Collection<AbstractScheduledResource> getActiveResources() {
        return this.activeResources.values();
    }

    public HashMap<String, AbstractScheduledResource> getAllActiveResources() {
        return this.activeResources;
    }

    public List<AbstractScheduledResource> getFailedResources() {
        ArrayList<AbstractScheduledResource> resultList = new ArrayList<AbstractScheduledResource>();
        for (AbstractScheduledResource resource : this.getActiveResources()) {
            if (resource.isAvailable() || !resource.isRequiredByContainer()) continue;
            resultList.add(resource);
        }
        return resultList;
    }

    public String getResourceContainerID() {
        return this.myContainerID;
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, int resourceServiceID, String typeID, double demand) {
        AbstractScheduledResource resource = this.activeResources.get(typeID);
        if (resource == null) {
            throw new ResourceContainerIsMissingRequiredResourceType(typeID);
        }
        resource.consumeResource(requestingProcess, resourceServiceID, Collections.emptyMap(), demand);
    }
}

