/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.exceptions.ResourceContainerNotFound;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.IAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.core.resources.ISimulatedModelEntityAccess;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public abstract class Context
extends StackContext {
    private static final long serialVersionUID = -1869414754329617190L;
    private ResourceRegistry registry = null;
    private SimuComSimProcess myThread = null;
    private final SimuComModel myModel;
    private final IResourceTableManager resourceTableManager;

    public Context(SimuComModel myModel, IResourceTableManager resourceTableManager) {
        this.myModel = myModel;
        if (myModel != null) {
            this.registry = myModel.getResourceRegistry();
        } else {
            this.stack.createAndPushNewStackFrame();
        }
        this.resourceTableManager = resourceTableManager;
    }

    public IResourceTableManager getResourceTableManager() {
        return this.resourceTableManager;
    }

    public long getSessionId() {
        return this.myThread.getCurrentSessionId();
    }

    public AbstractSimulatedResourceContainer findResource(String assemblyContextID) {
        AbstractSimulatedResourceContainer container = this.getAssemblyAllocationLookup().getAllocatedEntity(assemblyContextID);
        if (container == null) {
            throw new ResourceContainerNotFound("Resource container for assembly context " + assemblyContextID + " not found. Check your allocation model. " + "Note that a SubSystem must only be used once in one System, using one several times may cause this error. ");
        }
        return container;
    }

    public SimulatedLinkingResourceContainer findLinkingResource(String linkingResourceContainerID) {
        AbstractSimulatedResourceContainer container = this.registry.getResourceContainer(linkingResourceContainerID);
        if (container == null || !(container instanceof SimulatedLinkingResourceContainer)) {
            throw new ResourceContainerNotFound("Linking resource container for container ID " + linkingResourceContainerID + " not found.");
        }
        return (SimulatedLinkingResourceContainer)container;
    }

    public abstract IAssemblyAllocationLookup<AbstractSimulatedResourceContainer> getAssemblyAllocationLookup();

    public ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer> getSimulatedResourceContainerAccess() {
        return this.registry::getResourceContainer;
    }

    public SimuComSimProcess getThread() {
        return this.myThread;
    }

    public void setSimProcess(SimuComSimProcess process) {
        this.myThread = process;
    }

    public SimuComModel getModel() {
        return this.myModel;
    }
}

