/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core.resources;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.processes.IWaitingProcess;
import de.uka.ipd.sdq.scheduler.processes.SimpleWaitingProcess;
import de.uka.ipd.sdq.scheduler.resources.AbstractSimResource;
import de.uka.ipd.sdq.scheduler.resources.passive.PassiveResourceObservee;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import de.uka.ipd.sdq.simucomframework.core.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.PassiveResourceTimeoutEvent;
import de.uka.ipd.sdq.simulation.abstractsimengine.IEntity;
import java.util.ArrayDeque;
import java.util.Queue;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public class SimSimpleFairPassiveResource
extends AbstractSimResource
implements IPassiveResource {
    protected Queue<IWaitingProcess> waitingQueue;
    private final SchedulerModel myModel;
    private long available;
    private final String passiveResourceID;
    private final boolean simulateFailures;
    private final PassiveResourceObservee observee;
    private final PassiveResource resource;
    private final AssemblyContext assemblyContext;

    public SimSimpleFairPassiveResource(PassiveResource resource, AssemblyContext assemblyContext, SchedulerModel model, Long capacity) {
        super(model, capacity.longValue(), resource.getEntityName(), String.valueOf(resource.getId()) + ":" + assemblyContext.getId());
        this.resource = resource;
        this.assemblyContext = assemblyContext;
        this.waitingQueue = new ArrayDeque<IWaitingProcess>();
        this.myModel = model;
        this.passiveResourceID = resource.getId();
        this.observee = new PassiveResourceObservee();
        this.available = capacity;
        this.simulateFailures = this.myModel instanceof SimuComModel ? ((SimuComModel)model).getConfiguration().getSimulateFailures() : false;
    }

    private boolean canProceed(ISchedulableProcess process, long num) {
        return (this.waitingQueue.isEmpty() || this.waitingQueue.peek().getProcess().equals(process)) && num <= this.available;
    }

    public PassiveResource getResource() {
        return this.resource;
    }

    public AssemblyContext getAssemblyContext() {
        return this.assemblyContext;
    }

    public Queue<IWaitingProcess> getWaitingProcesses() {
        return this.waitingQueue;
    }

    private void grantAccess(ISchedulableProcess process, long num) {
        LoggingWrapper.log((String)("Process " + process + " acquires " + num + " of " + (Object)((Object)this)));
        this.available -= num;
        this.observee.fireAquire(process, num);
        assert (this.available >= 0L) : "More resource than available have been acquired!";
    }

    public boolean acquire(ISchedulableProcess schedulableProcess, long num, boolean timeout, double timeoutValue) {
        if (!this.myModel.getSimulationControl().isRunning()) {
            return true;
        }
        this.observee.fireRequest(schedulableProcess, num);
        if (this.canProceed(schedulableProcess, num)) {
            this.grantAccess(schedulableProcess, num);
            return true;
        }
        LoggingWrapper.log((String)("Process " + schedulableProcess + " is waiting for " + num + " of " + (Object)((Object)this)));
        SimpleWaitingProcess process = new SimpleWaitingProcess(this.myModel, schedulableProcess, num);
        this.processTimeout(timeout, timeoutValue, process);
        this.waitingQueue.add((IWaitingProcess)process);
        schedulableProcess.passivate();
        return false;
    }

    private void processTimeout(boolean timeout, double timeoutValue, SimpleWaitingProcess process) {
        if (!this.simulateFailures || !timeout) {
            return;
        }
        SimuComModel simuComModel = (SimuComModel)this.myModel;
        if (timeoutValue == 0.0) {
            FailureException.raise(simuComModel, simuComModel.getFailureStatistics().getResourceTimeoutFailureType(this.assemblyContext.getId(), this.passiveResourceID));
        }
        if (timeoutValue > 0.0) {
            PassiveResourceTimeoutEvent event = new PassiveResourceTimeoutEvent(simuComModel, this.myModel, this, process);
            event.schedule((IEntity)process, timeoutValue);
        }
    }

    protected String getPassiveResourceID() {
        return this.passiveResourceID;
    }

    public void release(ISchedulableProcess schedulableProcess, long num) {
        if (!this.myModel.getSimulationControl().isRunning()) {
            return;
        }
        LoggingWrapper.log((String)("Process " + schedulableProcess + " releases " + num + " of " + (Object)((Object)this)));
        this.available += num;
        this.observee.fireRelease(schedulableProcess, num);
        this.notifyWaitingProcesses();
    }

    private void notifyWaitingProcesses() {
        SimpleWaitingProcess waitingProcess = (SimpleWaitingProcess)this.waitingQueue.peek();
        while (waitingProcess != null && this.canProceed(waitingProcess.getProcess(), waitingProcess.getNumRequested())) {
            this.grantAccess(waitingProcess.getProcess(), waitingProcess.getNumRequested());
            this.waitingQueue.remove();
            waitingProcess.getProcess().activate();
            waitingProcess = (SimpleWaitingProcess)this.waitingQueue.peek();
        }
    }

    public void addObserver(IPassiveResourceSensor observer) {
        this.observee.addObserver(observer);
    }

    public void removeObserver(IPassiveResourceSensor observer) {
        this.observee.removeObserver(observer);
    }

    public long getAvailable() {
        return this.available;
    }

    public boolean isWaiting(SimpleWaitingProcess process) {
        return this.waitingQueue.contains(process);
    }

    public void remove(SimpleWaitingProcess process) {
        this.waitingQueue.remove(process);
    }
}

