/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core.resources;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.core.probes.TakePassiveResourceStateProbe;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeScheduledResourceDemandProbe;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeScheduledResourceStateProbe;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeScheduledResourceUtilization;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.IOverallUtilizationListener;
import de.uka.ipd.sdq.simucomframework.core.resources.IStateListener;
import de.uka.ipd.sdq.simucomframework.core.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResource;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.ResourceURIMeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.LinkingResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.TriggeredProbeList;

public final class CalculatorHelper {
    private static final MeasuringpointFactory MEASURINGPOINT_FACTORY = MeasuringpointFactory.eINSTANCE;
    private static final PcmmeasuringpointFactory PCM_MEASURINGPOINT_FACTORY = PcmmeasuringpointFactory.eINSTANCE;
    private static final MeasuringPointRepository MEASURING_POINT_REPOSITORY = MEASURINGPOINT_FACTORY.createMeasuringPointRepository();

    public static Calculator setupWaitingTimeCalculator(IPassiveResource resource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        final List<Probe> startStopProbes = CalculatorHelper.buildStartStopProbes(model);
        resource.addObserver(new IPassiveResourceSensor(){

            public void request(ISchedulableProcess process, long num) {
                ((TriggeredProbe)startStopProbes.get(0)).takeMeasurement(new RequestContext(process.getId()));
            }

            public void acquire(ISchedulableProcess process, long num) {
                ((TriggeredProbe)startStopProbes.get(1)).takeMeasurement(new RequestContext(process.getId()));
            }

            public void release(ISchedulableProcess process, long num) {
            }
        });
        return ctx.getCalculatorFactory().buildWaitingTimeCalculator(measuringPoint, startStopProbes);
    }

    public static Calculator setupWaitingTimeCalculator(IPassiveResource resource, SimuComModel model) {
        return CalculatorHelper.setupWaitingTimeCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    public static Calculator setupHoldTimeCalculator(IPassiveResource resource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        final List<Probe> startStopProbes = CalculatorHelper.buildStartStopProbes(model);
        resource.addObserver(new IPassiveResourceSensor(resource){
            long capacity;
            {
                this.capacity = iPassiveResource.getCapacity();
            }

            public void request(ISchedulableProcess process, long num) {
            }

            public void acquire(ISchedulableProcess process, long num) {
                if (this.capacity == 1L) {
                    ((TriggeredProbe)startStopProbes.get(0)).takeMeasurement(new RequestContext("1"));
                } else {
                    ((TriggeredProbe)startStopProbes.get(0)).takeMeasurement(new RequestContext(process.getId()));
                }
            }

            public void release(ISchedulableProcess process, long num) {
                if (this.capacity == 1L) {
                    ((TriggeredProbe)startStopProbes.get(1)).takeMeasurement(new RequestContext("1"));
                } else {
                    ((TriggeredProbe)startStopProbes.get(1)).takeMeasurement(new RequestContext(process.getId()));
                }
            }
        });
        return ctx.getCalculatorFactory().buildHoldingTimeCalculator(measuringPoint, startStopProbes);
    }

    public static Calculator setupHoldTimeCalculator(IPassiveResource resource, SimuComModel model) {
        return CalculatorHelper.setupHoldTimeCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    protected static List<Probe> buildStartStopProbes(SimuComModel model) {
        return Arrays.asList(new Probe[]{new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)model.getSimulationControl()), new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)model.getSimulationControl())});
    }

    public static Calculator setupDemandCalculator(AbstractScheduledResource scheduledResource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        EventProbeList scheduledResourceProbe = CalculatorHelper.getEventProbeSetWithCurrentTime(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC_TUPLE, model.getSimulationControl(), new TakeScheduledResourceDemandProbe(scheduledResource));
        return ctx.getCalculatorFactory().buildResourceDemandCalculator(measuringPoint, (Probe)scheduledResourceProbe);
    }

    public static Calculator setupDemandCalculator(AbstractScheduledResource scheduledResource, SimuComModel model) {
        return CalculatorHelper.setupDemandCalculator(scheduledResource, model, CalculatorHelper.createMeasuringPoint(scheduledResource));
    }

    public static Calculator setupActiveResourceStateCalculator(AbstractScheduledResource scheduledResource, SimuComModel model, MeasuringPoint measuringPoint, int replicaID) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        TriggeredProbeList scheduledResourceProbe = CalculatorHelper.getTriggeredProbeSetWithCurrentTime(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, model.getSimulationControl(), (TriggeredProbe)new TakeScheduledResourceStateProbe(scheduledResource, replicaID));
        Calculator calculator = ctx.getCalculatorFactory().buildStateOfActiveResourceCalculator(measuringPoint, (Probe)scheduledResourceProbe);
        scheduledResource.addStateListener(new IStateListener((TriggeredProbe)scheduledResourceProbe){
            private final /* synthetic */ TriggeredProbe val$scheduledResourceProbe;
            {
                this.val$scheduledResourceProbe = triggeredProbe;
            }

            @Override
            public void stateChanged(long state, int instanceId) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }
        }, replicaID);
        scheduledResourceProbe.takeMeasurement();
        return calculator;
    }

    public static List<Calculator> setupActiveResourceStateCalculators(AbstractScheduledResource scheduledResource, SimuComModel model) {
        ArrayList calculators = new ArrayList(scheduledResource.getNumberOfInstances());
        int instance = 0;
        while (instance < scheduledResource.getNumberOfInstances()) {
            MeasuringPoint measurementPoint = CalculatorHelper.createMeasuringPoint(scheduledResource, instance);
            CalculatorHelper.setupActiveResourceStateCalculator(scheduledResource, model, measurementPoint, instance);
            ++instance;
        }
        return Collections.unmodifiableList(calculators);
    }

    public static Calculator setupOverallUtilizationCalculator(AbstractScheduledResource scheduledResource, SimuComModel model, MeasuringPoint measuringPoint) {
        TriggeredProbeList scheduledResourceProbe = CalculatorHelper.getTriggeredProbeSetWithCurrentTime(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, model.getSimulationControl(), (TriggeredProbe)new TakeScheduledResourceUtilization(scheduledResource));
        scheduledResource.addOverallUtilizationListener(new IOverallUtilizationListener((TriggeredProbe)scheduledResourceProbe){
            private final /* synthetic */ TriggeredProbe val$scheduledResourceProbe;
            {
                this.val$scheduledResourceProbe = triggeredProbe;
            }

            @Override
            public void utilizationChanged(double resourceDemand, double totalTime) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }
        });
        return model.getProbeFrameworkContext().getGenericCalculatorFactory().buildCalculator(scheduledResourceProbe.getMetricDesciption(), measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)scheduledResourceProbe));
    }

    public static Calculator setupOverallUtilizationCalculator(AbstractScheduledResource resource, SimuComModel model) {
        return CalculatorHelper.setupOverallUtilizationCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    public static Calculator setupPassiveResourceStateCalculator(IPassiveResource resource, SimuComModel model, MeasuringPoint measuringPoint) {
        ProbeFrameworkContext ctx = model.getProbeFrameworkContext();
        TriggeredProbeList scheduledResourceProbe = CalculatorHelper.getTriggeredProbeSetWithCurrentTime(MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC_TUPLE, model.getSimulationControl(), (TriggeredProbe)new TakePassiveResourceStateProbe(resource));
        Calculator calculator = ctx.getCalculatorFactory().buildStateOfPassiveResourceCalculator(measuringPoint, (Probe)scheduledResourceProbe);
        resource.addObserver(new IPassiveResourceSensor((TriggeredProbe)scheduledResourceProbe){
            private final /* synthetic */ TriggeredProbe val$scheduledResourceProbe;
            {
                this.val$scheduledResourceProbe = triggeredProbe;
            }

            public void request(ISchedulableProcess process, long num) {
            }

            public void release(ISchedulableProcess process, long num) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }

            public void acquire(ISchedulableProcess process, long num) {
                this.val$scheduledResourceProbe.takeMeasurement();
            }
        });
        scheduledResourceProbe.takeMeasurement();
        return calculator;
    }

    public static Calculator setupPassiveResourceStateCalculator(IPassiveResource resource, SimuComModel model) {
        return CalculatorHelper.setupPassiveResourceStateCalculator(resource, model, CalculatorHelper.createMeasuringPoint(resource));
    }

    public static TriggeredProbeList getTriggeredProbeSetWithCurrentTime(MetricSetDescription metricSetDescription, ISimulationControl control, TriggeredProbe additionalProbe) {
        return new TriggeredProbeList((MetricDescription)metricSetDescription, Arrays.asList(new TriggeredProbe[]{new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)control), additionalProbe}));
    }

    public static EventProbeList getEventProbeSetWithCurrentTime(MetricSetDescription metricSetDescription, ISimulationControl control, EventProbe<?> additionalProbe) {
        return new EventProbeList((MetricDescription)metricSetDescription, additionalProbe, Arrays.asList(new TriggeredProbe[]{new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)control)}));
    }

    private static MeasuringPoint createMeasuringPoint(IPassiveResource resource) {
        AssemblyPassiveResourceMeasuringPoint mp = PCM_MEASURINGPOINT_FACTORY.createAssemblyPassiveResourceMeasuringPoint();
        mp.setAssembly(resource.getAssemblyContext());
        mp.setPassiveResource(resource.getResource());
        ResourceURIMeasuringPoint measuringPoint = MEASURINGPOINT_FACTORY.createResourceURIMeasuringPoint();
        measuringPoint.setResourceURI(EMFLoadHelper.getResourceURI((EObject)resource.getResource()));
        measuringPoint.setMeasuringPoint(mp.getStringRepresentation());
        CalculatorHelper.putIntoRepository((MeasuringPoint)measuringPoint);
        return measuringPoint;
    }

    private static MeasuringPoint createMeasuringPoint(AbstractScheduledResource scheduledResource) {
        return CalculatorHelper.createMeasuringPoint(scheduledResource, 0);
    }

    public static MeasuringPoint createMeasuringPoint(AbstractScheduledResource scheduledResource, int replicaID) {
        ActiveResourceMeasuringPoint measuringPoint;
        if (scheduledResource instanceof ScheduledResource) {
            measuringPoint = CalculatorHelper.createActiveResourceMeasuringPoint((ScheduledResource)scheduledResource, replicaID);
        } else if (scheduledResource instanceof SimulatedLinkingResource) {
            measuringPoint = CalculatorHelper.createLinkingResourceMeasuringPoint((SimulatedLinkingResource)scheduledResource);
        } else {
            throw new IllegalArgumentException("Unknown variant of AbstractScheduledResource");
        }
        CalculatorHelper.putIntoRepository((MeasuringPoint)measuringPoint);
        return measuringPoint;
    }

    private static ActiveResourceMeasuringPoint createActiveResourceMeasuringPoint(ScheduledResource scheduledResource, int replicaID) {
        ActiveResourceMeasuringPoint measuringPoint = PCM_MEASURINGPOINT_FACTORY.createActiveResourceMeasuringPoint();
        measuringPoint.setActiveResource(scheduledResource.getActiveResource());
        measuringPoint.setReplicaID(replicaID);
        return measuringPoint;
    }

    private static LinkingResourceMeasuringPoint createLinkingResourceMeasuringPoint(SimulatedLinkingResource simulatedLinkingResource) {
        LinkingResourceMeasuringPoint measuringPoint = PCM_MEASURINGPOINT_FACTORY.createLinkingResourceMeasuringPoint();
        measuringPoint.setLinkingResource(simulatedLinkingResource.getLinkingResource());
        return measuringPoint;
    }

    private static void putIntoRepository(MeasuringPoint measuringPoint) {
        MEASURING_POINT_REPOSITORY.getMeasuringPoints().add((Object)measuringPoint);
        measuringPoint.setMeasuringPointRepository(MEASURING_POINT_REPOSITORY);
    }
}

