/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.simulationdock;

import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import de.uka.ipd.sdq.simulation.core.AbstractSimulationConfig;
import de.uka.ipd.sdq.simulation.core.IStatusObserver;
import java.util.Hashtable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class SimulationProgressReportingObserver
implements IStatusObserver {
    private int lastPercent = 0;
    private AbstractSimulationConfig config;
    private SimulationDockService myDock;
    private EventAdmin eventAdmin;

    public SimulationProgressReportingObserver(AbstractSimulationConfig config, EventAdmin eventAdmin, SimulationDockService dock) {
        this.config = config;
        this.eventAdmin = eventAdmin;
        this.myDock = dock;
    }

    public void updateStatus(int percentDone, double currentSimTime, long measurementsTaken) {
        if (percentDone > this.lastPercent || this.config.isDebug()) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("PERCENT_DONE", percentDone);
            properties.put("CURRENT_TIME", currentSimTime);
            properties.put("MEASUREMENTS_TAKEN", measurementsTaken);
            this.postEvent("de/uka/ipd/sdq/simucomframework/simucomdock/UPDATE_SIM_STATUS", properties);
            this.lastPercent = percentDone;
        }
    }

    private void postEvent(String topic, Hashtable<String, Object> newProperties) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("DOCK_ID", this.myDock.getDockId());
        properties.putAll(newProperties);
        Event event = new Event(topic, properties);
        this.eventAdmin.postEvent(event);
    }
}

