/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.cache;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.print.ProbFunctionPrettyPrint;
import de.uka.ipd.sdq.probfunction.util.ProbfunctionSwitch;
import de.uka.ipd.sdq.stoex.Expression;
import java.util.Collections;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProbFunctionCache {
    private static final Logger LOGGER = Logger.getLogger((String)ProbFunctionCache.class.getName());
    private final HashMap<EObject, IProbabilityFunction> probFunctions = new HashMap();
    private final ProbfunctionSwitch<Object> probFunctionAnnotator = new ProbfunctionSwitch<Object>(){

        public Object caseBoxedPDF(BoxedPDF object) {
            this.adjustPDF(object);
            IProbabilityDensityFunction pdf = null;
            try {
                pdf = IProbabilityFunctionFactory.eINSTANCE.transformToPDF((ProbabilityDensityFunction)object);
                pdf.checkConstrains();
            }
            catch (Exception ex) {
                RuntimeException ex2 = new RuntimeException("PDF not valid: " + (String)new ProbFunctionPrettyPrint().doSwitch((EObject)object) + ". Caused by " + ex.getMessage(), ex);
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)"PMF not valid!", (Throwable)ex2);
                }
                throw ex2;
            }
            ProbFunctionCache.this.probFunctions.put((EObject)object, (IProbabilityFunction)pdf);
            return super.caseBoxedPDF(object);
        }

        private void adjustPDF(BoxedPDF object) {
            EList samples = object.getSamples();
            double sum = 0.0;
            for (ContinuousSample sample : samples) {
                sum += sample.getProbability();
            }
            if (Math.abs(sum - 1.0) > 1.0E-9) {
                String sampleString = "...PDF[";
                for (ContinuousSample continuousSample : samples) {
                    sampleString = String.valueOf(sampleString) + "(" + continuousSample.getValue() + ";" + continuousSample.getProbability() + ")";
                }
                sampleString = String.valueOf(sampleString) + "]";
                double delta = (1.0 - sum) / this.countNonZeroContiniousSamples((EList<ContinuousSample>)samples);
                for (ContinuousSample sample : samples) {
                    if (!(sample.getProbability() > 0.0)) continue;
                    sample.setProbability(sample.getProbability() + delta);
                }
                String sampleStringNew = "...PDF[";
                for (ContinuousSample continuousSample : samples) {
                    sampleStringNew = String.valueOf(sampleStringNew) + "(" + continuousSample.getValue() + ";" + continuousSample.getProbability() + ")";
                }
                sampleStringNew = String.valueOf(sampleStringNew) + "]";
                if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
                    LOGGER.warn((Object)("Probfunction needed adjustment as it didn't sum up to 1! Fix your input specification!! Was: " + sampleString + ", now is: " + sampleStringNew));
                }
            }
        }

        private double countNonZeroContiniousSamples(EList<ContinuousSample> samples) {
            int count = 0;
            for (ContinuousSample s : samples) {
                if (!(s.getProbability() > 0.0)) continue;
                ++count;
            }
            return count;
        }

        private double countNonZeroSamples(EList<Sample> samples) {
            int count = 0;
            for (Sample s : samples) {
                if (!(s.getProbability() > 0.0)) continue;
                ++count;
            }
            return count;
        }

        public Object caseProbabilityMassFunction(ProbabilityMassFunction object) {
            this.adjustPMF(object);
            IProbabilityMassFunction pmf = IProbabilityFunctionFactory.eINSTANCE.transformToPMF(object);
            try {
                pmf.checkConstrains();
            }
            catch (Exception ex) {
                RuntimeException ex2 = new RuntimeException("PMF not valid: " + (String)new ProbFunctionPrettyPrint().doSwitch((EObject)object), ex);
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)"PMF not valid!", (Throwable)ex2);
                }
                throw ex2;
            }
            ProbFunctionCache.this.probFunctions.put((EObject)object, (IProbabilityFunction)pmf);
            return super.caseProbabilityMassFunction(object);
        }

        private void adjustPMF(ProbabilityMassFunction object) {
            EList samples = object.getSamples();
            double sum = 0.0;
            for (Sample sample : samples) {
                sum += sample.getProbability();
            }
            if (Math.abs(sum - 1.0) > 1.0E-9) {
                double delta = (1.0 - sum) / this.countNonZeroSamples((EList<Sample>)samples);
                for (Sample sample : samples) {
                    if (!(sample.getProbability() > 0.0)) continue;
                    sample.setProbability(sample.getProbability() + delta);
                }
                if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
                    LOGGER.warn((Object)"Probfunction needed adjustment as it didn't sum up to 1! Fix your input specification!!");
                }
            }
        }
    };

    public ProbFunctionCache(Expression ex) {
        TreeIterator it = EcoreUtil.getAllContents(Collections.singleton(ex));
        while (it.hasNext()) {
            this.probFunctionAnnotator.doSwitch((EObject)it.next());
        }
    }

    public IProbabilityFunction getProbFunction(EObject e) {
        assert (this.probFunctions.containsKey(e));
        return this.probFunctions.get(e);
    }
}

