/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.probfunction.math.ILognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.IPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.AbstractProbDistFunction;
import java.util.List;

public class LogNormDistFunctionFromMoments
extends AbstractProbDistFunction {
    public LogNormDistFunctionFromMoments(IRandomGenerator random, IPDFFactory factory) {
        super(random, factory);
    }

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        if (NumberConverter.toDouble(parameters.get(0)) < 0.0) {
            return false;
        }
        return !(NumberConverter.toDouble(parameters.get(1)) < 0.0);
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double mean = NumberConverter.toDouble(parameters.get(0));
        double stdev = NumberConverter.toDouble(parameters.get(1));
        double variance = stdev * stdev;
        ILognormalDistribution distribution = this.factory.createLognormalDistributionFromMoments(mean, variance);
        return distribution.inverseF(this.randomGen.random());
    }
}

