/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;
import org.apache.log4j.Logger;

public class MaxDeviationFunction
implements IFunction {
    private static final Logger LOGGER = Logger.getLogger(MaxDeviationFunction.class);
    public static final String MAX_DEVIATION_FUNCTION_NAME = "MaxDeviation";

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 3) {
            return false;
        }
        if (!this.parameterIsNumber(parameters.get(0)) && !(parameters.get(0) instanceof String)) {
            return false;
        }
        if (!(parameters.get(1) instanceof Double)) {
            return false;
        }
        return parameters.get(2) instanceof Double;
    }

    private boolean parameterIsNumber(Object obj) {
        boolean valid = false;
        if (obj instanceof Integer || obj instanceof Byte || obj instanceof Character || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            valid = true;
        }
        return valid;
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        Object value = parameters.get(0);
        Double abs = (Double)parameters.get(1);
        Double rel = (Double)parameters.get(2);
        if (value instanceof Integer) {
            Integer val = (Integer)value;
            if (abs > (double)val.intValue() * rel) {
                return Double.valueOf(Math.ceil((double)val.intValue() + abs)).intValue();
            }
            return Double.valueOf(Math.ceil((double)val.intValue() + (double)val.intValue() * rel)).intValue();
        }
        if (value instanceof Long) {
            Long val = (Long)value;
            if (abs > (double)val.longValue() * rel) {
                return Double.valueOf(Math.ceil((double)val.longValue() + abs)).longValue();
            }
            return Double.valueOf(Math.ceil((double)val.longValue() + (double)val.longValue() * rel)).longValue();
        }
        if (value instanceof Byte) {
            Byte val = (Byte)value;
            if (abs > (double)val.byteValue() * rel) {
                return Double.valueOf(Math.ceil((double)val.byteValue() + abs)).byteValue();
            }
            return Double.valueOf(Math.ceil((double)val.byteValue() + (double)val.byteValue() * rel)).byteValue();
        }
        if (value instanceof Character) {
            Character val = (Character)value;
            if (abs > (double)val.charValue() * rel) {
                return Double.valueOf(Math.ceil((double)val.charValue() + abs)).byteValue();
            }
            return Double.valueOf(Math.ceil((double)val.charValue() + (double)val.charValue() * rel)).byteValue();
        }
        if (value instanceof Float) {
            Float val = (Float)value;
            if (abs > (double)val.floatValue() * rel) {
                return Float.valueOf(Double.valueOf(Math.ceil((double)val.floatValue() + abs)).floatValue());
            }
            return Float.valueOf(Double.valueOf(Math.ceil((double)val.floatValue() + (double)val.floatValue() * rel)).floatValue());
        }
        if (value instanceof Double) {
            Double val = (Double)value;
            if (abs > val * rel) {
                return Math.ceil(val + abs);
            }
            return Math.ceil(val + val * rel);
        }
        if (value instanceof String) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"String/Enum-based parameter was provided to MaxDeviation function. The parameter will be returned directly.");
            }
            return value;
        }
        throw new IllegalArgumentException("Unsupported type of value argument experienced.");
    }
}

