/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;
import org.apache.log4j.Logger;

public class MinDeviationFunction
implements IFunction {
    private static final Logger LOGGER = Logger.getLogger(MinDeviationFunction.class);
    public static final String MIN_DEVIATION_FUNCTION_NAME = "MinDeviation";

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 3) {
            return false;
        }
        if (!this.parameterIsNumber(parameters.get(0)) && !(parameters.get(0) instanceof String)) {
            return false;
        }
        if (!(parameters.get(1) instanceof Double)) {
            return false;
        }
        return parameters.get(2) instanceof Double;
    }

    private boolean parameterIsNumber(Object obj) {
        boolean valid = false;
        if (obj instanceof Integer || obj instanceof Byte || obj instanceof Character || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            valid = true;
        }
        return valid;
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        Object value = parameters.get(0);
        if (value instanceof String) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"String/Enum-based parameter was provided to MinDeviation Function. The parameter will be directly returned.");
            }
            return value;
        }
        Double abs = (Double)parameters.get(1);
        Double rel = (Double)parameters.get(2);
        if (value instanceof Integer) {
            Integer val = (Integer)value;
            if (abs > (double)val.intValue() * rel) {
                return Double.valueOf(Math.floor((double)val.intValue() - abs)).intValue();
            }
            return Double.valueOf(Math.floor((double)val.intValue() - (double)val.intValue() * rel)).intValue();
        }
        if (value instanceof Long) {
            Long val = (Long)value;
            if (abs > (double)val.longValue() * rel) {
                return Double.valueOf(Math.floor((double)val.longValue() - abs)).longValue();
            }
            return Double.valueOf(Math.floor((double)val.longValue() - (double)val.longValue() * rel)).longValue();
        }
        if (value instanceof Byte) {
            Byte val = (Byte)value;
            if (abs > (double)val.byteValue() * rel) {
                return Double.valueOf(Math.floor((double)val.byteValue() - abs)).byteValue();
            }
            return Double.valueOf(Math.floor((double)val.byteValue() - (double)val.byteValue() * rel)).byteValue();
        }
        if (value instanceof Character) {
            Character val = (Character)value;
            if (abs > (double)val.charValue() * rel) {
                return Double.valueOf(Math.floor((double)val.charValue() - abs)).byteValue();
            }
            return Double.valueOf(Math.floor((double)val.charValue() - (double)val.charValue() * rel)).byteValue();
        }
        if (value instanceof Float) {
            Float val = (Float)value;
            if (abs > (double)val.floatValue() * rel) {
                return Float.valueOf(Double.valueOf(Math.floor((double)val.floatValue() - abs)).floatValue());
            }
            return Float.valueOf(Double.valueOf(Math.floor((double)val.floatValue() - (double)val.floatValue() * rel)).floatValue());
        }
        if (value instanceof Double) {
            Double val = (Double)value;
            if (abs > val * rel) {
                return Math.floor(val - abs);
            }
            return Math.floor(val - val * rel);
        }
        throw new IllegalArgumentException("Unsupported type of value argument experienced.");
    }
}

