/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.Context;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.usage.IUser;
import de.uka.ipd.sdq.simucomframework.core.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.ICancellableWorkloadDriver;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class OpenWorkload
extends SimuComSimProcess
implements ICancellableWorkloadDriver {
    private String interArrivalTime;
    private final IUserFactory userFactory;
    private boolean cancelled = false;
    private static final Logger LOGGER = Logger.getLogger((String)OpenWorkload.class.getName());

    public OpenWorkload(SimuComModel model, IUserFactory userFactory, String interArrivalTime, IResourceTableManager resourceTableManager) {
        super(model, "OpenWorkloadUserMaturationChamber", resourceTableManager);
        this.interArrivalTime = interArrivalTime;
        this.userFactory = userFactory;
    }

    public void run() {
        this.cancelled = false;
        this.scheduleAt(0.0);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    protected void internalLifeCycle() {
        while (this.getModel().getSimulationControl().isRunning() && !this.cancelled) {
            try {
                this.generateUser();
                this.waitForNextUser();
                if (!this.getModel().getConfiguration().getSimulateFailures()) continue;
                this.getModel().getFailureStatistics().increaseRunCount();
                this.getModel().getFailureStatistics().printRunCount(LOGGER, this.getModel().getSimulationControl().getCurrentSimulationTime());
            }
            catch (OutOfMemoryError e) {
                if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                    LOGGER.info((Object)"Stopping simulation run due to memory constraints.");
                }
                this.getModel().getSimulationControl().stop();
            }
        }
        if (this.getModel().getConfiguration().getSimulateFailures()) {
            this.getModel().getFailureStatistics().printHandledFailuresStatistics(LOGGER, this.getModel().getSimulationControl().getCurrentSimulationTime());
        }
    }

    private void waitForNextUser() {
        double interArrivalTimeSample = (Double)Context.evaluateStatic((String)this.interArrivalTime, Double.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Waiting for " + interArrivalTimeSample + " before spawing the next user"));
        }
        this.hold(interArrivalTimeSample);
    }

    private IUser generateUser() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Spawning New User...");
        }
        IUser user = this.userFactory.createUser();
        user.startUserLife();
        return user;
    }

    public IUserFactory getUserFactory() {
        return this.userFactory;
    }

    public void setInterarrivalTime(String newInterarrivalTime) {
        this.interArrivalTime = newInterarrivalTime;
    }
}

