/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class SimuComFactory {
    private static final Logger LOGGER = Logger.getLogger(SimuComFactory.class);

    public static SimuComModel getSimuComModel(SimuComConfig config, SimuComStatus simuComStatus, boolean isRemote, IResourceTableManager resourceTableManager) {
        ISimEngineFactory factory = null;
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("de.uka.ipd.sdq.simulation.abstractsimengine.engine");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                if (configurationElement.getAttribute("id").equals(config.getEngine())) {
                    factory = (ISimEngineFactory)configurationElement.createExecutableExtension("class");
                }
            }
            catch (CoreException e) {
                if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
                    LOGGER.warn((Object)"Could not get factory for registered simulation engine.", (Throwable)e);
                }
                factory = null;
            }
            ++n2;
        }
        if (factory == null) {
            throw new RuntimeException("No Simulation Engine available. Please install at least one engine.");
        }
        SimuComModel model = new SimuComModel(config, simuComStatus, factory, isRemote, resourceTableManager);
        return model;
    }
}

