package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.pcm.transformations.Helper;
import java.util.Arrays;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.analyzer.quality.QualityRepository;
import org.palladiosimulator.analyzer.quality.parameters.ParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMOperationParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMParameterReference;
import org.palladiosimulator.analyzer.quality.parameters.pcm.PCMRequiredBusinessOperationReturnParameterReference;
import org.palladiosimulator.analyzer.quality.qualityannotation.CharacterisedPCMParameterPartition;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMServiceSpecification;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotation;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;

@SuppressWarnings("all")
public class SimAccuracyInfluenceExt {
  private QualityRepository qualityAnnotationRepository;

  public String getResourceName(final ResourceDemandingSEFF seff) {
    return Helper.getResourceFileName(seff);
  }

  public String getResourceName(final CharacterisedPCMParameterPartition partition) {
    return Helper.getResourceFileName(partition);
  }

  public QualityRepository getQualityAnnotationRepository() {
    return this.qualityAnnotationRepository;
  }

  public QualityRepository setQualityAnnotationRepository(final QualityRepository qualityAnnotationRepository) {
    return this.qualityAnnotationRepository = qualityAnnotationRepository;
  }

  public QualityAnnotation getQualityAnnotation(final ResourceDemandingSEFF rdseff) {
    QualityAnnotation _xifexpression = null;
    boolean _equals = Objects.equal(this.qualityAnnotationRepository, null);
    if (_equals) {
      return null;
    } else {
      final Function1<QualityAnnotation, Boolean> _function = (QualityAnnotation qa) -> {
        return Boolean.valueOf(((qa.getForServiceSpecification() instanceof PCMServiceSpecification) && Objects.equal(((PCMServiceSpecification) qa.getForServiceSpecification()).getResourceDemandingSEFF(), rdseff)));
      };
      _xifexpression = IterableExtensions.<QualityAnnotation>findFirst(Iterables.<QualityAnnotation>filter(this.qualityAnnotationRepository.getQualityStatements(), QualityAnnotation.class), _function);
    }
    return _xifexpression;
  }

  protected String _getSimuComId(final ParameterReference ref) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ERROR: Unknown type of parameter reference.");
    _builder.newLine();
    return _builder.toString();
  }

  protected String _getSimuComId(final PCMParameterReference ref) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ERROR: Unknown type of PCM parameter reference.");
    _builder.newLine();
    return _builder.toString();
  }

  protected String _getSimuComId(final PCMOperationParameterReference ref) {
    return ref.getParameter().getParameterName();
  }

  protected String _getSimuComId(final PCMComponentParameterReference ref) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ERROR: Unknown type of parameter reference.");
    _builder.newLine();
    return _builder.toString();
  }

  protected String _getSimuComId(final PCMRequiredBusinessOperationReturnParameterReference ref) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("RETURN");
    _builder.newLine();
    return _builder.toString();
  }

  public String getSimuComId(final ParameterReference ref) {
    if (ref instanceof PCMComponentParameterReference) {
      return _getSimuComId((PCMComponentParameterReference)ref);
    } else if (ref instanceof PCMOperationParameterReference) {
      return _getSimuComId((PCMOperationParameterReference)ref);
    } else if (ref instanceof PCMRequiredBusinessOperationReturnParameterReference) {
      return _getSimuComId((PCMRequiredBusinessOperationReturnParameterReference)ref);
    } else if (ref instanceof PCMParameterReference) {
      return _getSimuComId((PCMParameterReference)ref);
    } else if (ref != null) {
      return _getSimuComId(ref);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ref).toString());
    }
  }
}
